/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.util.Iterator;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.UnitOfWorkListener;

public abstract class Lob
implements UnitOfWorkListener {
    public static final int STRING = 2;
    public static final int ASCII_STREAM = 4;
    public static final int UNICODE_STREAM = 8;
    public static final int CHARACTER_STREAM = 16;
    public static final int BINARY_STREAM = 32;
    public static final int BINARY_STRING = 64;
    protected Agent agent_;
    protected int dataType_ = 0;
    protected long sqlLength_;
    protected boolean lengthObtained_;

    protected Lob(Agent agent) {
        this.agent_ = agent;
        this.lengthObtained_ = false;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public long sqlLength() throws SqlException {
        this.checkForClosedConnection();
        return this.sqlLength_;
    }

    public void listenToUnitOfWork() {
        this.agent_.connection_.CommitAndRollbackListeners_.add(this);
    }

    public void completeLocalCommit(Iterator iterator) {
        iterator.remove();
    }

    public void completeLocalRollback(Iterator iterator) {
        iterator.remove();
    }

    public Agent getAgent() {
        return this.agent_;
    }

    void checkForClosedConnection() throws SqlException {
        if (this.agent_.connection_.isClosedX()) {
            this.agent_.checkForDeferredExceptions();
            throw new SqlException(this.agent_.logWriter_, "Lob method called after connection was closed");
        }
        this.agent_.checkForDeferredExceptions();
    }

    void completeLocalRollback() {
    }

    void completeLocalCommit() {
    }
}

