/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.DisconnectException;
import org.apache.derby.client.am.LogWriter;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.Statement;
import org.apache.derby.client.am.Utils;
import org.apache.derby.client.net.CcsidManager;
import org.apache.derby.client.net.CodePoint;
import org.apache.derby.client.net.ConnectionReply;
import org.apache.derby.client.net.ConnectionRequestInterface;
import org.apache.derby.client.net.EbcdicCcsidManager;
import org.apache.derby.client.net.NetConnection;
import org.apache.derby.client.net.NetConnectionReply;
import org.apache.derby.client.net.NetConnectionRequest;
import org.apache.derby.client.net.NetLogWriter;
import org.apache.derby.client.net.NetPackageReply;
import org.apache.derby.client.net.NetPackageRequest;
import org.apache.derby.client.net.NetResultSetReply;
import org.apache.derby.client.net.NetResultSetRequest;
import org.apache.derby.client.net.NetStatementReply;
import org.apache.derby.client.net.NetStatementRequest;
import org.apache.derby.client.net.NetXAConnectionReply;
import org.apache.derby.client.net.NetXAConnectionRequest;
import org.apache.derby.client.net.OpenSocketAction;
import org.apache.derby.client.net.Reply;
import org.apache.derby.client.net.Request;
import org.apache.derby.client.net.ResultSetReply;
import org.apache.derby.client.net.ResultSetRequestInterface;
import org.apache.derby.client.net.StatementReply;
import org.apache.derby.client.net.StatementRequestInterface;
import org.apache.derby.client.net.Typdef;

public class NetAgent
extends Agent {
    public ConnectionRequestInterface connectionRequest_;
    public NetConnectionRequest packageRequest_;
    public StatementRequestInterface statementRequest_;
    public ResultSetRequestInterface resultSetRequest_;
    public ConnectionReply connectionReply_;
    public ConnectionReply packageReply_;
    public StatementReply statementReply_;
    public ResultSetReply resultSetReply_;
    NetConnection netConnection_;
    protected Request request_;
    public NetConnectionRequest netConnectionRequest_;
    public NetPackageRequest netPackageRequest_;
    public NetStatementRequest netStatementRequest_;
    public NetResultSetRequest netResultSetRequest_;
    protected Reply reply_;
    public NetConnectionReply netConnectionReply_;
    public NetPackageReply netPackageReply_;
    public NetStatementReply netStatementReply_;
    public NetResultSetReply netResultSetReply_;
    Socket socket_;
    InputStream rawSocketInputStream_;
    OutputStream rawSocketOutputStream_;
    String server_;
    int port_;
    public CcsidManager sourceCcsidManager_;
    public CcsidManager targetCcsidManager_;
    public Typdef typdef_;
    public Typdef targetTypdef_;
    public Typdef originalTargetTypdef_;
    protected int svrcod_;
    public int orignalTargetSqlam_;
    public int targetSqlam_;
    public SqlException exceptionOpeningSocket_;

    public NetAgent(NetConnection netConnection, LogWriter logWriter) throws SqlException {
        super(netConnection, logWriter);
        this.targetSqlam_ = this.orignalTargetSqlam_ = 7;
        this.exceptionOpeningSocket_ = null;
        this.netConnection_ = netConnection;
    }

    NetAgent(NetConnection netConnection, LogWriter logWriter, int n, String string, int n2) throws SqlException {
        super(netConnection, logWriter);
        this.targetSqlam_ = this.orignalTargetSqlam_ = 7;
        this.exceptionOpeningSocket_ = null;
        this.server_ = string;
        this.port_ = n2;
        this.netConnection_ = netConnection;
        if (this.server_ == null) {
            throw new DisconnectException((Agent)this, "Required property \"serverName\" not set");
        }
        try {
            this.socket_ = (Socket)AccessController.doPrivileged(new OpenSocketAction(string, n2));
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new DisconnectException((Agent)this, privilegedActionException.getClass().getName() + " : Error opening socket to server " + string + " on port " + n2 + " with message : " + privilegedActionException.getMessage());
        }
        try {
            if (this.exceptionOpeningSocket_ == null) {
                this.socket_.setTcpNoDelay(true);
                this.socket_.setKeepAlive(true);
                this.socket_.setSoTimeout(n * 1000);
            }
        }
        catch (SocketException socketException) {
            try {
                this.socket_.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.exceptionOpeningSocket_ = new DisconnectException((Agent)this, "SocketException '" + socketException.getMessage() + "'");
        }
        try {
            if (this.exceptionOpeningSocket_ == null) {
                this.rawSocketOutputStream_ = this.socket_.getOutputStream();
                this.rawSocketInputStream_ = this.socket_.getInputStream();
            }
        }
        catch (IOException iOException) {
            try {
                this.socket_.close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            this.exceptionOpeningSocket_ = new DisconnectException((Agent)this, "unable to open stream on socket '" + iOException.getMessage() + "'");
        }
        this.targetCcsidManager_ = this.sourceCcsidManager_ = new EbcdicCcsidManager();
        if (this.netConnection_.isXAConnection()) {
            NetXAConnectionReply netXAConnectionReply = new NetXAConnectionReply(this, this.netConnection_.commBufferSize_);
            this.netResultSetReply_ = netXAConnectionReply;
            this.netStatementReply_ = this.netResultSetReply_;
            this.netPackageReply_ = this.netStatementReply_;
            this.netConnectionReply_ = this.netPackageReply_;
            this.reply_ = this.netConnectionReply_;
            this.resultSetReply_ = new ResultSetReply(this, this.netResultSetReply_, this.netStatementReply_, this.netConnectionReply_);
            this.statementReply_ = this.resultSetReply_;
            this.connectionReply_ = this.packageReply_ = this.statementReply_;
            NetXAConnectionRequest netXAConnectionRequest = new NetXAConnectionRequest(this, this.sourceCcsidManager_, this.netConnection_.commBufferSize_);
            this.netResultSetRequest_ = netXAConnectionRequest;
            this.netStatementRequest_ = this.netResultSetRequest_;
            this.netPackageRequest_ = this.netStatementRequest_;
            this.netConnectionRequest_ = this.netPackageRequest_;
            this.request_ = this.netConnectionRequest_;
            this.resultSetRequest_ = this.netResultSetRequest_;
            this.statementRequest_ = this.netStatementRequest_;
            this.packageRequest_ = this.netPackageRequest_;
            this.connectionRequest_ = this.netConnectionRequest_;
        } else {
            this.netResultSetReply_ = new NetResultSetReply(this, this.netConnection_.commBufferSize_);
            this.netStatementReply_ = this.netResultSetReply_;
            this.netPackageReply_ = this.netStatementReply_;
            this.netConnectionReply_ = this.netPackageReply_;
            this.reply_ = this.netConnectionReply_;
            this.resultSetReply_ = new ResultSetReply(this, this.netResultSetReply_, this.netStatementReply_, this.netConnectionReply_);
            this.statementReply_ = this.resultSetReply_;
            this.connectionReply_ = this.packageReply_ = this.statementReply_;
            this.netResultSetRequest_ = new NetResultSetRequest(this, this.sourceCcsidManager_, this.netConnection_.commBufferSize_);
            this.netStatementRequest_ = this.netResultSetRequest_;
            this.netPackageRequest_ = this.netStatementRequest_;
            this.netConnectionRequest_ = this.netPackageRequest_;
            this.request_ = this.netConnectionRequest_;
            this.resultSetRequest_ = this.netResultSetRequest_;
            this.statementRequest_ = this.netStatementRequest_;
            this.packageRequest_ = this.netPackageRequest_;
            this.connectionRequest_ = this.netConnectionRequest_;
        }
    }

    protected void resetAgent_(LogWriter logWriter, int n, String string, int n2) throws SqlException {
        this.targetTypdef_ = this.originalTargetTypdef_;
        this.svrcod_ = 0;
        try {
            this.socket_.setSoTimeout(n * 1000);
        }
        catch (SocketException socketException) {
            try {
                this.socket_.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new SqlException(this.logWriter_, socketException, "SocketException '" + socketException.getMessage() + "'");
        }
    }

    void setSvrcod(int n) {
        if (n > this.svrcod_) {
            this.svrcod_ = n;
        }
    }

    void clearSvrcod() {
        this.svrcod_ = CodePoint.SVRCOD_INFO;
    }

    int getSvrcod() {
        return this.svrcod_;
    }

    public void flush_() throws DisconnectException {
        this.sendRequest();
        this.reply_.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close_() throws SqlException {
        SqlException sqlException;
        SqlException sqlException2 = null;
        if (this.rawSocketInputStream_ != null) {
            try {
                this.rawSocketInputStream_.close();
            }
            catch (IOException iOException) {
                sqlException2 = new SqlException(this.logWriter_, iOException, "A communication error has been detected. Communication protocol being used: {0}. Communication API being used: {1}. Location where the error was detected: {2}. Communication function detecting the error: {3}. Protocol specific error codes(s) {4}, {5}, {6}. TCP/IP SOCKETS Agent.close() InputStream.close() " + iOException.getMessage() + " " + "* " + "0");
            }
            finally {
                this.rawSocketInputStream_ = null;
            }
        }
        if (this.rawSocketOutputStream_ != null) {
            try {
                this.rawSocketOutputStream_.close();
            }
            catch (IOException iOException) {
                sqlException = new SqlException(this.logWriter_, iOException, "A communication error has been detected. Communication protocol being used: {0}. Communication API being used: {1}. Location where the error was detected: {2}. Communication function detecting the error: {3}. Protocol specific error codes(s) {4}, {5}, {6}. TCP/IP SOCKETS Agent.close() OutputStream.close() " + iOException.getMessage() + " " + "* " + "0");
                sqlException2 = Utils.accumulateSQLException(sqlException, sqlException2);
            }
            finally {
                this.rawSocketOutputStream_ = null;
            }
        }
        if (this.socket_ != null) {
            try {
                this.socket_.close();
            }
            catch (IOException iOException) {
                sqlException = new SqlException(this.logWriter_, iOException, "A communication error has been detected. Communication protocol being used: {0}. Communication API being used: {1}. Location where the error was detected: {2}. Communication function detecting the error: {3}. Protocol specific error codes(s) {4}, {5}, {6}. TCP/IP SOCKETS Agent.close() Socket.close() " + iOException.getMessage() + " " + "* " + "0");
                sqlException2 = Utils.accumulateSQLException(sqlException, sqlException2);
            }
            finally {
                this.socket_ = null;
            }
        }
        if (sqlException2 != null) {
            throw sqlException2;
        }
    }

    protected void sendRequest() throws DisconnectException {
        try {
            this.request_.flush(this.rawSocketOutputStream_);
        }
        catch (IOException iOException) {
            this.throwCommunicationsFailure("NetAgent.sendRequest()", "OutputStream.flush()", iOException.getMessage(), "*");
        }
    }

    public InputStream getInputStream() {
        return this.rawSocketInputStream_;
    }

    public OutputStream getOutputStream() {
        return this.rawSocketOutputStream_;
    }

    void setInputStream(InputStream inputStream) {
        this.rawSocketInputStream_ = inputStream;
    }

    void setOutputStream(OutputStream outputStream) {
        this.rawSocketOutputStream_ = outputStream;
    }

    public void throwCommunicationsFailure(String string, String string2, String string3, String string4) throws DisconnectException {
        this.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException((Agent)this, "A communication error has been detected. Communication protocol being used: " + string + ". " + "Communication API being used: " + string2 + ". " + "Location where the error was detected: " + string3 + ". " + "Communication function detecting the error: " + string4 + ". " + "Protocol specific error codes(s) " + "TCP/IP SOCKETS "));
    }

    public LogWriter newLogWriter_(PrintWriter printWriter, int n) {
        return new NetLogWriter(printWriter, n);
    }

    protected void markChainBreakingException_() {
        this.setSvrcod(CodePoint.SVRCOD_ERROR);
    }

    public void checkForChainBreakingException_() throws SqlException {
        int n = this.getSvrcod();
        this.clearSvrcod();
        if (n > CodePoint.SVRCOD_WARNING) {
            super.checkForExceptions();
        }
    }

    private void writeDeferredResetConnection() throws SqlException {
        if (!this.netConnection_.resetConnectionAtFirstSql_) {
            return;
        }
        try {
            this.netConnection_.writeDeferredReset();
        }
        catch (SqlException sqlException) {
            DisconnectException disconnectException = new DisconnectException((Agent)this, "An error occurred during a deferred connect reset and the connection has been terminated.  See chained exceptions for details.");
            disconnectException.setNextException(sqlException);
            throw disconnectException;
        }
    }

    public void beginWriteChainOutsideUOW() throws SqlException {
        this.request_.initialize();
        this.writeDeferredResetConnection();
        super.beginWriteChainOutsideUOW();
    }

    public void beginWriteChain(Statement statement) throws SqlException {
        this.request_.initialize();
        this.writeDeferredResetConnection();
        super.beginWriteChain(statement);
    }

    protected void endWriteChain() {
        super.endWriteChain();
    }

    private void readDeferredResetConnection() throws SqlException {
        if (!this.netConnection_.resetConnectionAtFirstSql_) {
            return;
        }
        try {
            this.netConnection_.readDeferredReset();
            this.checkForExceptions();
        }
        catch (SqlException sqlException) {
            DisconnectException disconnectException = new DisconnectException((Agent)this, "An error occurred during a deferred connect reset and the connection has been terminated.  See chained exceptions for details.");
            disconnectException.setNextException(sqlException);
            throw disconnectException;
        }
    }

    protected void beginReadChain(Statement statement) throws SqlException {
        this.readDeferredResetConnection();
        super.beginReadChain(statement);
    }

    protected void beginReadChainOutsideUOW() throws SqlException {
        this.readDeferredResetConnection();
        super.beginReadChainOutsideUOW();
    }

    public void endReadChain() throws SqlException {
        super.endReadChain();
    }

    public String convertToStringTcpIpAddress(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n >> 24 & 0xFF);
        stringBuffer.append(".");
        stringBuffer.append(n >> 16 & 0xFF);
        stringBuffer.append(".");
        stringBuffer.append(n >> 8 & 0xFF);
        stringBuffer.append(".");
        stringBuffer.append(n & 0xFF);
        return stringBuffer.toString();
    }

    protected int getPort() {
        return this.port_;
    }
}

