/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom;

import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.UIDEntry;
import com.archimed.dicom.UnknownUIDException;
import java.util.Enumeration;
import java.util.Hashtable;

public class UID {
    public static final int UnknownUID = 0;
    public static final int DICOMApplicationContextName = 20481;
    public static final int DICOMControlledTerminology = 20482;
    static Hashtable entries = new Hashtable();

    public static UIDEntry getUIDEntry(int n2) throws IllegalValueException {
        UIDEntry uIDEntry = (UIDEntry)entries.get(new Integer(n2));
        if (uIDEntry == null) {
            throw new IllegalValueException("UID not found");
        }
        return uIDEntry;
    }

    public static UIDEntry getUIDEntry(String string) throws UnknownUIDException {
        Enumeration enumeration = entries.elements();
        while (enumeration.hasMoreElements()) {
            UIDEntry uIDEntry = (UIDEntry)enumeration.nextElement();
            if (!uIDEntry.getValue().equals(string)) continue;
            return uIDEntry;
        }
        throw new UnknownUIDException(string, "Unknown UID: '" + string + "'");
    }

    static UIDEntry getUIDEntryForCode(String string) throws UnknownUIDException {
        Enumeration enumeration = entries.elements();
        while (enumeration.hasMoreElements()) {
            UIDEntry uIDEntry = (UIDEntry)enumeration.nextElement();
            if (!uIDEntry.getShortName().equals(string)) continue;
            return uIDEntry;
        }
        throw new UnknownUIDException(string, "Unknown UID: '" + string + "'");
    }

    static {
        try {
            Class.forName("com.archimed.dicom.TransferSyntax");
            Class.forName("com.archimed.dicom.SOPClass");
            Class.forName("com.archimed.dicom.MetaSOPClass");
            Class.forName("com.archimed.dicom.SOPInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        entries.put(new Integer(20481), new UIDEntry(20481, "1.2.840.10008.3.1.1.1", "DICOM Application Context Name", "AC", 5));
        entries.put(new Integer(20482), new UIDEntry(20482, "1.2.840.10008.2.16.4", "DICOM Controlled Terminology", "CTER", 6));
    }
}

