/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.iioplugin;

import com.archimed.codec.a.b;
import com.archimed.codec.jpeg.Jpeg14Decoder;
import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.UID;
import com.archimed.dicom.UIDEntry;
import com.archimed.dicom.UnknownUIDException;
import com.archimed.dicom.iioplugin.DicomImageReadParam;
import com.archimed.dicom.image.ColorModelFactory;
import com.archimed.dicom.image.DicomImageInfo;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DicomImageReader
extends ImageReader {
    private static final int int = 0;
    private static final int if = 1;
    private static final int d = 0;
    private static final int j = 1;
    public static final int MONOCHROME1 = 0;
    public static final int MONOCHROME2 = 1;
    private static final int long = 2;
    private static final int try = 3;
    private static final int case = 4;
    private static final int i = 5;
    private static final int char = 6;
    private static final int void = 7;
    private static final int for = 8;
    private static final int byte = 9;
    private DicomObject g = null;
    private boolean e = true;
    int width = -1;
    int height = -1;
    int samplesPerPixel = -1;
    int bitsAllocated = -1;
    int numberOfBits = -1;
    int highBit = -1;
    int planarConfiguration;
    int pixelRepresentation;
    int photometricInterpretation;
    private byte[] else;
    private byte[] goto;
    private byte[] a;
    private int f;
    private int b;
    private int new;
    private ImageTypeSpecifier h = null;
    private int do = -1;
    private int c = -1;

    public DicomImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    public IIOMetadata getImageMetadata(int n2) {
        return null;
    }

    public IIOMetadata getStreamMetadata() {
        return null;
    }

    public ImageReadParam getDefaultReadParam() {
        return new DicomImageReadParam();
    }

    public int getHeight(int n2) throws IOException {
        this.int();
        this.do(n2);
        return this.height;
    }

    public int getWidth(int n2) throws IOException {
        this.int();
        this.do(n2);
        return this.width;
    }

    public int getNumImages(boolean bl) throws IOException {
        this.int();
        return this.b;
    }

    public Iterator getImageTypes(int n2) throws IOException {
        this.int();
        this.do(n2);
        ArrayList<ImageTypeSpecifier> arrayList = new ArrayList<ImageTypeSpecifier>();
        arrayList.add(this.h);
        return arrayList.iterator();
    }

    private void if() throws IOException {
        try {
            DicomImageInfo dicomImageInfo = new DicomImageInfo(this.g);
            ColorModel colorModel = ColorModelFactory.createColorModel(dicomImageInfo);
            SampleModel sampleModel = null;
            if (dicomImageInfo.getPhotometricInterpretation() == 3) {
                sampleModel = colorModel.createCompatibleSampleModel(1, 1);
            } else {
                int n2 = this.bitsAllocated > 8 ? 1 : 0;
                sampleModel = new PixelInterleavedSampleModel(n2, 1, 1, 1, 1, new int[]{0});
            }
            this.h = new ImageTypeSpecifier(colorModel, sampleModel);
        }
        catch (IllegalValueException illegalValueException) {
            IOException iOException = new IOException(illegalValueException + "");
            iOException.initCause(illegalValueException);
            throw iOException;
        }
    }

    public void setInput(Object object, boolean bl, boolean bl2) {
        super.setInput(object, bl, bl2);
        this.e = true;
    }

    private void do(int n2) {
        if (n2 >= this.b) {
            throw new IndexOutOfBoundsException("imageIndex >= " + this.b);
        }
    }

    private void int() throws IOException {
        if (!this.e) {
            return;
        }
        try {
            this.do();
            this.e = false;
        }
        catch (DicomException dicomException) {
            IOException iOException = new IOException("Encountered DicomException");
            iOException.initCause(dicomException);
            throw iOException;
        }
    }

    private void do() throws IOException, DicomException {
        if (this.getInput() instanceof ImageInputStream) {
            this.g = new DicomObject();
            this.g.read(new a((ImageInputStream)this.getInput()), true);
        } else if (this.getInput() instanceof DicomObject) {
            this.g = (DicomObject)this.getInput();
        }
        this.width = this.g.getI(467);
        this.height = this.g.getI(466);
        this.samplesPerPixel = this.g.getI(461);
        this.bitsAllocated = this.g.getI(475);
        if (this.bitsAllocated % 8 != 0) {
            throw new IOException("DicomImageReader does not support BitsAllocated values that are not multiples of 8");
        }
        this.numberOfBits = this.g.getI(476);
        this.highBit = this.g.getI(477);
        if (this.g.getI(463) == 0) {
            this.planarConfiguration = 0;
        } else if (this.g.getI(463) == 1) {
            this.planarConfiguration = 1;
        }
        if (this.g.getI(478) == 0) {
            this.pixelRepresentation = 0;
        } else if (this.g.getI(478) == 1) {
            this.pixelRepresentation = 1;
        } else {
            throw new IOException("DicomImageReader: missing or illegal value for PixelRepresentation");
        }
        String string = this.g.getS(462);
        if (string == null) {
            throw new IOException("DicomImageReader: missing value for PhotometricInterpretation");
        }
        if (string.equals("MONOCHROME1")) {
            this.photometricInterpretation = 0;
        } else if (string.equals("MONOCHROME2")) {
            this.photometricInterpretation = 1;
        } else if (string.equals("PALETTE COLOR")) {
            this.photometricInterpretation = 2;
        } else if (string.equals("RGB")) {
            this.photometricInterpretation = 3;
        } else if (string.equals("HSV")) {
            this.photometricInterpretation = 4;
        } else if (string.equals("ARGB")) {
            this.photometricInterpretation = 5;
        } else if (string.equals("CMYK")) {
            this.photometricInterpretation = 6;
        } else if (string.equals("YBR_FULL")) {
            this.photometricInterpretation = 7;
        } else if (string.equals("YBR_FULL_422")) {
            this.photometricInterpretation = 8;
        } else if (string.equals("YBR_PARTIAL_422")) {
            this.photometricInterpretation = 9;
        } else {
            throw new IOException("DicomImageReader: illegal value for PhotometricInterpretation: '" + string + "'");
        }
        for (int i2 = 0; i2 < this.numberOfBits; ++i2) {
            this.new <<= 1;
            ++this.new;
        }
        this.b = this.g.get(464) == null ? 1 : this.g.getI(464);
        DicomObject dicomObject = this.g.getFileMetaInformation();
        String string2 = null;
        if (dicomObject == null) {
            this.f = 8193;
        } else {
            string2 = dicomObject.getS(31);
            if (string2 == null) {
                throw new IOException("DicomImageReader: transfer syntax missing");
            }
            try {
                UIDEntry uIDEntry = UID.getUIDEntry(string2);
                this.f = uIDEntry.getConstant();
            }
            catch (UnknownUIDException unknownUIDException) {
                throw new DicomException(unknownUIDException + "");
            }
        }
        if (this.photometricInterpretation == 2) {
            this.else = this.a(498, 494);
            this.goto = this.a(499, 495);
            this.a = this.a(500, 496);
        }
        this.if();
    }

    private byte[] a(int n2, int n3) throws DicomException, IOException {
        int n4 = this.g.getI(n3, 0);
        int n5 = this.g.getI(n3, 1);
        int n6 = this.g.getI(n3, 2);
        byte[] byArray = (byte[])this.g.get(n2);
        int n7 = (byArray[0] & 0xFF) + ((byArray[1] & 0xFF) << 8);
        int n8 = (byArray[byArray.length - 2] & 0xFF) + ((byArray[byArray.length - 1] & 0xFF) << 8);
        if (this.bitsAllocated == 8) {
            int n9;
            byte[] byArray2 = new byte[256];
            for (n9 = 0; n9 < n5; ++n9) {
                byArray2[n9] = (byte)(n7 >> 8);
            }
            for (n9 = 0; n9 < n4; ++n9) {
                int n10 = (byArray[2 * n9] & 0xFF) + ((byArray[2 * n9 + 1] & 0xFF) << 8);
                byArray2[n5 + n9] = (byte)(n10 >> 8);
            }
            for (n9 = n5 + n4; n9 < byArray2.length; ++n9) {
                byArray2[n9] = (byte)(n8 >> 8);
            }
            return byArray2;
        }
        throw new IOException("DicomImageReader: unsupported Bits Allocated value for palette color image: " + this.bitsAllocated);
    }

    private void new() throws IOException {
        try {
            if (this.g.getSize(487) > 0 && this.g.getSize(488) > 0) {
                float f2 = Float.valueOf(this.g.getS(487)).floatValue();
                this.c = (int)Math.round(Math.floor(f2));
                float f3 = Float.valueOf(this.g.getS(488)).floatValue();
                this.do = (int)Math.round(Math.floor(f3));
                if (this.g.getSize(490) > 0 && this.g.getSize(489) > 0) {
                    float f4 = Float.valueOf(this.g.getS(490)).floatValue();
                    float f5 = Float.valueOf(this.g.getS(489)).floatValue();
                    this.c = (int)(((float)this.c - f5) / f4);
                    this.do = (int)((float)this.do / f4);
                }
            } else {
                int n2 = (1 << this.numberOfBits) - 1;
                int n3 = (1 << this.numberOfBits) - 1;
                int n4 = 0;
                this.do = n2;
                this.c = n4 + (n3 - n4) / 2;
            }
        }
        catch (DicomException dicomException) {
            IOException iOException = new IOException("DicomException occured: " + dicomException);
            iOException.initCause(dicomException);
            throw iOException;
        }
    }

    public static byte[] createLUT(int n2, int n3, int n4, boolean bl) {
        int n5;
        byte[] byArray = new byte[1 << n2];
        int n6 = Math.max(n4 - n3 / 2, 0);
        int n7 = Math.min(n4 + n3 / 2, byArray.length);
        for (n5 = 0; n5 < n6; ++n5) {
            byArray[n5] = !bl ? 0 : -1;
        }
        while (n5 < n7) {
            byArray[n5] = !bl ? (byte)((n5 - n6) * 255 / (n7 - n6)) : (byte)((n7 - n5) * 255 / (n7 - n6));
            ++n5;
        }
        while (n5 < byArray.length) {
            byArray[n5] = !bl ? -1 : 0;
            ++n5;
        }
        return byArray;
    }

    public BufferedImage read(int n2, ImageReadParam imageReadParam) throws IOException {
        this.int();
        this.do(n2);
        if (this.f == 8196 || this.f == 8199 || this.f == 8205) {
            BufferedImage bufferedImage = this.a(n2);
            if (this.photometricInterpretation == 3) {
                return bufferedImage;
            }
            bufferedImage = new BufferedImage(this.h.getColorModel(), bufferedImage.getRaster(), false, null);
            return bufferedImage;
        }
        if (this.f == 8225 || this.f == 8224) {
            BufferedImage bufferedImage = this.for();
            if (bufferedImage == null) {
                return null;
            }
            if (bufferedImage.getRaster().getTransferType() == 2) {
                WritableRaster writableRaster = bufferedImage.getRaster();
                DataBufferShort dataBufferShort = (DataBufferShort)writableRaster.getDataBuffer();
                short[] sArray = dataBufferShort.getData();
                int n3 = dataBufferShort.getSize();
                int n4 = 1 << this.numberOfBits - 1;
                int n5 = 0;
                while (n5 < n3) {
                    int n6 = n5++;
                    sArray[n6] = (short)(sArray[n6] + n4);
                }
                DataBufferUShort dataBufferUShort = new DataBufferUShort(sArray, dataBufferShort.getSize());
                writableRaster = Raster.createInterleavedRaster(dataBufferUShort, this.width, this.height, this.width, 1, new int[]{0}, new Point(0, 0));
                bufferedImage = new BufferedImage(this.h.getColorModel(), writableRaster, false, null);
                return bufferedImage;
            }
            if (this.h.getColorModel().isCompatibleRaster(bufferedImage.getRaster())) {
                bufferedImage = new BufferedImage(this.h.getColorModel(), bufferedImage.getRaster(), false, null);
                return bufferedImage;
            }
            return bufferedImage;
        }
        if (this.f == 8216 || this.f == 8217) {
            BufferedImage bufferedImage = this.try();
            bufferedImage = new BufferedImage(this.h.getColorModel(), bufferedImage.getRaster(), false, null);
            return bufferedImage;
        }
        Iterator iterator = this.getImageTypes(n2);
        BufferedImage bufferedImage = ImageReader.getDestination(imageReadParam, iterator, this.width, this.height);
        WritableRaster writableRaster = bufferedImage.getWritableTile(0, 0);
        DataBuffer dataBuffer = writableRaster.getDataBuffer();
        try {
            this.a(dataBuffer, n2);
        }
        catch (DicomException dicomException) {
            IOException iOException = new IOException();
            iOException.initCause(dicomException);
            throw iOException;
        }
        return bufferedImage;
    }

    private boolean a() {
        return this.f != 8193 && this.f != 8194 && this.f != 8195 && this.f != 8227;
    }

    private void a(DataBuffer dataBuffer, int n2) throws DicomException, IOException {
        byte[] byArray = null;
        int n3 = 0;
        if (this.a()) {
            if (this.f == 8198) {
                this.a(n2, dataBuffer);
                return;
            }
            if (this.f == 8197) {
                byArray = this.if(n2);
                n3 = 0;
            }
        } else {
            byArray = (byte[])this.g.get(1184);
            n3 = this.bitsAllocated / 8 * this.samplesPerPixel * this.width * this.height * n2;
        }
        if (this.photometricInterpretation == 0 || this.photometricInterpretation == 1) {
            if (this.numberOfBits == 8) {
                DataBufferByte dataBufferByte = (DataBufferByte)dataBuffer;
                byte[] byArray2 = dataBufferByte.getData();
                System.arraycopy(byArray, n3, byArray2, 0, Math.min(byArray2.length, byArray.length));
            } else if (this.numberOfBits > 8) {
                DataBufferUShort dataBufferUShort = (DataBufferUShort)dataBuffer;
                short[] sArray = dataBufferUShort.getData();
                int n4 = 32 - (this.numberOfBits - 8);
                int n5 = Math.min(sArray.length, byArray.length / 2);
                if (this.pixelRepresentation == 1) {
                    int n6 = 1 << this.numberOfBits - 1;
                    for (int i2 = 0; i2 < n5; ++i2) {
                        int n7 = byArray[2 * i2] & 0xFF;
                        int n8 = byArray[2 * i2 + 1] << n4 >> n4;
                        sArray[i2] = (short)((n8 << 8) + n7 + n6);
                    }
                } else {
                    for (int i3 = 0; i3 < n5; ++i3) {
                        int n9 = byArray[2 * i3] & 0xFF;
                        int n10 = byArray[2 * i3 + 1] << n4 >>> n4;
                        sArray[i3] = (short)((n10 << 8) + n9);
                    }
                }
            }
        } else if (this.photometricInterpretation == 3) {
            if (this.planarConfiguration == 0) {
                DataBufferInt dataBufferInt = (DataBufferInt)dataBuffer;
                int[] nArray = dataBufferInt.getData();
                int n11 = Math.min(byArray.length / 3, nArray.length);
                for (int i4 = 0; i4 < nArray.length; ++i4) {
                    nArray[i4] = -16777216 + ((byArray[3 * i4] & 0xFF) << 16) + ((byArray[3 * i4 + 1] & 0xFF) << 8) + (byArray[3 * i4 + 2] & 0xFF);
                }
            } else if (this.planarConfiguration != 1) {
                throw new DicomException("Unknown planar configuration: " + this.planarConfiguration);
            }
        } else if (this.photometricInterpretation == 2) {
            DataBufferByte dataBufferByte = (DataBufferByte)dataBuffer;
            byte[] byArray3 = dataBufferByte.getData();
            int n12 = Math.min(byArray.length, byArray3.length);
            System.arraycopy(byArray, n3, byArray3, 0, n12);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void a(int n2, DataBuffer dataBuffer) throws IOException {
        int n3 = this.bitsAllocated > 8 ? 2 : 1;
        int n4 = this.width * this.height * n3 * this.samplesPerPixel;
        byte[] byArray = this.for(n2);
        b b2 = new b();
        b2.a(this.width, this.height);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        if (this.photometricInterpretation == 3) {
            b2.a((InputStream)byteArrayInputStream, ((DataBufferInt)dataBuffer).getData());
            return;
        } else if (this.photometricInterpretation == 0 || this.photometricInterpretation == 1) {
            if (this.numberOfBits == 8) {
                b2.a((InputStream)byteArrayInputStream, ((DataBufferByte)dataBuffer).getBankData());
                return;
            } else {
                if (this.numberOfBits <= 8 || this.numberOfBits > 16) throw new IOException("unsupported number of bits for MONOCHROME and RLE :" + this.numberOfBits);
                b2.a((InputStream)byteArrayInputStream, ((DataBufferUShort)dataBuffer).getData());
            }
            return;
        } else {
            if (this.photometricInterpretation != 2) throw new IOException("unsupported photometric interpreation for RLE");
            if (this.numberOfBits != 8) throw new IOException("unsupported number of bits for MONOCHROME and RLE :" + this.numberOfBits);
            b2.a((InputStream)byteArrayInputStream, ((DataBufferByte)dataBuffer).getBankData());
        }
    }

    private BufferedImage a(int n2) throws IOException {
        byte[] byArray = this.for(n2);
        ImageReader imageReader = null;
        Iterator<ImageReader> iterator = ImageIO.getImageReadersByMIMEType("image/jpeg");
        while (iterator.hasNext() && !(imageReader = iterator.next()).getClass().getName().equals("com.sun.media.imageioimpl.plugins.jpeg.CLibJPEGImageReader")) {
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            MemoryCacheImageInputStream memoryCacheImageInputStream = new MemoryCacheImageInputStream(byteArrayInputStream);
            imageReader.setInput(memoryCacheImageInputStream);
            ImageReadParam imageReadParam = imageReader.getDefaultReadParam();
            BufferedImage bufferedImage = imageReader.read(0, imageReadParam);
            imageReader.dispose();
            if (this.pixelRepresentation == 1) {
                int n3 = 1 << this.numberOfBits - 1;
                WritableRaster writableRaster = bufferedImage.getRaster();
                if (this.numberOfBits > 8) {
                    DataBufferUShort dataBufferUShort = (DataBufferUShort)writableRaster.getDataBuffer();
                    short[] sArray = dataBufferUShort.getData();
                    int n4 = 0;
                    while (n4 < sArray.length) {
                        int n5 = n4++;
                        sArray[n5] = (short)(sArray[n5] + n3);
                    }
                } else if (this.numberOfBits <= 8) {
                    DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
                    byte[] byArray2 = dataBufferByte.getData();
                    int n6 = 0;
                    while (n6 < byArray2.length) {
                        int n7 = n6++;
                        byArray2[n7] = (byte)(byArray2[n7] + n3);
                    }
                }
            }
            return bufferedImage;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    private byte[] if(int n2) throws IOException {
        int n3 = this.bitsAllocated > 8 ? 2 : 1;
        byte[] byArray = new byte[this.width * this.height * n3];
        int n4 = this.width * this.height * n3;
        byte[] byArray2 = this.for(n2);
        Jpeg14Decoder jpeg14Decoder = new Jpeg14Decoder();
        byte[] byArray3 = jpeg14Decoder.decode(byArray2);
        return byArray3;
    }

    private static final boolean a(byte[] byArray) {
        int n2 = byArray.length;
        if (n2 < 2) {
            return false;
        }
        if (n2 == 2) {
            return byArray[0] == -1 && byArray[1] == -39;
        }
        byte by = byArray[n2 - 1];
        byte by2 = byArray[n2 - 2];
        byte by3 = byArray[n2 - 3];
        return by2 == -1 && by == -39 || by3 == -1 && by2 == -39 || by2 == -39 && by == -1 || by3 == -39 && by2 == -1;
    }

    private byte[] for(int n2) throws IOException {
        int n3 = this.g.getSize(1184) - 1;
        if (n2 > n3 - 1) {
            throw new IOException("error decoding JPEG encapsulated stream: number of fragments  " + n3 + " < specified frame " + n2);
        }
        if (this.b == n3) {
            byte[] byArray = (byte[])this.g.get(1184, n2 + 1);
            return byArray;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n4 = 0;
        for (int i2 = 1; i2 <= n3; ++i2) {
            byte[] byArray = (byte[])this.g.get(1184, i2);
            if (n4 == n2) {
                byteArrayOutputStream.write(byArray);
            }
            if (DicomImageReader.a(byArray)) {
                ++n4;
            }
            if (n4 > n2) break;
        }
        byteArrayOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        return byArray;
    }

    private BufferedImage for() throws IOException {
        Object object;
        Object object2;
        Object object3;
        int n2 = this.g.getSize(1184);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i2 = 1; i2 < n2; ++i2) {
            byteArrayOutputStream.write((byte[])this.g.get(1184, i2));
        }
        byteArrayOutputStream.close();
        ImageReader imageReader = null;
        try {
            object3 = Class.forName("com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReaderCodecLibSpi");
            object2 = ((Class)object3).newInstance();
            object = Class.forName("com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReaderCodecLib");
            Constructor<?> constructor = ((Class)object).getConstructor(ImageReaderSpi.class);
            imageReader = (ImageReader)constructor.newInstance(object2);
        }
        catch (Exception exception) {
            IOException iOException = new IOException("Error creating JAI Image IO JPEG2000 Reader:" + exception);
            iOException.initCause(exception);
            throw iOException;
        }
        try {
            object3 = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            object2 = new MemoryCacheImageInputStream((InputStream)object3);
            imageReader.setInput(object2);
            object = imageReader.getDefaultReadParam();
            return imageReader.read(0, (ImageReadParam)object);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    private BufferedImage try() throws IOException {
        int n2 = this.g.getSize(1184);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i2 = 1; i2 < n2; ++i2) {
            byteArrayOutputStream.write((byte[])this.g.get(1184, i2));
        }
        byteArrayOutputStream.close();
        ImageReader imageReader = null;
        String[] stringArray = ImageIO.getReaderMIMETypes();
        Iterator<ImageReader> iterator = ImageIO.getImageReadersBySuffix("jls");
        while (iterator.hasNext()) {
            imageReader = iterator.next();
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            MemoryCacheImageInputStream memoryCacheImageInputStream = new MemoryCacheImageInputStream(byteArrayInputStream);
            imageReader.setInput(memoryCacheImageInputStream);
            ImageReadParam imageReadParam = imageReader.getDefaultReadParam();
            return imageReader.read(0, imageReadParam);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    class a
    extends InputStream {
        ImageInputStream a;

        a(ImageInputStream imageInputStream) {
            this.a = imageInputStream;
        }

        public int read() throws IOException {
            return this.a.read();
        }

        public int read(byte[] byArray) throws IOException {
            return this.a.read(byArray);
        }

        public int read(byte[] byArray, int n2, int n3) throws IOException {
            return this.a.read(byArray, n2, n3);
        }
    }
}

