/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.image;

import com.archimed.dicom.DicomObject;
import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.image.DicomImageInfo;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;

public class ColorModelFactory {
    public static ColorModel createCompatibleColorModel(DicomObject dicomObject) throws IllegalValueException {
        DicomImageInfo dicomImageInfo = new DicomImageInfo(dicomObject);
        return ColorModelFactory.createColorModel(dicomImageInfo);
    }

    public static ColorModel createColorModel(DicomImageInfo dicomImageInfo) throws IllegalValueException {
        int n2 = dicomImageInfo.getPhotometricInterpretation();
        if (n2 == 3) {
            return new DirectColorModel(ColorSpace.getInstance(1000), 32, 0xFF0000, 65280, 255, -16777216, false, 3);
        }
        if (n2 == 1 || n2 == 0) {
            int n3;
            int n4;
            if (dicomImageInfo.getWindowCenters().length > 0) {
                n4 = (int)Math.round(Math.floor((dicomImageInfo.getWindowCenters()[0] - dicomImageInfo.getRescaleIntercept()) / dicomImageInfo.getRescaleSlope()));
                n3 = (int)Math.round(Math.floor(dicomImageInfo.getWindowWidths()[0] / dicomImageInfo.getRescaleSlope()));
            } else {
                n3 = (1 << dicomImageInfo.getBitsStored()) - 1;
                n4 = dicomImageInfo.getPixelRepresentation() == 1 ? 0 : n3 / 2;
            }
            int n5 = n4;
            if (dicomImageInfo.getPixelRepresentation() == 1) {
                n5 += 1 << dicomImageInfo.getBitsStored() - 1;
            }
            byte[] byArray = ColorModelFactory.createLUT(dicomImageInfo.getBitsStored(), n3, n5, n2 == 0);
            return new IndexColorModel(dicomImageInfo.getBitsStored(), 1 << dicomImageInfo.getBitsStored(), byArray, byArray, byArray);
        }
        if (n2 == 2) {
            return new IndexColorModel(dicomImageInfo.getBitsStored(), 1 << dicomImageInfo.getBitsStored(), dicomImageInfo.getPaletteRed(), dicomImageInfo.getPaletteGreen(), dicomImageInfo.getPaletteBlue());
        }
        return null;
    }

    public static byte[] createLUT(int n2, int n3, int n4, boolean bl) {
        int n5;
        byte[] byArray = new byte[1 << n2];
        int n6 = Math.max(n4 - n3 / 2, 0);
        int n7 = Math.min(n4 + n3 / 2, byArray.length);
        for (n5 = 0; n5 < n6; ++n5) {
            byArray[n5] = !bl ? 0 : -1;
        }
        while (n5 < n7) {
            byArray[n5] = !bl ? (byte)((n5 - n6) * 255 / (n7 - n6)) : (byte)((n7 - n5) * 255 / (n7 - n6));
            ++n5;
        }
        while (n5 < byArray.length) {
            byArray[n5] = !bl ? -1 : 0;
            ++n5;
        }
        return byArray;
    }
}

