/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.image;

import com.archimed.dicom.DDict;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.UID;
import com.archimed.dicom.UnknownUIDException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DicomImageInfo {
    public static final int MONOCHROME1 = 0;
    public static final int MONOCHROME2 = 1;
    public static final int PALETTE_COLOR = 2;
    public static final int RGB = 3;
    public static final int HSV = 4;
    public static final int ARGB = 5;
    public static final int CMYK = 6;
    public static final int YBR_FULL = 7;
    public static final int YBR_FULL_422 = 8;
    public static final int YBR_PARTIAL_422 = 9;
    public static final int COLOR_BY_PIXEL = 0;
    public static final int COLOR_BY_PLANE = 1;
    public static final int PR_UNSIGNEDINT = 0;
    public static final int PR_TWOSCOMPLEMENT = 1;
    protected int photometricInterpretation;
    protected int bitsStored;
    protected int bitsAllocated;
    protected int highBit;
    protected int samplesPerPixel;
    protected int planarConfiguration;
    protected int pixelRepresentation;
    protected byte[] palette_red;
    protected byte[] palette_green;
    protected byte[] palette_blue;
    protected float[] windowWidths;
    protected float[] windowCenters;
    protected float rescaleSlope;
    protected float rescaleIntercept;
    protected int width;
    protected int height;
    protected int frames;
    protected boolean hasRescale = false;
    protected int ts;

    public DicomImageInfo(DicomObject dicomObject) throws IllegalValueException {
        DicomObject dicomObject2 = dicomObject.getFileMetaInformation();
        if (dicomObject2 != null && dicomObject2.getSize(31) == 1) {
            try {
                this.ts = UID.getUIDEntry((String)dicomObject2.get(31)).getConstant();
            }
            catch (UnknownUIDException unknownUIDException) {
                IllegalValueException illegalValueException = new IllegalValueException(unknownUIDException + "");
                illegalValueException.initCause(unknownUIDException);
                throw illegalValueException;
            }
        } else {
            this.ts = 8193;
        }
        String string = (String)this.a(dicomObject, 462);
        this.a(string);
        this.samplesPerPixel = (Integer)this.a(dicomObject, 461);
        this.bitsAllocated = (Integer)this.a(dicomObject, 475);
        this.bitsStored = (Integer)this.a(dicomObject, 476);
        this.highBit = (Integer)this.a(dicomObject, 477);
        this.width = (Integer)this.a(dicomObject, 467);
        this.height = (Integer)this.a(dicomObject, 466);
        this.frames = dicomObject.getSize(464) < 1 ? 1 : (Integer)dicomObject.get(464);
        this.pixelRepresentation = (Integer)this.a(dicomObject, 478);
        if (this.samplesPerPixel > 1) {
            this.planarConfiguration = (Integer)this.a(dicomObject, 463);
            if (this.planarConfiguration != 0 && this.planarConfiguration != 1) {
                throw new IllegalValueException("Illegal Value for Planar Configuration: " + this.planarConfiguration);
            }
        }
        if (this.photometricInterpretation == 2) {
            this.palette_red = this.if(dicomObject, 498, 494);
            this.palette_green = this.if(dicomObject, 499, 495);
            this.palette_blue = this.if(dicomObject, 500, 496);
        } else if (this.photometricInterpretation == 0 || this.photometricInterpretation == 1) {
            if (dicomObject.getSize(490) > 0 && dicomObject.getSize(489) > 0) {
                this.rescaleSlope = ((Float)dicomObject.get(490)).floatValue();
                this.rescaleIntercept = ((Float)dicomObject.get(489)).floatValue();
                if (this.rescaleSlope == 0.0f) {
                    this.rescaleSlope = 1.0f;
                }
                this.hasRescale = true;
            } else {
                this.rescaleSlope = 1.0f;
                this.rescaleIntercept = 0.0f;
                this.hasRescale = false;
            }
            int n2 = dicomObject.getSize(487);
            int n3 = dicomObject.getSize(488);
            if (n2 > 0 && n3 > 0) {
                int n4;
                this.windowWidths = new float[Math.max(n2, n3)];
                this.windowCenters = new float[Math.max(n2, n3)];
                for (n4 = 0; n4 < n2; ++n4) {
                    this.windowCenters[n4] = ((Float)dicomObject.get(487, n4)).floatValue();
                }
                for (n4 = 0; n4 < n3; ++n4) {
                    this.windowWidths[n4] = ((Float)dicomObject.get(488, n4)).floatValue();
                }
            } else {
                this.windowWidths = new float[0];
                this.windowCenters = new float[0];
            }
        }
    }

    public int getPhotometricInterpretation() {
        return this.photometricInterpretation;
    }

    public int getPlanarConfiguration() {
        return this.planarConfiguration;
    }

    public int getPixelRepresentation() {
        return this.pixelRepresentation;
    }

    public int getBitsAllocated() {
        return this.bitsAllocated;
    }

    public int getBitsStored() {
        return this.bitsStored;
    }

    public int getHighBit() {
        return this.highBit;
    }

    public int getSamplesPerPixel() {
        return this.samplesPerPixel;
    }

    public byte[] getPaletteRed() {
        return this.palette_red;
    }

    public byte[] getPaletteGreen() {
        return this.palette_green;
    }

    public byte[] getPaletteBlue() {
        return this.palette_blue;
    }

    public float[] getWindowCenters() {
        return this.windowCenters;
    }

    public float[] getWindowWidths() {
        return this.windowWidths;
    }

    public float getRescaleSlope() {
        return this.rescaleSlope;
    }

    public float getRescaleIntercept() {
        return this.rescaleIntercept;
    }

    public boolean hasRescale() {
        return this.hasRescale;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getFrames() {
        return this.frames;
    }

    public int getTransferSyntax() {
        return this.ts;
    }

    private Object a(DicomObject dicomObject, int n2) throws IllegalValueException {
        return this.a(dicomObject, n2, 0);
    }

    private Object a(DicomObject dicomObject, int n2, int n3) throws IllegalValueException {
        if (dicomObject.getSize(n2) <= n3) {
            throw new IllegalValueException("value for " + DDict.getDescription(n2) + "missing");
        }
        Object object = dicomObject.get(n2, n3);
        if (object == null) {
            throw new IllegalValueException("value for " + DDict.getDescription(n2) + "missing");
        }
        return object;
    }

    private void a(String string) throws IllegalValueException {
        if (string.equals("MONOCHROME1")) {
            this.photometricInterpretation = 0;
        } else if (string.equals("MONOCHROME2")) {
            this.photometricInterpretation = 1;
        } else if (string.equals("PALETTE COLOR")) {
            this.photometricInterpretation = 2;
        } else if (string.equals("RGB")) {
            this.photometricInterpretation = 3;
        } else if (string.equals("HSV")) {
            this.photometricInterpretation = 4;
        } else if (string.equals("ARGB")) {
            this.photometricInterpretation = 5;
        } else if (string.equals("CMYK")) {
            this.photometricInterpretation = 6;
        } else if (string.equals("YBR_FULL")) {
            this.photometricInterpretation = 7;
        } else if (string.equals("YBR_FULL_422")) {
            this.photometricInterpretation = 8;
        } else if (string.equals("YBR_PARTIAL_422")) {
            this.photometricInterpretation = 9;
        } else {
            throw new IllegalValueException("Unknown photometric intepretation value: " + string);
        }
    }

    private byte[] if(DicomObject dicomObject, int n2, int n3) throws IllegalValueException {
        int n4 = (Integer)this.a(dicomObject, n3, 0);
        int n5 = (Integer)this.a(dicomObject, n3, 1);
        int n6 = (Integer)this.a(dicomObject, n3, 2);
        byte[] byArray = (byte[])this.a(dicomObject, n2);
        int n7 = (byArray[0] & 0xFF) + ((byArray[1] & 0xFF) << 8);
        int n8 = (byArray[byArray.length - 2] & 0xFF) + ((byArray[byArray.length - 1] & 0xFF) << 8);
        if (this.bitsAllocated == 8) {
            int n9;
            byte[] byArray2 = new byte[256];
            for (n9 = 0; n9 < n5; ++n9) {
                byArray2[n9] = (byte)(n7 >> 8);
            }
            for (n9 = 0; n9 < n4; ++n9) {
                int n10 = (byArray[2 * n9] & 0xFF) + ((byArray[2 * n9 + 1] & 0xFF) << 8);
                byArray2[n5 + n9] = (byte)(n10 >> 8);
            }
            for (n9 = n5 + n4; n9 < byArray2.length; ++n9) {
                byArray2[n9] = (byte)(n8 >> 8);
            }
            return byArray2;
        }
        throw new IllegalValueException("Unsupported Bits Allocated value for palette color image: " + this.bitsAllocated);
    }
}

