/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.image;

import com.archimed.dicom.DicomException;
import com.archimed.dicom.UID;
import com.archimed.dicom.UnknownUIDException;
import com.archimed.dicom.codec.Compression;
import com.archimed.dicom.image.DicomImage;
import com.archimed.dicom.image.GrayColorModel;
import com.archimed.dicom.image.a;
import com.archimed.dicom.image.b;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.io.IOException;
import java.util.Vector;

public class ImageIO {
    DicomImage dcm;
    int w;
    int h;
    int ba;
    int bs;
    int f;
    int max;
    int pc;
    int mask;
    int pr;
    String pi;
    boolean decode = false;
    int encoding;

    void setEncoding(int n2) {
        switch (n2) {
            case 8193: 
            case 8194: 
            case 8195: {
                this.encoding = 0;
                break;
            }
            default: {
                this.encoding = n2;
            }
        }
    }

    Object getPixels(int n2) {
        byte[] byArray;
        if (this.encoding != 0) {
            try {
                return Compression.decompressFrame(this.encoding, (byte[])this.dcm.get(1184, n2 + 1), this.w, this.h);
            }
            catch (DicomException dicomException) {
                dicomException.printStackTrace();
                return null;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        if (this.f == 1) {
            byArray = (byte[])this.dcm.get(1184);
        } else if (this.ba > 8) {
            byArray = new byte[this.w * this.h * this.ba / 8];
            System.arraycopy(this.dcm.get(1184), this.w * this.h * n2 * this.ba / 8, byArray, 0, this.w * this.h * this.ba / 8);
        } else if (this.pi.equals("RGB")) {
            byArray = new byte[this.w * this.h * 3];
            System.arraycopy(this.dcm.get(1184), this.w * this.h * n2 * 3, byArray, 0, this.w * this.h * 3);
        } else {
            byArray = new byte[this.w * this.h];
            System.arraycopy(this.dcm.get(1184), this.w * this.h * n2, byArray, 0, this.w * this.h);
        }
        if (this.pi.equals("PALETTE COLOR")) {
            return byArray;
        }
        if (this.pi.startsWith("MONOCHROME")) {
            if (this.ba == 8) {
                return byArray;
            }
            if (this.ba == 16) {
                int[] nArray = new int[this.w * this.h];
                if (this.pr == 1) {
                    for (int i2 = 0; i2 < this.w * this.h; ++i2) {
                        nArray[i2] = a.a(byArray[2 * i2]);
                        int n3 = i2;
                        nArray[n3] = nArray[n3] + ((byArray[2 * i2 + 1] << 8) + 32768);
                        int n4 = i2;
                        nArray[n4] = nArray[n4] & this.mask;
                        if (i2 <= 131072 || i2 >= 131584) continue;
                        System.out.println(nArray[i2]);
                    }
                } else {
                    int n5 = 0;
                    while (n5 < this.w * this.h) {
                        nArray[n5] = a.a(byArray[2 * n5]);
                        int n6 = n5;
                        nArray[n6] = nArray[n6] + (a.a(byArray[2 * n5 + 1]) << 8);
                        int n7 = n5++;
                        nArray[n7] = nArray[n7] & this.mask;
                    }
                }
                return nArray;
            }
            if (this.ba == 24) {
                int[] nArray = new int[this.w * this.h];
                int n8 = 0;
                while (n8 < this.w * this.h) {
                    nArray[n8] = a.a(byArray[3 * n8]);
                    int n9 = n8;
                    nArray[n9] = nArray[n9] + (a.a(byArray[3 * n8 + 1]) << 8);
                    int n10 = n8;
                    nArray[n10] = nArray[n10] + (a.a(byArray[3 * n8 + 2]) << 16);
                    int n11 = n8++;
                    nArray[n11] = nArray[n11] & this.mask;
                }
                return nArray;
            }
            if (this.ba == 32) {
                int[] nArray = new int[this.w * this.h];
                int n12 = 0;
                while (n12 < this.w * this.h) {
                    nArray[n12] = a.a(byArray[4 * n12]);
                    int n13 = n12;
                    nArray[n13] = nArray[n13] + (a.a(byArray[4 * n12 + 1]) << 8);
                    int n14 = n12;
                    nArray[n14] = nArray[n14] + (a.a(byArray[4 * n12 + 2]) << 16);
                    int n15 = n12;
                    nArray[n15] = nArray[n15] + (a.a(byArray[4 * n12 + 3]) << 24);
                    int n16 = n12++;
                    nArray[n16] = nArray[n16] & this.mask;
                }
                return nArray;
            }
            System.out.println("BA: " + this.ba);
        }
        if (this.pi.equals("RGB")) {
            int[] nArray = new int[this.w * this.h];
            if (this.pc == 0) {
                for (int i3 = 0; i3 < this.w * this.h; ++i3) {
                    nArray[i3] = a.a(byArray[3 * i3]) << 16;
                    int n17 = i3;
                    nArray[n17] = nArray[n17] + (a.a(byArray[3 * i3 + 1]) << 8);
                    int n18 = i3;
                    nArray[n18] = nArray[n18] + a.a(byArray[3 * i3 + 2]);
                }
            } else {
                for (int i4 = 0; i4 < this.w * this.h; ++i4) {
                    nArray[i4] = a.a(byArray[i4]) << 16;
                    int n19 = i4;
                    nArray[n19] = nArray[n19] + (a.a(byArray[this.w * this.h + i4]) << 8);
                    int n20 = i4;
                    nArray[n20] = nArray[n20] + a.a(byArray[2 * this.w * this.h + i4]);
                }
            }
            return nArray;
        }
        return null;
    }

    byte[] getPalette(int n2, int n3) throws DicomException {
        int n4 = this.dcm.getI(n3, 0);
        int n5 = this.dcm.getI(n3, 1);
        byte[] byArray = new byte[256];
        int n6 = this.dcm.getSize(n2);
        if (n6 == 1) {
            byte[] byArray2 = (byte[])this.dcm.get(n2);
            int n7 = a.a(byArray2[0]);
            n7 += a.a(byArray2[1]) << 8;
            for (n6 = 0; n6 < n5; ++n6) {
                byArray[n6] = (byte)(n7 >> 8);
            }
            for (int i2 = 0; i2 < n4; ++i2) {
                n7 = a.a(byArray2[2 * i2]);
                byArray[i2 + n5] = (byte)((n7 += a.a(byArray2[2 * i2 + 1]) << 8) >> 8);
            }
        } else {
            int n8 = this.dcm.getI(n2, 0);
            for (n6 = 0; n6 < n5; ++n6) {
                byArray[n6] = (byte)(n8 >> 8);
            }
            for (int i3 = 0; i3 < n6; ++i3) {
                n8 = this.dcm.getI(n2, i3);
                byArray[i3 + n5] = (byte)(n8 >> 8);
            }
        }
        return byArray;
    }

    int calcMax(int[] nArray) {
        int n2 = 0;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if ((nArray[i2] & this.mask) <= n2) continue;
            n2 = nArray[i2] & this.mask;
        }
        return n2;
    }

    int calcMax(byte[] byArray) {
        int n2;
        block3: {
            block4: {
                block2: {
                    n2 = 0;
                    if (this.ba != 8) break block2;
                    n2 = 255;
                    break block3;
                }
                if (this.ba != 16) break block4;
                int n3 = 0;
                for (int i2 = 0; i2 < byArray.length / 2; ++i2) {
                    n3 = a.a(byArray[2 * i2]) + (a.a(byArray[2 * i2 + 1]) << 8);
                    if ((n3 & this.mask) <= n2) continue;
                    n2 = n3 & this.mask;
                }
                break block3;
            }
            if (this.ba != 32) break block3;
            int n4 = 0;
            for (int i3 = 0; i3 < byArray.length / 4; ++i3) {
                n4 = a.a(byArray[2 * i3]) + (a.a(byArray[2 * i3 + 1]) << 8) + (a.a(byArray[2 * i3 + 2]) << 16) + (a.a(byArray[2 * i3 + 3]) << 24);
                if ((n4 & this.mask) <= n2) continue;
                n2 = n4 & this.mask;
            }
        }
        return n2;
    }

    public ImageIO(DicomImage dicomImage) throws DicomException {
        this.dcm = dicomImage;
        this.w = this.dcm.getI(467);
        this.h = this.dcm.getI(466);
        this.ba = this.dcm.getI(475);
        this.bs = this.dcm.getI(476);
        this.pr = this.dcm.getI(478);
        this.mask = (1 << this.bs) - 1;
        this.pc = this.dcm.getI(463);
        this.pi = this.dcm.getS(462);
        if (this.pi != null) {
            this.pi = this.pi.trim();
        }
        if ((this.f = this.dcm.getI(464)) == Integer.MAX_VALUE) {
            this.f = 1;
        }
        if ((this.max = this.dcm.getI(480)) == Integer.MAX_VALUE) {
            this.max = 0;
        }
        try {
            int n2 = 0;
            String string = null;
            try {
                string = this.dcm.getFileMetaInformation().getS(31);
            }
            catch (Exception exception) {
                string = null;
            }
            if (string != null) {
                n2 = UID.getUIDEntry(string).getConstant();
            }
            this.setEncoding(n2);
        }
        catch (UnknownUIDException unknownUIDException) {
            throw new DicomException("ImageIO not possible: " + unknownUIDException.getMessage());
        }
    }

    public ImageProducer getImageProducer() throws DicomException {
        return this.getImageProducer(0);
    }

    public ImageProducer getImageProducer(int n2) throws DicomException {
        if (n2 >= this.f) {
            throw new DicomException("Index exceeds number of frames");
        }
        if (this.encoding == 8196) {
            return Toolkit.getDefaultToolkit().createImage((byte[])this.dcm.get(1184, n2 + 1)).getSource();
        }
        Object object = this.getPixels(n2);
        if (object == null) {
            throw new DicomException("Error ocurred building ImageProducer " + n2);
        }
        if (this.pi.trim().equals("MONOCHROME1")) {
            if (this.ba == 8) {
                GrayColorModel grayColorModel = new GrayColorModel(8);
                return new MemoryImageSource(this.w, this.h, (ColorModel)grayColorModel, (byte[])object, 0, this.w);
            }
            if (this.max == 0) {
                this.max = this.calcMax((byte[])this.dcm.get(1184));
            }
            GrayColorModel grayColorModel = new GrayColorModel(this.ba, this.max);
            return new MemoryImageSource(this.w, this.h, (ColorModel)grayColorModel, (int[])object, 0, this.w);
        }
        if (this.pi.trim().equals("MONOCHROME2")) {
            if (this.ba == 8) {
                byte[] byArray = new byte[256];
                byte[] byArray2 = new byte[256];
                byte[] byArray3 = new byte[256];
                for (int i2 = 0; i2 < 256; ++i2) {
                    byArray2[i2] = byArray3[i2] = (byte)i2;
                    byArray[i2] = byArray3[i2];
                }
                IndexColorModel indexColorModel = new IndexColorModel(8, 256, byArray, byArray2, byArray3, -1);
                return new MemoryImageSource(this.w, this.h, (ColorModel)indexColorModel, (byte[])object, 0, this.w);
            }
            if (this.max == 0) {
                this.max = this.calcMax((byte[])this.dcm.get(1184));
            }
            GrayColorModel grayColorModel = new GrayColorModel(this.ba, this.max);
            return new MemoryImageSource(this.w, this.h, (ColorModel)grayColorModel, (int[])object, 0, this.w);
        }
        if (this.pi.trim().equals("PALETTE COLOR")) {
            byte[] byArray = this.getPalette(498, 494);
            byte[] byArray4 = this.getPalette(499, 495);
            byte[] byArray5 = this.getPalette(500, 496);
            IndexColorModel indexColorModel = new IndexColorModel(8, 256, byArray, byArray4, byArray5);
            return new MemoryImageSource(this.w, this.h, (ColorModel)indexColorModel, (byte[])object, 0, this.w);
        }
        if (this.pi.equals("RGB")) {
            DirectColorModel directColorModel = new DirectColorModel(24, 0xFF0000, 65280, 255);
            return new MemoryImageSource(this.w, this.h, (ColorModel)directColorModel, (int[])object, 0, this.w);
        }
        return null;
    }

    public Vector getImageProducers() throws DicomException {
        Vector<ImageProducer> vector = new Vector<ImageProducer>(this.f);
        for (int i2 = 0; i2 < this.f; ++i2) {
            vector.addElement(this.getImageProducer(i2));
        }
        return vector;
    }

    public synchronized void setImageProducer(ImageProducer imageProducer) {
        b b2 = new b(this);
        imageProducer.startProduction(b2);
        if (!b2.new) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        imageProducer.removeConsumer(b2);
    }

    public int size() {
        return this.f;
    }

    public DicomImage getSource() {
        return this.dcm;
    }

    boolean isDecoded() {
        return this.decode;
    }
}

