/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom.network;

import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.Jdt;
import com.archimed.dicom.TransferSyntax;
import com.archimed.dicom.UID;
import com.archimed.dicom.UIDEntry;
import com.archimed.dicom.UnknownUIDException;
import com.archimed.dicom.network.Abort;
import com.archimed.dicom.network.Acknowledge;
import com.archimed.dicom.network.Reject;
import com.archimed.dicom.network.Request;
import com.archimed.dicom.network.Response;
import com.archimed.dicom.network.ab;
import com.archimed.dicom.network.af;
import com.archimed.dicom.network.e;
import com.archimed.dicom.network.k;
import com.archimed.dicom.network.q;
import com.archimed.log.JdtLogger;
import com.archimed.tool.c;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.Vector;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Association {
    private static final int int = 8;
    private static final int c = 9;
    public static final int PDATA_PDU = 10;
    public static final int RELEASE_REQUEST = 11;
    public static final int ABORT = 12;
    public static final int RELEASE_RESPONSE = 13;
    public static final int ASSOCIATE_REQUEST = 14;
    public static final int ASSOCIATE_ACKNOWLEDGE = 15;
    public static final int ASSOCIATE_REJECT = 16;
    static String implclassuid = "1.2.826.0.1.3680043.2.60.0.1";
    static String implversionname = Jdt.DEFAULT_IMPLEMENTATION_VERSION_NAME;
    private String byte;
    private String f;
    private int a;
    private InputStream char;
    private OutputStream e;
    private PushbackInputStream new;
    private Request for;
    private Acknowledge goto;
    private ByteArrayOutputStream do;
    private ByteArrayOutputStream b;
    private k else;
    private q case;
    private Vector if;
    private boolean void = false;
    private boolean d = false;
    private int long;
    private boolean try = true;
    protected JdtLogger log = Jdt.getJdtLoggerFactory().getJdtLogger(Association.class);

    public Association(InputStream inputStream, OutputStream outputStream) {
        this.char = inputStream;
        this.e = outputStream;
        this.new = new PushbackInputStream(inputStream);
        this.do = new ByteArrayOutputStream();
        this.b = new ByteArrayOutputStream();
    }

    public void setImplementationVersionName(String string) {
        implversionname = string;
    }

    public String getImplementationVersionName() {
        return implversionname;
    }

    public void setImplementationClassUID(String string) {
        implclassuid = string;
    }

    public String getImplementationClassUID() {
        return implclassuid;
    }

    public void setSequenceUndefLen(boolean bl) {
        this.try = bl;
    }

    public boolean isSequenceUndefLen() {
        return this.try;
    }

    public DicomObject receiveCommand() throws IOException, IllegalValueException, DicomException, UnknownUIDException {
        byte[] byArray = this.receiveCommandAsByteArray();
        if (byArray != null) {
            DicomObject dicomObject = new DicomObject();
            dicomObject.read(new ByteArrayInputStream(byArray), 8193, true);
            byArray = null;
            return dicomObject;
        }
        return null;
    }

    public byte[] receiveCommandAsByteArray() throws IOException, IllegalValueException {
        if (this.void) {
            byte[] byArray = this.do.toByteArray();
            this.do.reset();
            this.void = false;
            return byArray;
        }
        if (this.a() == 8) {
            byte[] byArray = this.do.toByteArray();
            this.do.reset();
            this.void = false;
            return byArray;
        }
        return null;
    }

    public DicomObject receiveData() throws IOException, IllegalValueException, DicomException, UnknownUIDException {
        byte[] byArray = this.receiveDataAsByteArray();
        int n2 = 8193;
        int n3 = this.getCurrentPresentationContext();
        this.log.debug("current presentation context: " + n3);
        try {
            if (this.goto != null) {
                for (int i2 = 0; i2 < this.goto.getPresentationContexts(); ++i2) {
                    if (n3 != this.goto.getID(i2)) continue;
                    n2 = this.goto.getTransferSyntax(i2).getConstant();
                }
            }
            this.log.debug("current transfer syntax: " + TransferSyntax.getUIDEntry(n2).getName());
        }
        catch (Throwable throwable) {
            this.log.debug("could not derive transfer syntax from current pc " + n3 + ", trying with ImplicitLittleEndian");
            throwable.printStackTrace();
        }
        if (byArray != null) {
            DicomObject dicomObject = new DicomObject();
            dicomObject.read(new ByteArrayInputStream(byArray), n2, true);
            byArray = null;
            return dicomObject;
        }
        return null;
    }

    public byte[] receiveDataAsByteArray() throws IOException, IllegalValueException {
        if (this.d) {
            byte[] byArray = this.b.toByteArray();
            this.b.reset();
            this.d = false;
            return byArray;
        }
        if (this.a() == 9) {
            byte[] byArray = this.b.toByteArray();
            this.b.reset();
            this.d = false;
            return byArray;
        }
        return null;
    }

    public void sendAssociateResponse(Response response) throws IOException, IllegalValueException {
        if (response instanceof Abort) {
            Abort abort = (Abort)response;
            af af2 = new af(abort.getSource(), abort.getReason());
            af2.a(this.e);
        } else if (response instanceof Reject) {
            Reject reject = (Reject)response;
            ab ab2 = new ab(reject.getResult(), reject.getSource(), reject.getReason());
            ab2.a(this.e);
        } else if (response instanceof Acknowledge) {
            this.goto = (Acknowledge)response;
            this.case = new q(this.goto);
            this.case.a(this.e);
            this.if = this.case.a();
        }
    }

    public void sendReleaseResponse() throws IOException, IllegalValueException {
        DataOutputStream dataOutputStream = new DataOutputStream(this.e);
        this.e.write(6);
        this.e.write(0);
        dataOutputStream.writeInt(4);
        dataOutputStream.writeInt(0);
    }

    public void send(int n2, DicomObject dicomObject, DicomObject dicomObject2) throws IOException, IllegalValueException, DicomException {
        int n3 = -1;
        UIDEntry uIDEntry = UID.getUIDEntry(n2);
        if (uIDEntry.getType() != 4 && uIDEntry.getType() != 1) {
            throw new IllegalValueException("first argument should be Meta SOP Class or SOP Class");
        }
        block0: for (int i2 = 0; i2 < this.for.getPresentationContexts(); ++i2) {
            uIDEntry = this.for.getAbstractSyntax(i2);
            if (uIDEntry.getConstant() != n2) continue;
            n3 = this.for.getID(i2);
            for (int i3 = 0; i3 < this.goto.getPresentationContexts(); ++i3) {
                int n4 = this.goto.getID(i3);
                if (n4 == n3 && this.goto.getResult(i3) == 0) break block0;
            }
        }
        if (n3 == -1) {
            throw new IllegalValueException("no accepted presentation context with specified abstract syntax");
        }
        this.sendInPresentationContext(n3, dicomObject, dicomObject2);
    }

    public void send(byte by, DicomObject dicomObject, DicomObject dicomObject2) throws IOException, IllegalValueException, DicomException {
        this.sendInPresentationContext((int)by, dicomObject, dicomObject2);
    }

    public void sendInPresentationContext(byte by, DicomObject dicomObject, DicomObject dicomObject2) throws IOException, IllegalValueException, DicomException {
        this.sendInPresentationContext((int)by, dicomObject, dicomObject2);
    }

    public void sendInPresentationContext(int n2, DicomObject dicomObject, DicomObject dicomObject2) throws IOException, IllegalValueException, DicomException {
        int n3 = -1;
        for (int i2 = 0; i2 < this.goto.getPresentationContexts(); ++i2) {
            if (n2 != this.goto.getID(i2)) continue;
            n3 = i2;
        }
        if (n3 == -1) {
            throw new IllegalValueException("presentation context with specified id not present in Acknowledge");
        }
        if (this.goto.getResult(n3) != 0) {
            throw new IllegalValueException("not an accepted presentation context");
        }
        UIDEntry uIDEntry = this.goto.getTransferSyntax(n3);
        if (uIDEntry == null) {
            this.log.debug("transfer syntax null");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        c c2 = new c();
        e e2 = new e(this.e, this.a, n2, 1);
        dicomObject.write(e2, false, 8193, this.try);
        e2.close();
        if (dicomObject2 != null) {
            e2 = new e(this.e, this.a, n2, 0);
            dicomObject2.write(e2, false, uIDEntry.getConstant(), true);
            e2.close();
        }
    }

    private void a(byte[] byArray, int n2, int n3, byte by, byte by2) throws IOException {
        int n4;
        int n5 = n2;
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(this.e, 8192);
        DataOutputStream dataOutputStream = new DataOutputStream(bufferedOutputStream);
        int n6 = this.a != 0 ? this.a - 6 : n4;
        for (n4 = n3; n4 > n6; n4 -= n6) {
            dataOutputStream.writeByte(4);
            dataOutputStream.writeByte(0);
            dataOutputStream.writeInt(this.a);
            dataOutputStream.writeInt(this.a - 4);
            dataOutputStream.writeByte(by);
            dataOutputStream.writeByte(by2);
            dataOutputStream.write(byArray, n5, n6);
            n5 += n6;
        }
        dataOutputStream.writeByte(4);
        dataOutputStream.writeByte(0);
        dataOutputStream.writeInt(n4 + 6);
        dataOutputStream.writeInt(n4 + 2);
        dataOutputStream.writeByte(by);
        dataOutputStream.writeByte(by2 + 2);
        dataOutputStream.write(byArray, n5, n4);
        bufferedOutputStream.flush();
    }

    public int peek() throws IOException, IllegalValueException {
        int n2 = this.new.read();
        if (n2 == -1) {
            throw new IOException("end of stream reached");
        }
        this.new.unread(n2);
        if (n2 == 1) {
            return 14;
        }
        if (n2 == 2) {
            return 15;
        }
        if (n2 == 3) {
            return 16;
        }
        if (n2 == 4) {
            return 10;
        }
        if (n2 == 5) {
            return 11;
        }
        if (n2 == 6) {
            return 13;
        }
        if (n2 == 7) {
            return 12;
        }
        throw new IllegalValueException("Unexpected byte read: " + n2);
    }

    private int a() throws IOException, IllegalValueException {
        DataInputStream dataInputStream = new DataInputStream(this.new);
        DataOutputStream dataOutputStream = new DataOutputStream(this.e);
        int n2 = 4;
        do {
            int n3 = this.new.read();
            this.log.debug("incoming PDU");
            this.log.debug("PDU type: " + n3);
            if (n3 != n2) {
                throw new IllegalValueException("first byte of PDATA-PDU not 0x04 but '" + n3 + "'");
            }
            dataInputStream.read();
            int n4 = dataInputStream.readInt();
            this.log.debug("PDU length: " + n4);
            while (n4 > 0) {
                int n5 = dataInputStream.readInt();
                this.log.debug("item length: " + n5);
                byte[] byArray = new byte[n5 - 2];
                n4 = n4 - n5 - 4;
                this.long = dataInputStream.readUnsignedByte();
                this.log.debug("presentation context id: " + this.long);
                byte by = dataInputStream.readByte();
                this.log.debug("header value: " + by);
                dataInputStream.readFully(byArray);
                if (by == 0) {
                    this.b.write(byArray, 0, byArray.length);
                    continue;
                }
                if (by == 1) {
                    this.do.write(byArray, 0, byArray.length);
                    continue;
                }
                if (by == 2) {
                    this.b.write(byArray, 0, byArray.length);
                    this.d = true;
                    continue;
                }
                if (by == 3) {
                    this.do.write(byArray, 0, byArray.length);
                    this.void = true;
                    continue;
                }
                throw new IllegalValueException("illegal value for header of PDV item");
            }
            if (!this.void) continue;
            return 8;
        } while (!this.d);
        return 9;
    }

    public int getCurrentPresentationContext() {
        return this.long;
    }

    public UIDEntry getCurrentAbstractSyntax() throws IllegalValueException {
        for (int i2 = 0; i2 < this.for.getPresentationContexts(); ++i2) {
            if (this.long != this.for.getID(i2)) continue;
            return this.for.getAbstractSyntax(i2);
        }
        throw new IllegalValueException("no abstract syntax in request found for received presentation context id: " + this.long);
    }

    public Request receiveAssociateRequest() throws IOException, UnknownUIDException, IllegalValueException {
        this.else = new k();
        this.else.a(this.new);
        this.a = this.else.for().getMaxPduSize();
        this.for = this.else.for();
        return this.for;
    }

    public Response receiveAssociateResponse() throws IOException, UnknownUIDException, IllegalValueException {
        int n2 = this.new.read();
        this.new.unread(n2);
        if (n2 == 2) {
            this.case = new q();
            this.case.a(this.new);
            this.a = this.case.for().getMaxPduSize();
            this.if = this.case.a();
            this.goto = this.case.for();
            return this.case.for();
        }
        if (n2 == 3) {
            ab ab2 = new ab();
            ab2.a(this.new);
            return ab2.a();
        }
        if (n2 == 7) {
            af af2 = new af();
            af2.a(this.new);
            return af2.a();
        }
        throw new IllegalValueException("first byte of PDATA-PDU not 0x04 but '" + n2 + "'");
    }

    public void sendAssociateRequest(Request request) throws IOException, IllegalValueException {
        this.for = request;
        this.for.setImplementationClassUID(implclassuid);
        this.for.setImplementationVersionName(implversionname);
        this.else = new k(this.for);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        this.else.a(dataOutputStream);
        this.e.write(byteArrayOutputStream.toByteArray());
    }

    public void sendReleaseRequest() throws IOException, IllegalValueException {
        DataOutputStream dataOutputStream = new DataOutputStream(this.e);
        this.e.write(5);
        this.e.write(0);
        dataOutputStream.writeInt(4);
        dataOutputStream.writeInt(0);
    }

    public void receiveReleaseRequest() throws IOException, IllegalValueException {
        DataInputStream dataInputStream = new DataInputStream(this.new);
        int n2 = this.new.read();
        if (n2 != 5) {
            throw new IllegalValueException("wrong first byte for expected Release Request: " + n2);
        }
        this.new.read();
        dataInputStream.readInt();
        dataInputStream.readInt();
    }

    public void receiveReleaseResponse() throws IOException, IllegalValueException {
        DataInputStream dataInputStream = new DataInputStream(this.new);
        int n2 = this.new.read();
        if (n2 != 6) {
            throw new IllegalValueException("wrong first byte for expected Release Response: " + n2);
        }
        this.new.read();
        dataInputStream.readInt();
        dataInputStream.readInt();
    }

    public void sendAbort(int n2, int n3) throws IOException {
        af af2 = new af(n2, n3);
        af2.a(this.e);
    }

    public Abort receiveAbort() throws IllegalValueException, IOException {
        af af2 = new af();
        af2.a(this.new);
        return af2.a();
    }
}

