/*
 * Decompiled with CFR 0.152.
 */
package FileUtilities;

import DataStructures.Pair;
import java.io.File;

public class FileNaming {
    public static final String INVALID_FILENAME_CHARS = "[\\\\/:\\*\\?\\\"<>\\|,]";

    public static String stripInvalidCharacters(String string) {
        return string.replaceAll(INVALID_FILENAME_CHARS, "");
    }

    public static String baseName(String string) {
        return FileNaming.baseName(string, File.separatorChar);
    }

    public static String baseName(String string, String string2) {
        return FileNaming.baseName(string, string2, File.separatorChar);
    }

    public static String urlBaseName(String string) {
        return FileNaming.baseName(string, '/');
    }

    public static String urlBaseName(String string, String string2) {
        return FileNaming.baseName(string, string2, '/');
    }

    private static final String baseName(String string, char c) {
        int n = string.lastIndexOf(c);
        return n == -1 ? string : string.substring(n + 1);
    }

    private static final String baseName(String string, String string2, char c) {
        String string3 = FileNaming.baseName(string, c);
        if (string3.endsWith(string2) && string3.length() > string2.length()) {
            return string3.substring(0, string3.lastIndexOf(string2));
        }
        return string3;
    }

    public static String dirName(String string) {
        return FileNaming.dirName(string, File.separatorChar);
    }

    public static String urlDirName(String string) {
        return FileNaming.dirName(string, '/');
    }

    public static String dirName(String string, char c) {
        int n = string.lastIndexOf(c);
        return n == -1 ? "." : string.substring(0, n);
    }

    public static File getRelativePath(File file, File file2) {
        if (file2 == null) {
            return null;
        }
        File file3 = file2.getParentFile();
        if (file.equals(file3)) {
            return new File(file2.getName());
        }
        File file4 = FileNaming.getRelativePath(file, file3);
        if (file4 == null) {
            return null;
        }
        return new File(file4, file2.getName());
    }

    public static Pair splitExtension(File file) {
        if (file == null) {
            return new Pair("", "");
        }
        String string = file.getName();
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return new Pair(string, "");
        }
        return new Pair(string.substring(0, n), string.substring(n));
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("Usage: FileNaming <test pathname>");
            System.exit(1);
        }
        System.out.println("Dirname is: " + FileNaming.dirName(stringArray[0]));
        if (stringArray.length == 2) {
            System.out.println("Basename is: " + FileNaming.baseName(stringArray[0], stringArray[1]));
        } else {
            System.out.println("Basename is: " + FileNaming.baseName(stringArray[0]));
        }
    }

    private FileNaming() {
    }
}

