/*
 * Decompiled with CFR 0.152.
 */
package FileUtilities;

import DateUtilities.DateUtilities;
import FileUtilities.ListFiles;
import RuntimeTool.DebugManager;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class FileOperations {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static Random mRandom = new Random();
    private static Object mRandomLock = new Object();

    public static File getSystemTempDir() {
        return new File(System.getProperty("java.io.tmpdir"));
    }

    public static long copy(InputStream inputStream, OutputStream outputStream, byte[] byArray) throws IOException {
        long l = 0L;
        int n = -1;
        while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    public static long copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        return FileOperations.copy(inputStream, outputStream, new byte[20480]);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void copyFile(File var0, File var1_1) throws IOException {
        block9: {
            var2_2 = null;
            var3_3 = null;
            try {
                var2_2 = new FileInputStream(var0);
                var3_3 = new FileOutputStream(var1_1);
                var7_4 = var3_3.getChannel().transferFrom(var2_2.getChannel(), 0L, var0.length());
                if (var7_4 != var0.length()) {
                    throw new IOException("Short write: " + var7_4 + " out of " + var0.length() + " bytes written to disk");
                }
            }
            catch (Throwable var4_5) {
                var5_6 = null;
                if (var2_2 != null) {
                    try {
                        var2_2.close();
                    }
                    catch (IOException var6_8) {
                        // empty catch block
                    }
                }
                if (var3_3 == null) throw var4_5;
                var3_3.close();
                throw var4_5;
            }
            {
                var5_7 = null;
                if (var2_2 == null) break block9;
            }
            ** try [egrp 1[TRYBLOCK] [1 : 109->116)] { 
lbl26:
            // 1 sources

            var2_2.close();
            break block9;
lbl28:
            // 1 sources

            catch (IOException var6_9) {
                // empty catch block
            }
        }
        if (var3_3 == null) return;
        var3_3.close();
    }

    /*
     * Exception decompiling
     */
    public static byte[] readFile(File var0) throws FileNotFoundException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 50->53)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean moveFile(File file, File file2) throws FileNotFoundException, IOException {
        if (!file.renameTo(file2)) {
            FileOperations.copyFile(file, file2);
            return file.delete();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File createTempDir(File file, String string, String string2) throws IOException {
        if (!file.isDirectory()) {
            throw new IOException("Base directory " + file + " does not exist or is not a directory");
        }
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        Object object = mRandomLock;
        synchronized (object) {
            File file2;
            while ((file2 = new File(file, string + mRandom.nextInt() + string2)).exists()) {
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl12 : MonitorExitStatement: MONITOREXIT : var4_3
            if (file2.mkdir()) return file2;
            throw new IOException("Cannot create temporary directory " + file2);
        }
    }

    public static boolean createDirectory(File file) {
        file.mkdirs();
        return file.isDirectory();
    }

    public static boolean createDirectory(String string) {
        return FileOperations.createDirectory(new File(string));
    }

    public static boolean removeDirectory(String string) {
        if (string == null) {
            return false;
        }
        return FileOperations.removeDirectory(new File(string));
    }

    public static boolean removeDirectory(File file) {
        return FileOperations.removeDirectory(file, null);
    }

    public static boolean removeDirectory(File file, FileFilter fileFilter) {
        if (!file.isDirectory()) {
            return false;
        }
        File[] fileArray = null;
        try {
            fileArray = file.listFiles();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (fileArray == null) {
            fileArray = new File[]{};
        }
        int n = 0;
        while (n < fileArray.length) {
            File file2 = fileArray[n];
            if (file2.isDirectory()) {
                FileOperations.removeDirectory(file2, fileFilter);
            } else {
                try {
                    if (fileFilter == null || fileFilter.accept(file2)) {
                        file2.delete();
                    }
                }
                catch (SecurityException securityException) {
                    securityException.printStackTrace();
                }
            }
            ++n;
        }
        try {
            return file.delete();
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
            return false;
        }
    }

    public static boolean removeDirectoryContents(File file) {
        return FileOperations.removeDirectoryContents(file, null);
    }

    public static boolean removeDirectoryContents(File file, FileFilter fileFilter) {
        File[] fileArray = file.listFiles();
        if (fileArray == null || fileArray.length <= 0) {
            return true;
        }
        boolean bl = true;
        int n = 0;
        while (n < fileArray.length) {
            File file2 = fileArray[n];
            if (file2.isFile()) {
                if ((fileFilter == null || fileFilter.accept(file2)) && !file2.delete()) {
                    bl = false;
                }
            } else if (file2.isDirectory()) {
                FileOperations.removeDirectoryContents(file2, fileFilter);
                if (!file2.delete()) {
                    bl = false;
                }
            }
            ++n;
        }
        return bl;
    }

    public static int removeDirectories(File[] fileArray) {
        int n = 0;
        if (fileArray != null) {
            int n2 = fileArray.length;
            int n3 = 0;
            while (n3 < n2) {
                if (FileOperations.removeDirectory(fileArray[n3])) {
                    ++n;
                }
                ++n3;
            }
        }
        return n;
    }

    public static boolean exists(String string) {
        return new File(string).exists();
    }

    public static int performFileDeletion(Collection collection, FileFilter fileFilter) {
        int n = 0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            if (fileFilter != null && !fileFilter.accept(file) || !file.delete()) continue;
            iterator.remove();
            ++n;
        }
        return n;
    }

    public static int removeAllFilesOlderThanXminutes(String string, long l, FileFilter fileFilter) {
        if (!string.startsWith("/")) {
            return -1;
        }
        Vector vector = FileOperations.getAllFilesOlderThanXminutes(string, l);
        int n = FileOperations.performFileDeletion(vector, fileFilter);
        vector = null;
        return n;
    }

    public static int removeAllFilesOlderThanXminutes(String string, long l) {
        return FileOperations.removeAllFilesOlderThanXminutes(string, l, null);
    }

    public static int removeAllDirsOlderThanXDays(String string, int n) {
        return FileOperations.removeAllDirsOlderThanXDays(string, n, null);
    }

    public static int removeAllDirsOlderThanXDays(String string, int n, FileFilter fileFilter) {
        if (!string.startsWith("/")) {
            return -1;
        }
        File[] fileArray = FileOperations.getAllDirectoriesOlderThanXDays(string, n, fileFilter);
        return FileOperations.removeDirectories(fileArray);
    }

    public static Vector getAllFilesOlderThanXminutes(String string, long l) {
        List list = ListFiles.getAllFiles(new File(string));
        Vector<File> vector = new Vector<File>();
        int n = 0;
        int n2 = list.size();
        while (n < n2) {
            File file = (File)list.get(n);
            if (FileOperations.fileOlderThanXminutes(file, l)) {
                vector.add(file);
            }
            ++n;
        }
        list = null;
        return vector;
    }

    public static File[] getAllDirectoriesOlderThanXDays(String string, int n, FileFilter fileFilter) {
        return new File(string).listFiles(new DateDirectoryFilter(n, fileFilter));
    }

    public static boolean fileOlderThanXSeconds(File file, long l) {
        if (!file.exists()) {
            return false;
        }
        Date date = new Date(file.lastModified());
        Date date2 = FileOperations.getThresholdDate(l);
        return date2.after(date);
    }

    public static boolean fileOlderThanXminutes(File file, long l) {
        return FileOperations.fileOlderThanXSeconds(file, 60L * l);
    }

    private static final Date getThresholdDate(long l) {
        Calendar calendar = Calendar.getInstance();
        long l2 = calendar.getTime().getTime();
        long l3 = l2 - l * 1000L;
        return new Date(l3);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void gunzip(String var0, String var1_1) throws IOException {
        var2_2 = null;
        var3_3 = null;
        try {
            var3_3 = new GZIPInputStream(new FileInputStream(var0));
            var2_2 = new FileOutputStream(var1_1);
            var10_4 = new byte[2048];
            while ((var11_5 = var3_3.read(var10_4)) != -1) {
                var2_2.write(var10_4, 0, var11_5);
            }
            var5_8 = null;
        }
        catch (Throwable var4_6) {
            var5_7 = null;
            try {
                if (var3_3 != null) {
                    var3_3.close();
                }
                v0 = null;
            }
            catch (Throwable var6_9) {
                v0 = null;
            }
            var7_11 = v0;
            if (var2_2 == null) throw var4_6;
            try {
                var2_2.flush();
                v1 = null;
            }
            catch (Throwable var8_13) {
                v1 = null;
            }
            var9_15 = v1;
            var2_2.close();
            throw var4_6;
        }
        try {}
        catch (Throwable var6_10) {
            v2 = null;
lbl38:
            // 2 sources

            var7_12 = v2;
            if (var2_2 == null) return;
            try {}
            catch (Throwable var8_14) {
                v3 = null;
lbl43:
                // 2 sources

                var9_16 = v3;
                var2_2.close();
                return;
            }
            var2_2.flush();
            v3 = null;
            ** GOTO lbl43
        }
        if (var3_3 != null) {
            var3_3.close();
        }
        v2 = null;
        ** GOTO lbl38
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void gzip(String string, String string2) throws IOException {
        DeflaterOutputStream deflaterOutputStream;
        block5: {
            deflaterOutputStream = null;
            FileInputStream fileInputStream = null;
            try {
                int n;
                fileInputStream = new FileInputStream(string);
                deflaterOutputStream = new GZIPOutputStream(new FileOutputStream(string2));
                byte[] byArray = new byte[2048];
                while ((n = fileInputStream.read(byArray)) != -1) {
                    ((GZIPOutputStream)deflaterOutputStream).write(byArray, 0, n);
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (deflaterOutputStream == null) throw throwable;
                deflaterOutputStream.flush();
                ((GZIPOutputStream)deflaterOutputStream).finish();
                deflaterOutputStream.close();
                throw throwable;
            }
            {
                Object var5_8 = null;
                if (fileInputStream == null) break block5;
            }
            fileInputStream.close();
        }
        if (deflaterOutputStream == null) return;
        deflaterOutputStream.flush();
        ((GZIPOutputStream)deflaterOutputStream).finish();
        deflaterOutputStream.close();
    }

    public static void copyDirectory(File file, File file2) throws IOException {
        FileOperations.copyDirectory(file, file2, null);
    }

    public static void copyDirectory(File file, File file2, FileFilter fileFilter) throws IOException {
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            if (fileFilter == null || fileFilter.accept(fileArray[n])) {
                if (fileArray[n].isFile()) {
                    FileOperations.copyFile(fileArray[n], new File(file2, fileArray[n].getName()));
                } else if (fileArray[n].isDirectory()) {
                    File file3 = new File(file2, fileArray[n].getName());
                    file3.mkdirs();
                    FileOperations.copyDirectory(fileArray[n], file3, fileFilter);
                }
            }
            ++n;
        }
    }

    public static boolean forceRename(File file, File file2) {
        if (!file2.delete() && file2.exists()) {
            DebugManager.getDefault().printWarning("forceRename failed to delete " + file2);
        }
        if (!file.renameTo(file2)) {
            DebugManager.getDefault().printWarning("Failed to rename " + file + " to " + file2);
            return false;
        }
        return true;
    }

    public static boolean atomicReplace(File file, File file2) {
        File file3 = null;
        try {
            file3 = File.createTempFile("atomicReplace", null, file2.getAbsoluteFile().getParentFile());
        }
        catch (IOException iOException) {
            DebugManager.getDefault().printException("Failed to create temp directory", iOException);
            return false;
        }
        if (FileOperations.forceRename(file2, file3)) {
            if (file.renameTo(file2)) {
                file3.delete();
                return true;
            }
            if (!file3.renameTo(file2)) {
                DebugManager.getDefault().printError("FileOperations.atomicReplace() of " + file2 + " failed, but we could not replace old version");
            }
        }
        return false;
    }

    public static boolean canWriteDirectory(File file) {
        return FileOperations.canWriteDirectory(file, true);
    }

    public static boolean canWriteDirectoryOSSpecific(File file) {
        if ("Linux".equals(System.getProperty("os.name"))) {
            return FileOperations.canWriteDirectory(file, true);
        }
        return FileOperations.canWriteDirectory(file, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean canWriteDirectory(File file, boolean bl) {
        boolean bl2;
        block8: {
            if (file == null) {
                return false;
            }
            boolean bl3 = true;
            if (bl) {
                bl3 = file.canWrite();
            }
            if (!bl3 || !file.isDirectory()) {
                return false;
            }
            File file2 = null;
            try {
                file2 = File.createTempFile("temp", null, file);
                boolean bl4 = false;
                if (file2 != null) {
                    bl4 = true;
                }
                bl2 = bl4;
                Object var5_6 = null;
                if (file2 == null) break block8;
                file2.delete();
            }
            catch (IOException iOException) {
                boolean bl5;
                block9: {
                    try {
                        bl5 = false;
                        Object var5_7 = null;
                        if (file2 == null) break block9;
                        file2.delete();
                    }
                    catch (Throwable throwable) {
                        block10: {
                            Object var5_8 = null;
                            if (file2 == null) break block10;
                            file2.delete();
                        }
                        throw throwable;
                    }
                }
                return bl5;
            }
        }
        return bl2;
    }

    public static void writeStringToFile(String string, File file) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "ISO-8859-1"));
        bufferedWriter.write(string);
        ((Writer)bufferedWriter).close();
    }

    private static final class DateDirectoryFilter
    implements FileFilter {
        private String mLastDirectoryName;
        private FileFilter mCondition;

        public final boolean accept(File file) {
            boolean bl;
            String string = file.getName();
            boolean bl2 = false;
            if (file.isDirectory() && string.length() == 8) {
                bl2 = true;
            }
            if (bl = bl2) {
                try {
                    Integer.parseInt(string);
                    boolean bl3 = false;
                    if (string.compareTo(this.mLastDirectoryName) < 0) {
                        bl3 = true;
                    }
                    if ((bl = bl3) && this.mCondition != null) {
                        bl = this.mCondition.accept(file);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    bl = false;
                }
            }
            return bl;
        }

        public DateDirectoryFilter(int n, FileFilter fileFilter) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.add(6, -n);
            this.mLastDirectoryName = DateUtilities.getDicomDateString(gregorianCalendar.getTime());
            this.mCondition = fileFilter;
        }
    }
}

