/*
 * Decompiled with CFR 0.152.
 */
package FileUtilities;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ListFiles {
    public static List getAllFiles(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray == null || fileArray.length < 1) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<File> arrayList = new ArrayList<File>(fileArray.length);
        int n = 0;
        int n2 = fileArray.length;
        while (n < n2) {
            File file2 = fileArray[n];
            if (file2.isDirectory()) {
                arrayList.addAll(ListFiles.getAllFiles(file2));
            } else {
                arrayList.add(file2);
            }
            ++n;
        }
        return arrayList;
    }

    public static List listAllFiles(File file, FileFilter fileFilter) {
        ArrayList<String> arrayList = new ArrayList<String>();
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            if (fileFilter == null || fileFilter.accept(fileArray[n])) {
                if (fileArray[n].isFile()) {
                    arrayList.add(fileArray[n].getAbsolutePath());
                } else if (fileArray[n].isDirectory()) {
                    arrayList.addAll(ListFiles.listAllFiles(fileArray[n], fileFilter));
                }
            }
            ++n;
        }
        return arrayList;
    }

    public static File[] listFiles(File[] fileArray, FilenameFilter filenameFilter) {
        ArrayList<File> arrayList = new ArrayList<File>();
        int n = 0;
        while (n < fileArray.length) {
            arrayList.addAll(Arrays.asList(fileArray[n].listFiles(filenameFilter)));
            ++n;
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    public static File[] listFiles(File[] fileArray, FileFilter fileFilter) {
        ArrayList<File> arrayList = new ArrayList<File>();
        int n = 0;
        while (n < fileArray.length) {
            arrayList.addAll(Arrays.asList(fileArray[n].listFiles(fileFilter)));
            ++n;
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    private ListFiles() {
    }
}

