/*
 * Decompiled with CFR 0.152.
 */
package GuiUtilities.Util;

import GuiUtilities.Util.CompositeScreen;
import GuiUtilities.Util.CompositeScreenBuilder;
import GuiUtilities.Util.ScreenElement;
import RuntimeTool.DebugManager;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ScreenConfiguration {
    private final ScreenElement[] mScreenElements;
    private final CompositeScreen mCompositeScreen;
    private final GraphicsConfiguration mBestGraphicsConfiguration;

    public static GraphicsDevice[] getPhysicalScreenDevices() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
    }

    private final Insets getScreenInsets(GraphicsConfiguration graphicsConfiguration) {
        return Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
    }

    private final ScreenElement[] createScreenElements(GraphicsDevice graphicsDevice, int n) {
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        Rectangle rectangle = graphicsConfiguration.getBounds();
        Insets insets = this.getScreenInsets(graphicsConfiguration);
        ScreenElement[] screenElementArray = new ScreenElement[n];
        int n2 = (int)rectangle.getHeight();
        int n3 = (int)rectangle.getWidth() / n;
        int n4 = 0;
        int n5 = 0;
        while (n5 < screenElementArray.length) {
            screenElementArray[n5] = new ScreenElement(new Rectangle(n4, 0, n3, n2), insets);
            n4 += n3;
            ++n5;
        }
        return screenElementArray;
    }

    private final ScreenElement[] createScreenElements(GraphicsDevice[] graphicsDeviceArray) {
        ArrayList<ScreenElement> arrayList = new ArrayList<ScreenElement>();
        int n = 0;
        while (n < graphicsDeviceArray.length) {
            GraphicsConfiguration graphicsConfiguration = graphicsDeviceArray[n].getDefaultConfiguration();
            Rectangle rectangle = graphicsConfiguration.getBounds();
            Insets insets = this.getScreenInsets(graphicsConfiguration);
            boolean bl = true;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Rectangle rectangle2 = ((ScreenElement)iterator.next()).getBounds();
                if (!rectangle2.intersects(rectangle)) continue;
                bl = false;
                break;
            }
            if (bl) {
                arrayList.add(new ScreenElement(rectangle, insets));
            }
            ++n;
        }
        return arrayList.toArray(new ScreenElement[arrayList.size()]);
    }

    private final ScreenElement[] createScreenElements(Rectangle[] rectangleArray) {
        ScreenElement[] screenElementArray = new ScreenElement[rectangleArray.length];
        int n = 0;
        while (n < rectangleArray.length) {
            screenElementArray[n] = new ScreenElement(rectangleArray[n], null);
            ++n;
        }
        return screenElementArray;
    }

    private final Rectangle[] collectScreenBounds() {
        Rectangle[] rectangleArray = new Rectangle[this.mScreenElements.length];
        int n = 0;
        while (n < this.mScreenElements.length) {
            rectangleArray[n] = this.mScreenElements[n].getBounds();
            ++n;
        }
        return rectangleArray;
    }

    private final GraphicsConfiguration findBestGraphicsConfiguration(GraphicsDevice[] graphicsDeviceArray) {
        if (graphicsDeviceArray.length == 0) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        int n = ScreenConfiguration.getColourSpaceType(graphicsConfiguration);
        DebugManager.getDefault().printTrace("Default monitor has colour type " + n);
        if (ScreenConfiguration.isGrayColourType(n)) {
            return graphicsConfiguration;
        }
        int n2 = 0;
        while (n2 < graphicsDeviceArray.length) {
            GraphicsConfiguration graphicsConfiguration2 = graphicsDeviceArray[n2].getDefaultConfiguration();
            int n3 = ScreenConfiguration.getColourSpaceType(graphicsConfiguration2);
            DebugManager.getDefault().printTrace("Monitor " + n2 + " has colour type " + n3);
            if (!ScreenConfiguration.isGrayColourType(n) && ScreenConfiguration.isGrayColourType(n3)) {
                graphicsConfiguration = graphicsConfiguration2;
                n = n3;
                DebugManager.getDefault().printTrace("Using graphics config for monitor " + n2);
            }
            ++n2;
        }
        return graphicsConfiguration;
    }

    private static final int getColourSpaceType(GraphicsConfiguration graphicsConfiguration) {
        return graphicsConfiguration.getColorModel().getColorSpace().getType();
    }

    private static final boolean isGrayColourType(int n) {
        boolean bl = false;
        if (n == 6) {
            bl = true;
        }
        return bl;
    }

    public GraphicsConfiguration getBestGraphicsConfiguration() {
        return this.mBestGraphicsConfiguration;
    }

    public CompositeScreen getCompositeScreen() {
        return this.mCompositeScreen;
    }

    public int getScreenCount() {
        return this.mScreenElements.length;
    }

    public int getScreenIndex(int n, int n2) {
        return this.getScreenIndex(new Point(n, n2));
    }

    public int getScreenIndex(Point point) {
        Rectangle[] rectangleArray = this.collectScreenBounds();
        int n = 0;
        double d = point.distance(rectangleArray[0].getCenterX(), rectangleArray[0].getCenterY());
        int n2 = 0;
        while (n2 < rectangleArray.length && !rectangleArray[n2].contains(point)) {
            double d2 = point.distance(rectangleArray[n2].getCenterX(), rectangleArray[n2].getCenterY());
            if (d2 < d) {
                d = d2;
                n = n2;
            }
            ++n2;
        }
        return n2 < rectangleArray.length ? n2 : n;
    }

    public Point getCentrePoint(int n, int n2, int n3, int n4) {
        return this.getCentrePoint(new Rectangle(n, n2, n3, n4));
    }

    public Point getCentrePoint(Rectangle rectangle) {
        int n;
        int n2;
        Rectangle[] rectangleArray = this.collectScreenBounds();
        Rectangle rectangle2 = rectangleArray[this.getScreenIndex(n2 = (int)(rectangle.getX() + (rectangle.getWidth() - 1.0) / (double)2), n = (int)(rectangle.getY() + (rectangle.getHeight() - 1.0) / (double)2))];
        Rectangle rectangle3 = rectangle2.intersects(rectangle) ? rectangle2.intersection(rectangle) : rectangleArray[0];
        return new Point((int)(rectangle3.getX() + (rectangle3.getWidth() - 1.0) / (double)2), (int)(rectangle3.getY() + (rectangle3.getHeight() - 1.0) / (double)2));
    }

    public Point getCentreOrigin(Rectangle rectangle, Dimension dimension) {
        return this.getCentreOrigin(rectangle, (int)dimension.getWidth(), (int)dimension.getHeight());
    }

    public Point getCentreOrigin(Rectangle rectangle, int n, int n2) {
        Point point = this.getCentrePoint(rectangle);
        Rectangle rectangle2 = this.mScreenElements[this.getScreenIndex(point)].getBounds();
        int n3 = (int)(point.getX() - (double)((n - 1) / 2));
        int n4 = (int)(point.getY() - (double)((n2 - 1) / 2));
        n3 = Math.min(n3, (int)(rectangle2.getX() + rectangle2.getWidth()) - n);
        n4 = Math.min(n4, (int)(rectangle2.getY() + rectangle2.getHeight()) - n2);
        return new Point(Math.max(n3, (int)rectangle2.getX()), Math.max(n4, (int)rectangle2.getY()));
    }

    public List getScreenBounds() {
        Rectangle[] rectangleArray = this.collectScreenBounds();
        ArrayList<Object> arrayList = new ArrayList<Object>(rectangleArray.length);
        int n = 0;
        while (n < rectangleArray.length) {
            Rectangle rectangle = rectangleArray[n];
            arrayList.add(rectangle.clone());
            ++n;
        }
        return arrayList;
    }

    public Rectangle getScreenBounds(int n) {
        return (Rectangle)this.mScreenElements[n].getBounds().clone();
    }

    public Rectangle[] getSpannedScreens(Rectangle rectangle) {
        return this.getSpannedScreens(rectangle, 0.0, 0.0);
    }

    public Rectangle[] getSpannedScreens(Rectangle rectangle, double d, double d2) {
        Rectangle[] rectangleArray = this.collectScreenBounds();
        ArrayList<Rectangle> arrayList = new ArrayList<Rectangle>();
        int n = 0;
        while (n < rectangleArray.length) {
            Rectangle rectangle2 = rectangleArray[n].intersection(rectangle);
            if (!(rectangle2.isEmpty() || rectangle2.getWidth() / rectangleArray[n].getWidth() <= d || rectangle2.getHeight() / rectangleArray[n].getHeight() <= d2)) {
                arrayList.add(new Rectangle(rectangleArray[n]));
            }
            ++n;
        }
        Rectangle rectangle3 = rectangleArray[this.getScreenIndex((int)rectangle.getCenterX(), (int)rectangle.getCenterY())];
        if (!arrayList.contains(rectangle3)) {
            arrayList.add(rectangle3);
        }
        return arrayList.toArray(new Rectangle[arrayList.size()]);
    }

    public Rectangle[] getHorizontallySpannedScreens(Rectangle rectangle, double d) {
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y + (rectangle.height - 1) / 2, rectangle.width, 1);
        return this.getSpannedScreens(rectangle2, d, 0.0);
    }

    public Rectangle[] getVerticallySpannedScreens(Rectangle rectangle, double d) {
        Rectangle rectangle2 = new Rectangle(rectangle.x + (rectangle.width - 1) / 2, rectangle.y, 1, rectangle.height);
        return this.getSpannedScreens(rectangle2, 0.0, d);
    }

    public Dimension getMaximumDimension() {
        Rectangle[] rectangleArray = this.collectScreenBounds();
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        while (n < rectangleArray.length) {
            Dimension dimension = rectangleArray[n].getSize();
            if (d < dimension.getWidth()) {
                d = dimension.getWidth();
            }
            if (d2 < dimension.getHeight()) {
                d2 = dimension.getHeight();
            }
            ++n;
        }
        return new Dimension((int)d, (int)d2);
    }

    public String toString() {
        Rectangle[] rectangleArray = this.collectScreenBounds();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < rectangleArray.length) {
            stringBuffer.append("Screen " + n + " bounds: " + rectangleArray[n] + ' ');
            ++n;
        }
        return stringBuffer.toString();
    }

    public ScreenConfiguration() {
        this(1);
    }

    public ScreenConfiguration(int n) {
        GraphicsDevice[] graphicsDeviceArray = ScreenConfiguration.getPhysicalScreenDevices();
        if (graphicsDeviceArray.length == 1 && n > 1) {
            this.mScreenElements = this.createScreenElements(graphicsDeviceArray[0], n);
            this.mCompositeScreen = new CompositeScreen(this.mScreenElements);
        } else {
            this.mScreenElements = this.createScreenElements(graphicsDeviceArray);
            this.mCompositeScreen = CompositeScreenBuilder.build(this.mScreenElements);
        }
        this.mBestGraphicsConfiguration = this.findBestGraphicsConfiguration(graphicsDeviceArray);
    }

    public ScreenConfiguration(Rectangle[] rectangleArray) {
        this.mScreenElements = this.createScreenElements(rectangleArray);
        this.mCompositeScreen = new CompositeScreen(this.mScreenElements);
        this.mBestGraphicsConfiguration = null;
    }
}

