/*
 * Decompiled with CFR 0.152.
 */
package ReportViewerLibrary.Export;

import ReportViewerLibrary.Export.ExportConfiguration;
import ReportViewerLibrary.Gui.ReportViewer;
import ReportViewerLibrary.Util.ReportViewerUtil;
import ReportViewerXml.OrderHeader;
import ReportViewerXml.Patient;
import java.util.HashMap;
import java.util.Map;

public abstract class HeaderField {
    private final ExportConfiguration.HeaderFieldType mType;
    private String mLabel;

    public ExportConfiguration.HeaderFieldType getType() {
        return this.mType;
    }

    public String getLabel() {
        return this.mLabel;
    }

    public void setLabel(String string) {
        this.mLabel = string;
    }

    public abstract String getValue(OrderHeader var1, Patient var2);

    public static Map getAllHeaderFields() {
        HashMap hashMap = new HashMap();
        HeaderField.addDefaultHeaderField(new PatientNameField(), hashMap);
        HeaderField.addDefaultHeaderField(new PatientDateOfBirthField(), hashMap);
        HeaderField.addDefaultHeaderField(new PatientIdField(), hashMap);
        HeaderField.addDefaultHeaderField(new ReferringPhysicianField(), hashMap);
        HeaderField.addDefaultHeaderField(new OrganizationField(), hashMap);
        HeaderField.addDefaultHeaderField(new StudyDateField(), hashMap);
        HeaderField.addDefaultHeaderField(new AccessionNumberField(), hashMap);
        HeaderField.addDefaultHeaderField(new RequestedProcedureIdField(), hashMap);
        HeaderField.addDefaultHeaderField(new StudyDescriptionField(), hashMap);
        HeaderField.addDefaultHeaderField(new ModalityField(), hashMap);
        HeaderField.addDefaultHeaderField(new ReportingMDField(), hashMap);
        HeaderField.addDefaultHeaderField(new DictatedStudyDateField(), hashMap);
        return hashMap;
    }

    private static final void addDefaultHeaderField(HeaderField headerField, Map map) {
        map.put(headerField.getType(), headerField);
    }

    public HeaderField(ExportConfiguration.HeaderFieldType headerFieldType, String string) {
        this.mType = headerFieldType;
        this.mLabel = string;
    }

    public static class PatientNameField
    extends HeaderField {
        public String getValue(OrderHeader orderHeader, Patient patient) {
            return patient.getName();
        }

        public PatientNameField() {
            this("Patient");
        }

        public PatientNameField(String string) {
            super(ExportConfiguration.HeaderFieldType.PATIENT_NAME, string);
        }
    }

    public static class PatientDateOfBirthField
    extends HeaderField {
        public String getValue(OrderHeader orderHeader, Patient patient) {
            return ReportViewer.formatPatientBirthDate(patient);
        }

        public PatientDateOfBirthField() {
            this("Patient DOB");
        }

        public PatientDateOfBirthField(String string) {
            super(ExportConfiguration.HeaderFieldType.PATIENT_DATE_OF_BIRTH, string);
        }
    }

    public static class PatientIdField
    extends HeaderField {
        public String getValue(OrderHeader orderHeader, Patient patient) {
            return patient.getId();
        }

        public PatientIdField() {
            this("Patient ID");
        }

        public PatientIdField(String string) {
            super(ExportConfiguration.HeaderFieldType.PATIENT_ID, string);
        }
    }

    public static class ReferringPhysicianField
    extends HeaderField {
        public String getValue(OrderHeader orderHeader, Patient patient) {
            return orderHeader.getReferringPhysician();
        }

        public ReferringPhysicianField() {
            this("Referring Physician");
        }

        public ReferringPhysicianField(String string) {
            super(ExportConfiguration.HeaderFieldType.REFERING_PHYSICIAN, string);
        }
    }

    public static class OrganizationField
    extends HeaderField {
        public String getValue(OrderHeader orderHeader, Patient patient) {
            return orderHeader.getOrganization() != null ? orderHeader.getOrganization() : "Not available";
        }

        public OrganizationField() {
            this("Organization");
        }

        public OrganizationField(String string) {
            super(ExportConfiguration.HeaderFieldType.ORGANIZATION, string);
        }
    }

    public static class StudyDateField
    extends HeaderField {
        public String getValue(OrderHeader orderHeader, Patient patient) {
            return ReportViewer.formatOrderHeaderStudyDateTime(orderHeader, "UNKNOWN");
        }

        public StudyDateField() {
            this("Date of Study");
        }

        public StudyDateField(String string) {
            super(ExportConfiguration.HeaderFieldType.STUDY_DATE, string);
        }
    }

    public static class AccessionNumberField
    extends HeaderField {
        public String getValue(OrderHeader orderHeader, Patient patient) {
            return orderHeader.getAccession();
        }

        public AccessionNumberField() {
            this("Accession Number");
        }

        public AccessionNumberField(String string) {
            super(ExportConfiguration.HeaderFieldType.ACCESSION, string);
        }
    }

    public static class RequestedProcedureIdField
    extends HeaderField {
        public String getValue(OrderHeader orderHeader, Patient patient) {
            return orderHeader.getRequestedProcedureId();
        }

        public RequestedProcedureIdField() {
            this("Requested Proc. ID");
        }

        public RequestedProcedureIdField(String string) {
            super(ExportConfiguration.HeaderFieldType.REQUESTED_PROCEDURE_ID, string);
        }
    }

    public static class StudyDescriptionField
    extends HeaderField {
        public String getValue(OrderHeader orderHeader, Patient patient) {
            return orderHeader.getDescription();
        }

        public StudyDescriptionField() {
            this("Study Description");
        }

        public StudyDescriptionField(String string) {
            super(ExportConfiguration.HeaderFieldType.STUDY_DESCRIPTION, string);
        }
    }

    public static class ModalityField
    extends HeaderField {
        public String getValue(OrderHeader orderHeader, Patient patient) {
            return orderHeader.getModality();
        }

        public ModalityField() {
            this("Modality");
        }

        public ModalityField(String string) {
            super(ExportConfiguration.HeaderFieldType.MODALITY, string);
        }
    }

    public static class ReportingMDField
    extends HeaderField {
        public String getValue(OrderHeader orderHeader, Patient patient) {
            return orderHeader.getReportingMd();
        }

        public ReportingMDField() {
            this("Reporting MD");
        }

        public ReportingMDField(String string) {
            super(ExportConfiguration.HeaderFieldType.REPORTING_MD, string);
        }
    }

    public static class DictatedStudyDateField
    extends HeaderField {
        public String getValue(OrderHeader orderHeader, Patient patient) {
            if (orderHeader.getDictatedStudyDate() == null) {
                return "Not available";
            }
            return ReportViewerUtil.DEFAULT_DATETIME_FORMAT.format(orderHeader.getDictatedStudyDate().getTime());
        }

        public DictatedStudyDateField() {
            this("Dictated Study Date");
        }

        public DictatedStudyDateField(String string) {
            super(ExportConfiguration.HeaderFieldType.DICTATED_STUDY_DATE, string);
        }
    }
}

