/*
 * Decompiled with CFR 0.152.
 */
package ReportViewerLibrary.Gui;

import DataModels.UserModels.PrivilegeSet;
import GuiUtilities.Icon.IconCache;
import GuiUtilities.Util.AlwaysOnTop;
import ReportViewerLibrary.Export.ExportConfiguration;
import ReportViewerLibrary.Export.ReportExportDialog;
import ReportViewerLibrary.Export.ReportImageProvider;
import ReportViewerLibrary.Gui.ActionHandler;
import ReportViewerLibrary.Gui.ImpressionsTool;
import ReportViewerLibrary.Gui.ListOfOrdersPane;
import ReportViewerLibrary.Gui.OrderStatusProvider;
import ReportViewerLibrary.Gui.PatientDemographicsPane;
import ReportViewerLibrary.Gui.ReportViewerModel;
import ReportViewerLibrary.Gui.ReportsPane;
import ReportViewerLibrary.Preferences.ReportViewerPreferenceProvider;
import ReportViewerLibrary.Util.ReportViewerUtil;
import ReportViewerXml.OrderHeader;
import ReportViewerXml.Patient;
import RuntimeTool.Debug;
import StringUtilities.StringCheck;
import UserXml.XmlUser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import java.util.Collections;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JSplitPane;
import javax.swing.border.EmptyBorder;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ReportViewer
extends JSplitPane {
    public static final String EXPORT_ACTION = "EXPORT";
    public static final String CLOSE_ACTION = "CLOSE";
    public static final String ALWAYS_ON_TOP_ACTION = "ALWAYS_ON_TOP";
    public static final String CHANGE_VIEW_ACTION = "CHANGE_VIEW";
    public static final String ADD_IMPRESSION_ACTION = "ADD_IMPRESSION";
    private static final String EXPORT_LABEL = "Export to PDF";
    private static final String CLOSE_LABEL = "Close";
    private static final String ALWAYS_ON_TOP_LABEL = "Always On Top";
    private static final String CHANGE_VIEW_LABEL = "Change View";
    private static final String ADD_IMPRESSION_LABEL = "Add Impression";
    private final Frame mOwner;
    private final XmlUser mXmlUser;
    private final URL mBaseUrl;
    private final ReportViewerPreferenceProvider mPreferenceProvider;
    private final ActionHandler mActionHandler;
    private final ExportConfiguration mExportConfiguration;
    private final File mTempExportDirectory;
    private final Debug mDebug;
    private ReportViewerModel mModel;
    private ExamId mExamId;
    private boolean mExportEnabled;
    private ReportImageProvider mReportImageProvider;
    private final OrderStatusProvider mOrderStatusProvider;
    private JPanel mNorthPane;
    private PatientDemographicsPane mPatientDemographicsPane;
    private ListOfOrdersPane mListOfOrdersPane;
    private ReportsPane mReportsPane;
    private JButton mAddImpressionButton;
    private JButton mExportButton;
    private JButton mCloseButton;
    private JMenu mFileMenu;
    private JMenu mViewMenu;
    private JMenu mToolsMenu;
    private JMenuItem mExportMenuItem;
    private JMenuItem mCloseMenuItem;
    private JCheckBoxMenuItem mAlwaysOnTopCheckboxMenuItem;
    private JMenuItem mChangeViewMenuItem;
    private JMenuItem mAddImpressionMenuItem;
    private IconCache mIconCache;
    private ImpressionsTool mImpressionsTool;

    void setAlwaysOnTop(boolean bl) {
        this.mPreferenceProvider.setAlwaysOnTop(bl);
        AlwaysOnTop.setAlwaysOnTop(this.mOwner, bl);
        AlwaysOnTop.setAlwaysOnTop(this.mImpressionsTool, bl);
    }

    public void resetAlwaysOnTop() {
        this.setAlwaysOnTop(this.mPreferenceProvider.isAlwaysOnTop());
    }

    private final void buildMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.setBorder(BorderFactory.createRaisedBevelBorder());
        this.mFileMenu = new JMenu("File", true);
        this.mFileMenu.setRolloverEnabled(true);
        this.mFileMenu.setMnemonic(70);
        this.mViewMenu = new JMenu("View", true);
        this.mViewMenu.setRolloverEnabled(true);
        this.mViewMenu.setMnemonic(86);
        this.mToolsMenu = new JMenu("Tools", true);
        this.mToolsMenu.setRolloverEnabled(true);
        this.mToolsMenu.setMnemonic(84);
        this.mAlwaysOnTopCheckboxMenuItem = new JCheckBoxMenuItem(ALWAYS_ON_TOP_LABEL);
        this.mAlwaysOnTopCheckboxMenuItem.setActionCommand(ALWAYS_ON_TOP_ACTION);
        this.mAlwaysOnTopCheckboxMenuItem.addActionListener(this.mActionHandler);
        this.mAlwaysOnTopCheckboxMenuItem.setSelected(this.mPreferenceProvider.isAlwaysOnTop());
        this.mCloseMenuItem = new JMenuItem(CLOSE_LABEL);
        this.mCloseMenuItem.setActionCommand(CLOSE_ACTION);
        this.mCloseMenuItem.addActionListener(this.mActionHandler);
        this.mExportMenuItem = new JMenuItem(EXPORT_LABEL);
        this.mExportMenuItem.setActionCommand(EXPORT_ACTION);
        this.mExportMenuItem.setEnabled(false);
        this.mExportMenuItem.addActionListener(this.mActionHandler);
        this.mChangeViewMenuItem = new JMenuItem(CHANGE_VIEW_LABEL);
        this.mChangeViewMenuItem.setActionCommand(CHANGE_VIEW_ACTION);
        this.mChangeViewMenuItem.addActionListener(this.mActionHandler);
        this.mAddImpressionMenuItem = new JMenuItem(ADD_IMPRESSION_LABEL);
        this.mAddImpressionMenuItem.setActionCommand(ADD_IMPRESSION_ACTION);
        this.mAddImpressionMenuItem.addActionListener(this.mActionHandler);
        this.enableImpression(true);
        this.mFileMenu.add(this.mExportMenuItem);
        this.mFileMenu.addSeparator();
        this.mFileMenu.add(this.mCloseMenuItem);
        if (AlwaysOnTop.isAvailable()) {
            this.mViewMenu.add(this.mAlwaysOnTopCheckboxMenuItem);
        }
        this.mViewMenu.add(this.mChangeViewMenuItem);
        this.mToolsMenu.add(this.mAddImpressionMenuItem);
        jMenuBar.add(this.mFileMenu);
        jMenuBar.add(this.mViewMenu);
        jMenuBar.add(this.mToolsMenu);
        this.determineRootPane().setJMenuBar(jMenuBar);
    }

    private final JRootPane determineRootPane() {
        return ((JFrame)this.mOwner).getRootPane();
    }

    private final void buildNorthPane() {
        this.mNorthPane = new JPanel(new BorderLayout());
        this.mNorthPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.buildPatientDemographicsPane(this.mNorthPane);
        this.buildListOfOrdersPane(this.mNorthPane);
        this.setTopComponent(this.mNorthPane);
    }

    private final void buildPatientDemographicsPane(JPanel jPanel) {
        this.mPatientDemographicsPane = new PatientDemographicsPane(this.mModel.getReportData().getReportViewerHeader().getPatient());
        jPanel.add("North", this.mPatientDemographicsPane);
    }

    private final void buildListOfOrdersPane(JPanel jPanel) {
        this.mListOfOrdersPane = new ListOfOrdersPane(this, this.mModel.getReportData().getReportViewerHeader().getOrderHeaderList(), this.getExamIdForUpdate(), this.mModel.isIheMode(), this.mOrderStatusProvider);
        jPanel.add("Center", this.mListOfOrdersPane);
    }

    private final void buildReportsPane() {
        this.mReportsPane = new ReportsPane(this);
        this.mReportsPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setBottomComponent(this.mReportsPane);
    }

    public PatientDemographicsPane getPatienDemographicsPane() {
        return this.mPatientDemographicsPane;
    }

    public ListOfOrdersPane getListOfOrdersPane() {
        return this.mListOfOrdersPane;
    }

    public ReportsPane getReportsPane() {
        return this.mReportsPane;
    }

    public void updateExamId(String string, String string2) {
        this.mDebug.printTrace("ReportViewer updated with accessionNumber [" + string + "], requestedProcedureId [" + string2 + "].");
        this.mExamId = new ExamId(string, string2);
        this.getListOfOrdersPane().updateSelection(this.getExamIdForUpdate());
        this.getReportsPane().update(this.getExamIdForUpdate());
    }

    String getExamIdForUpdate() {
        if (!this.mModel.isIheMode()) {
            return this.mExamId.getAccessionNumber();
        }
        if (this.mExamId.hasRequestedProcedureId()) {
            return this.mExamId.getPacsKey();
        }
        if (this.updateExamIdWithBestMatch(this.mExamId.getAccessionNumber())) {
            return this.mExamId.getPacsKey();
        }
        return null;
    }

    private final boolean updateExamIdWithBestMatch(String string) {
        OrderHeader orderHeader = this.mModel.findBestMatchingOrderHeader(string);
        if (orderHeader == null) {
            return false;
        }
        this.mExamId = new ExamId(orderHeader);
        return true;
    }

    public void updateReportImageProvider(ReportImageProvider reportImageProvider) {
        this.mReportImageProvider = reportImageProvider;
    }

    public String getAccession() {
        return this.mExamId.getAccessionNumber();
    }

    public ExamId getExamId() {
        return this.mExamId;
    }

    public boolean isIheMode() {
        return this.mModel.isIheMode();
    }

    public Map getOrderMap() {
        return this.mModel.getOrderMap();
    }

    public Map getOrderHeaderMap() {
        return this.mModel.getOrderHeaderMap();
    }

    public Window getOwner() {
        return this.mOwner;
    }

    public Patient getPatient() {
        return this.mModel.getReportData().getReportViewerHeader().getPatient();
    }

    public XmlUser getUser() {
        return this.mXmlUser;
    }

    String getEitServletBaseURL() {
        try {
            URL uRL = new URL(this.mBaseUrl.getProtocol(), this.mBaseUrl.getHost(), this.mBaseUrl.getPort(), "");
            return uRL.toString();
        }
        catch (MalformedURLException malformedURLException) {
            this.mDebug.printException("Unable to create URL for Eit Servlet", malformedURLException);
            return null;
        }
    }

    public void setExportButtonsEnabled(boolean bl) {
        this.mExportEnabled = bl;
        this.mExportButton.setEnabled(bl);
        this.mExportMenuItem.setEnabled(bl);
    }

    public boolean isExportEnabled() {
        return this.mExportEnabled;
    }

    public void showExportDialog() {
        ReportExportDialog reportExportDialog = new ReportExportDialog(this.mOwner, this, this.mReportImageProvider, this.mExportConfiguration, this.mTempExportDirectory);
        reportExportDialog.show();
    }

    Debug getDebug() {
        return this.mDebug;
    }

    ReportViewerPreferenceProvider getUserPreferences() {
        return this.mPreferenceProvider;
    }

    public boolean isAlwaysOnTopChecked() {
        return this.mAlwaysOnTopCheckboxMenuItem.isSelected();
    }

    public void changeView() {
        this.mReportsPane.changeInformationAreaView();
    }

    private final boolean userHasAddImpressionPrivilege() {
        XmlUser xmlUser = this.getUser();
        if (xmlUser == null) {
            return false;
        }
        return xmlUser.getPrivileges().getPrivilegeList().contains(PrivilegeSet.MODIFY_EIT_IMPRESSIONS);
    }

    public IconCache getIconCache() {
        return this.mIconCache;
    }

    ImpressionsTool createImpressionsTool() {
        if (this.mImpressionsTool != null) {
            this.mImpressionsTool.setVisible(true);
            this.mImpressionsTool.setState(0);
            return this.mImpressionsTool;
        }
        this.mImpressionsTool = new ImpressionsTool(this.mOwner, this.mReportsPane, this.mPreferenceProvider, this.getPatient(), this.mXmlUser, this.getEitServletBaseURL(), this.mDebug);
        this.mImpressionsTool.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ ReportViewer this$0;

            public final void windowClosed(WindowEvent windowEvent) {
                ReportViewer.access$1(this.this$0, null);
            }
            {
                this.this$0 = reportViewer;
            }
        });
        return this.mImpressionsTool;
    }

    public ImpressionsTool getCurrentImpressionTool() {
        return this.mImpressionsTool;
    }

    public JPanel createButtonsPanel() {
        this.determineRootPane().setDefaultButton(this.mCloseButton);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new EmptyBorder(8, 8, 8, 8));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 8;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(0, n, 0, n);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)this.mAddImpressionButton, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.mExportButton, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        jPanel.add((Component)this.mCloseButton, gridBagConstraints);
        return jPanel;
    }

    private final void initControlButtons() {
        this.mAddImpressionButton = new JButton(ADD_IMPRESSION_LABEL, this.mIconCache.getImageIcon("/ReportViewerLibrary/Gui/Icons/plus.png"));
        this.mAddImpressionButton.setActionCommand(ADD_IMPRESSION_ACTION);
        this.mAddImpressionButton.addActionListener(this.mActionHandler);
        this.enableImpression(true);
        this.mExportButton = new JButton(EXPORT_LABEL, this.mIconCache.getImageIcon("/ReportViewerLibrary/Gui/Icons/pdf-format-small.png"));
        this.mExportButton.setActionCommand(EXPORT_ACTION);
        this.mExportButton.addActionListener(this.mActionHandler);
        this.mExportButton.setEnabled(false);
        this.mCloseButton = new JButton(CLOSE_LABEL);
        this.mCloseButton.setActionCommand(CLOSE_ACTION);
        this.mCloseButton.addActionListener(this.mActionHandler);
    }

    void enableImpression(boolean bl) {
        if (!this.userHasAddImpressionPrivilege()) {
            bl = false;
        }
        if (this.mAddImpressionButton != null) {
            this.mAddImpressionButton.setEnabled(bl);
        }
        if (this.mAddImpressionMenuItem != null) {
            this.mAddImpressionMenuItem.setEnabled(bl);
        }
    }

    public static String formatPatientBirthDate(Patient patient) {
        Calendar calendar = patient.getBirthDate();
        if (calendar == null) {
            return "";
        }
        return ReportViewerUtil.DEFAULT_DATE_FORMAT.format(calendar.getTime());
    }

    public static String formatOrderHeaderStudyDateTime(OrderHeader orderHeader, String string) {
        if (orderHeader.getStudyDateTime() != null) {
            return ReportViewerUtil.DEFAULT_DATETIME_FORMAT.format(orderHeader.getStudyDateTime().getTime());
        }
        if (orderHeader.getStudyDate() != null) {
            return ReportViewerUtil.DEFAULT_DATE_FORMAT.format(orderHeader.getStudyDate().getTime());
        }
        return string;
    }

    static /* synthetic */ ImpressionsTool access$0(ReportViewer reportViewer) {
        return reportViewer.mImpressionsTool;
    }

    static /* synthetic */ void access$1(ReportViewer reportViewer, ImpressionsTool impressionsTool) {
        reportViewer.mImpressionsTool = impressionsTool;
    }

    private final /* synthetic */ void this() {
        this.mExportEnabled = false;
        this.mIconCache = new IconCache();
    }

    public ReportViewer(Frame frame, ReportViewerXml.ReportViewer reportViewer, XmlUser xmlUser, URL uRL, String string, String string2, ReportViewerPreferenceProvider reportViewerPreferenceProvider, ActionHandler actionHandler, ReportImageProvider reportImageProvider, ExportConfiguration exportConfiguration, File file, Predicate predicate, Debug debug) {
        this(frame, reportViewer, xmlUser, uRL, string, string2, reportViewerPreferenceProvider, actionHandler, reportImageProvider, exportConfiguration, file, predicate, Collections.EMPTY_MAP, debug);
    }

    public ReportViewer(Frame frame, ReportViewerXml.ReportViewer reportViewer, XmlUser xmlUser, URL uRL, String string, String string2, ReportViewerPreferenceProvider reportViewerPreferenceProvider, ActionHandler actionHandler, ReportImageProvider reportImageProvider, ExportConfiguration exportConfiguration, File file, Predicate predicate, Map map, Debug debug) {
        super(0);
        this.this();
        this.mOwner = frame;
        this.mXmlUser = xmlUser;
        this.mBaseUrl = uRL;
        this.mPreferenceProvider = reportViewerPreferenceProvider;
        this.mActionHandler = actionHandler;
        this.mReportImageProvider = reportImageProvider;
        this.mExportConfiguration = exportConfiguration;
        this.mTempExportDirectory = file;
        this.mOrderStatusProvider = new OrderStatusProviderImpl(map);
        this.mDebug = debug;
        this.mDebug.printTrace("ReportViewer invoked with accessionNumber [" + string + "], requestedProcedureId [" + string2 + "].");
        this.mModel = new ReportViewerModel(reportViewer, predicate);
        this.mDebug.printTrace("ReportViewer obtained report data from server. IHE mode? " + this.mModel.isIheMode());
        this.mExamId = new ExamId(string, string2);
        this.buildMenuBar();
        this.initControlButtons();
        this.buildNorthPane();
        this.buildReportsPane();
        frame.addWindowListener(new WindowHandler());
        this.addPropertyChangeListener(new PropertyChangeHandler());
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class ExamId {
        private String mAccessionNumber;
        private String mRequestedProcedureId;

        public String getAccessionNumber() {
            return this.mAccessionNumber;
        }

        boolean hasRequestedProcedureId() {
            return StringCheck.isStringEmpty(this.mRequestedProcedureId) ^ true;
        }

        public String getPacsKey() {
            return this.mAccessionNumber + '^' + this.mRequestedProcedureId;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ExamId)) {
                return false;
            }
            ExamId examId = (ExamId)object;
            boolean bl = false;
            if (StringUtils.equals((String)this.mAccessionNumber, (String)examId.mAccessionNumber) && StringUtils.equals((String)this.mRequestedProcedureId, (String)examId.mRequestedProcedureId)) {
                bl = true;
            }
            return bl;
        }

        public int hashCode() {
            int n = 0;
            if (this.mAccessionNumber != null) {
                n = this.mAccessionNumber.hashCode();
            }
            int n2 = n;
            int n3 = 0;
            if (this.mRequestedProcedureId != null) {
                n3 = this.mRequestedProcedureId.hashCode();
            }
            int n4 = n3;
            return n2 + 17 * n4;
        }

        private final /* synthetic */ void this() {
            this.mRequestedProcedureId = null;
        }

        private ExamId(String string, String string2) {
            this.this();
            this.mAccessionNumber = string;
            this.mRequestedProcedureId = string2;
        }

        private ExamId(OrderHeader orderHeader) {
            this(orderHeader.getAccession(), orderHeader.getRequestedProcedureId());
        }
    }

    class WindowHandler
    extends WindowAdapter {
        public void windowOpened(WindowEvent windowEvent) {
            double d = ReportViewer.this.getUserPreferences().getReportViewerDividerLocation();
            ReportViewer.this.setDividerLocation(d);
        }

        WindowHandler() {
        }
    }

    class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName() == "dividerLocation") {
                double d = (double)ReportViewer.this.getDividerLocation() / ReportViewer.this.getSize().getHeight();
                ReportViewer.this.getUserPreferences().setReportViewerDividerLocation(d);
            }
        }

        PropertyChangeHandler() {
        }
    }

    private static class OrderStatusProviderImpl
    implements OrderStatusProvider {
        private final Map mOrderStatusCodesDescription;

        public String getStatus(OrderHeader orderHeader) {
            String string = orderHeader.getStatusConfigKey();
            String string2 = orderHeader.getStatus();
            if (this.mOrderStatusCodesDescription == null || string == null) {
                return string2;
            }
            String string3 = (String)this.mOrderStatusCodesDescription.get(string);
            if (string3 == null) {
                return string2;
            }
            return string3 + " - " + string2;
        }

        private OrderStatusProviderImpl(Map map) {
            this.mOrderStatusCodesDescription = map;
        }
    }
}

