/*
 * Decompiled with CFR 0.152.
 */
package ReportViewerLibrary.RisDataClient;

import HttpUtilities.HttpUtilities;
import NetLibrary.LenientSslTrustManager;
import ReportViewerLibrary.RisDataClient.AuthenticationException;
import ReportViewerLibrary.RisDataClient.IncompatibleSchemaException;
import ReportViewerLibrary.RisDataClient.RisDataException;
import ReportViewerLibrary.RisDataClient.RisDataServerException;
import ReportViewerXml.ErrorCode;
import ReportViewerXml.OrderHeaderList;
import ReportViewerXml.ReportViewerHeader;
import ReportViewerXml.ReportViewerRoot;
import ReportViewerXml.Status;
import ReportViewerXml.StatusCode;
import RuntimeTool.Debug;
import XmlSchema.ReportViewerXml;
import XmlSchema.Util.LenientValidationHandler;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class RisDataClient {
    private final Debug mDebug;
    private final JAXBContext mJaxbContext;
    private final Unmarshaller mUnmarshaller;
    private ReportViewerRoot mReportData;

    private final InputStream connect(String string) throws MalformedURLException, IOException, RisDataException {
        InputStream inputStream = null;
        URL uRL = new URL(string);
        if (uRL != null && uRL.getProtocol().equals("https")) {
            this.mDebug.printTrace("Setting lenient https trust");
            try {
                LenientSslTrustManager.setLenientHttpsTrustManager();
            }
            catch (Exception exception) {
                this.mDebug.printException("Could not set lenient SSL trust", exception);
            }
        }
        this.mDebug.printTrace("Opening connection to report viewer server: " + string);
        URLConnection uRLConnection = uRL.openConnection();
        InputStream inputStream2 = uRLConnection.getInputStream();
        this.verifySchemaCompatibilityFromHeader(uRLConnection);
        String string2 = uRLConnection.getContentEncoding();
        if (string2 != null && (string2.equals("gzip") || string2.equals("x-gzip"))) {
            this.mDebug.printTrace("Obtained compressed input stream");
            GZIPInputStream gZIPInputStream = new GZIPInputStream(inputStream2);
            inputStream = gZIPInputStream;
        } else {
            this.mDebug.printTrace("Obtained regular input stream");
            inputStream = inputStream2;
        }
        return inputStream;
    }

    private final void verifySchemaCompatibilityFromHeader(URLConnection uRLConnection) throws IncompatibleSchemaException {
        int n = HttpUtilities.getIntHeader(uRLConnection, "Intelerad-Schema-Version-Major", 0);
        int n2 = HttpUtilities.getIntHeader(uRLConnection, "Intelerad-Schema-Version-Minor", 0);
        this.mDebug.printTrace("Checking HTTP header for server schema version");
        this.verifySchemaCompatibility(n, n2);
    }

    private final void verifySchemaCompatibility(int n, int n2) throws IncompatibleSchemaException {
        if (n > 0) {
            String string = "" + n + '.' + n2;
            if (n != 2) {
                String string2 = "Server ReportViewerXml schema version " + string + " is incompatible with client schema version " + ReportViewerXml.getSchemaVersion();
                throw new IncompatibleSchemaException(string2);
            }
            if (n2 != 3) {
                this.mDebug.printWarning("Minor ReportViewerXml schema version difference: server: " + string + ", client: " + ReportViewerXml.getSchemaVersion());
            } else {
                this.mDebug.printDebug("Server and client ReportViewerXml schema versions match exactly (" + string + ')');
            }
        } else {
            this.mDebug.printWarning("Server did not provide the ReportViewerXml schema version.");
        }
    }

    private final void parseInput(InputStream inputStream) throws JAXBException, RisDataException {
        this.mDebug.printTrace("In RisDataClient.parseInput. Unmarshalling data from input stream");
        this.mReportData = (ReportViewerRoot)this.mUnmarshaller.unmarshal(inputStream);
        if (this.mReportData == null) {
            String string = "ReportData returned by server is null";
            throw new RisDataException(string);
        }
        this.verifySchemaCompatibilityFromXml();
        Status status = this.mReportData.getStatus();
        if (status != null) {
            if (status.getStatusCode() == StatusCode.ERROR) {
                ErrorCode errorCode = status.getErrorCode();
                String string = status.getDetails();
                if (this.isAuthenticationError(errorCode)) {
                    throw new AuthenticationException("Failed user authentication. Server returned\n" + errorCode + ": " + string);
                }
                throw new RisDataException("ERROR Status returned by server: " + errorCode + " [ " + string + ']');
            }
            this.mDebug.printTrace("OK Status returned by server");
        } else {
            this.mDebug.printWarning("No status info returned by server. Could be due to early PACS-2-3-6 version of XmlDataServlet");
        }
        ReportViewerHeader reportViewerHeader = this.mReportData.getReportViewerHeader();
        if (reportViewerHeader == null) {
            String string = "ReportViewerHeader returned by server is null";
            throw new RisDataException(string);
        }
        OrderHeaderList orderHeaderList = reportViewerHeader.getOrderHeaderList();
        if (orderHeaderList == null) {
            String string = "OrderHeaderList returned by server is null";
            throw new RisDataException(string);
        }
        int n = orderHeaderList.getNumberOfOrderHeaders();
        this.mDebug.printTrace("Data contains " + n + " orders.");
    }

    private final void verifySchemaCompatibilityFromXml() throws IncompatibleSchemaException {
        int n = this.mReportData.getSchemaVersionMajor();
        int n2 = this.mReportData.getSchemaVersionMinor();
        this.mDebug.printTrace("Checking schema version in unmarshalled objects");
        this.verifySchemaCompatibility(n, n2);
    }

    public ReportViewerRoot getReportData() {
        return this.mReportData;
    }

    private final boolean isAuthenticationError(ErrorCode errorCode) {
        boolean bl = false;
        if (errorCode == ErrorCode.FAILED_AUTHENTICATION_MACADDRESS || errorCode == ErrorCode.FAILED_AUTHENTICATION_PASSWORD || errorCode == ErrorCode.FAILED_AUTHENTICATION_SID) {
            bl = true;
        }
        return bl;
    }

    public RisDataClient(String string, Debug debug) throws RisDataException, MalformedURLException, IOException {
        this(string, debug, true);
    }

    RisDataClient(String string, Debug debug, boolean bl) throws RisDataException, MalformedURLException, IOException {
        this.mDebug = debug;
        String string2 = string;
        if (bl) {
            string2 = string2 + "&schemaVersion=2";
        }
        this.mDebug.printTrace("In RisDataClient constructor. Creating new JAXBContext and Unmarshaller");
        try {
            this.mJaxbContext = JAXBContext.newInstance((String)"ReportViewerXml", (ClassLoader)this.getClass().getClassLoader());
            this.mUnmarshaller = this.mJaxbContext.createUnmarshaller();
            LenientValidationHandler.makeUnmarshallerLenient(this.mUnmarshaller);
            this.parseInput(this.connect(string2));
        }
        catch (JAXBException jAXBException) {
            throw new RisDataServerException(jAXBException.getMessage());
        }
    }
}

