/*
 * Decompiled with CFR 0.152.
 */
package RuntimeTool;

import RuntimeTool.ControlFileDataException;
import RuntimeTool.ControlFileException;
import RuntimeTool.ControlFileIOException;
import RuntimeTool.SectionData;
import StringUtilities.StringCheck;
import StringUtilities.StringJoin;
import StringUtilities.StringSplit;
import StringUtilities.StringStrip;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ControlFile
implements Map {
    private static final String KEY_DELIMITER = "=";
    private static final List BOOLEAN_TRUE = Arrays.asList("true", "yes", "on");
    private static final List BOOLEAN_FALSE = Arrays.asList("false", "no", "off");
    private static final Object VALIDATION_FAILED = new Object();
    private static Map VALID_TYPES = new HashMap();
    private static final Pattern NORMAL_SECTION_RE;
    protected String mFilename;
    private BufferedReader mReader;
    private String mActiveSection;
    private LinkedHashMap mSectionMap;
    private String mDefaultSection;
    private long mLastModified;
    private int mLineNumber;
    private Map mValidValues;
    protected String mFileName;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Double;

    public String getFileName() {
        return this.getFilename();
    }

    public String getFilename() {
        return this.mFilename;
    }

    protected void validateControlData() throws ControlFileException {
    }

    protected void populate() throws ControlFileException {
    }

    public boolean FileModified() {
        boolean bl = false;
        if (this.mLastModified != this.GetLastModified()) {
            bl = true;
        }
        return bl;
    }

    public String GetValue(String string, String string2) {
        SectionData sectionData = (SectionData)this.mSectionMap.get(string);
        if (sectionData == null) {
            return null;
        }
        Map map = sectionData.getSectionMap();
        if (map == null) {
            return null;
        }
        return (String)map.get(string2);
    }

    public List GetValueArray(String string, String string2, String string3) {
        String string4 = this.GetValue(string, string2);
        if (string4 == null) {
            return null;
        }
        return StringSplit.split(string4, string3, true, true);
    }

    public String getSybaseServerForHost(String string) throws ParseException {
        String string2 = this.GetStringValue("SYBASE_SERVER_NAMES", string);
        if (StringCheck.isStringEmpty(string2)) {
            throw new ParseException("Unable to find [SYBASE_SERVER_NAMES:" + string + "] in file " + this.mFilename, 0);
        }
        return string2;
    }

    public int GetIntValue(String string, String string2) {
        String string3 = this.GetValue(string, string2);
        try {
            return Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.createFormatException(string, string2, "integer", string3);
        }
    }

    public long GetLongValue(String string, String string2) {
        String string3 = this.GetValue(string, string2);
        try {
            return Long.parseLong(string3);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.createFormatException(string, string2, "long integer", string3);
        }
    }

    public int getInt(String string, String string2) {
        Class clazz = class$java$lang$Integer;
        if (clazz == null) {
            clazz = class$java$lang$Integer = ControlFile.class$("[Ljava.lang.Integer;", false);
        }
        return (Integer)this.getValidValue(string, string2, clazz);
    }

    public boolean getBoolean(String string, String string2) {
        Class clazz = class$java$lang$Boolean;
        if (clazz == null) {
            clazz = class$java$lang$Boolean = ControlFile.class$("[Ljava.lang.Boolean;", false);
        }
        return (Boolean)this.getValidValue(string, string2, clazz);
    }

    public double getDouble(String string, String string2) {
        Class clazz = class$java$lang$Double;
        if (clazz == null) {
            clazz = class$java$lang$Double = ControlFile.class$("[Ljava.lang.Double;", false);
        }
        return (Double)this.getValidValue(string, string2, clazz);
    }

    public int getInt(String string, String string2, int n) {
        try {
            return Integer.parseInt(this.GetValue(string, string2));
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public String getAndTestStringValue(String string, String string2) throws ControlFileException {
        this.requireKeysSet(string, new String[]{string2});
        return this.GetStringValue(string, string2);
    }

    public String GetStringValue(String string, String string2) {
        return this.GetValue(string, string2);
    }

    public boolean GetBooleanValue(String string, String string2) {
        String string3 = this.GetValue(string, string2);
        if (string3 == null) {
            throw this.createFormatException(string, string2, "boolean", string3);
        }
        if (BOOLEAN_TRUE.contains(string3 = string3.toLowerCase())) {
            return true;
        }
        if (BOOLEAN_FALSE.contains(string3)) {
            return false;
        }
        throw this.createFormatException(string, string2, "boolean", string3);
    }

    public double GetDoubleValue(String string, String string2) {
        String string3 = "floating-point";
        String string4 = this.GetValue(string, string2);
        try {
            if (string4 == null) {
                throw this.createFormatException(string, string2, string3, string4);
            }
            return Double.parseDouble(string4);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.createFormatException(string, string2, string3, string4);
        }
    }

    public Hashtable GetSections() {
        LinkedHashMap linkedHashMap = (LinkedHashMap)this.GetSectionsOrdered();
        if (linkedHashMap == null) {
            return null;
        }
        return new Hashtable(this.GetSectionsOrdered());
    }

    public Map GetSectionsOrdered() {
        LinkedHashMap<String, LinkedHashMap> linkedHashMap = new LinkedHashMap<String, LinkedHashMap>();
        LinkedHashMap linkedHashMap2 = null;
        Iterator iterator = this.mSectionMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            linkedHashMap2 = (LinkedHashMap)this.GetSectionOrdered(string);
            if (linkedHashMap2 == null) continue;
            linkedHashMap.put(string, linkedHashMap2);
        }
        return linkedHashMap;
    }

    public Hashtable GetSection(String string) {
        LinkedHashMap linkedHashMap = (LinkedHashMap)this.GetSectionOrdered(string);
        if (linkedHashMap == null) {
            return null;
        }
        return new Hashtable(this.GetSectionOrdered(string));
    }

    public Map GetSectionOrdered(String string) {
        SectionData sectionData = (SectionData)this.mSectionMap.get(string);
        if (sectionData == null) {
            return null;
        }
        return sectionData.getSectionMap();
    }

    public String getDatabaseTypeForHost(String string, String string2) throws ControlFileException {
        if (StringCheck.isStringEmpty(string2)) {
            throw new ControlFileException("Host is null or empty. Can't find DB type for an empty host for section " + string);
        }
        LinkedHashMap linkedHashMap = (LinkedHashMap)this.GetSectionOrdered(string);
        if (linkedHashMap == null) {
            throw new ControlFileException("in file (" + this.mFilename + ")  section [" + string + "] does not exist.");
        }
        List list = this.GetValueArray(string, "SYBASE_SERVER_HOSTS", ",");
        if (list.contains(string2)) {
            return "sybase";
        }
        list = this.GetValueArray(string, "MSQL_SERVER_HOSTS", ",");
        if (list.contains(string2)) {
            return "msql";
        }
        throw new ControlFileException("Unable to find DB type for host (" + string2 + ") since file (" + this.mFilename + ") does not have this host listed under " + string + ":SYBASE_SERVER_HOSTS or " + string + ":MSQL_SERVER_HOSTS.");
    }

    public SectionData getSectionData(String string) {
        SectionData sectionData = (SectionData)this.mSectionMap.get(string);
        if (sectionData == null) {
            return null;
        }
        return new SectionData(sectionData);
    }

    public String GetValueForException(String string, String string2) {
        try {
            return this.getAndTestValueForException(string, string2);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }

    public String getAndTestValueForException(String string, String string2) throws NoSuchFieldException {
        LinkedHashMap linkedHashMap = (LinkedHashMap)this.GetSectionOrdered(string);
        if (linkedHashMap == null) {
            throw new NoSuchFieldException("in file (" + this.mFilename + ") section [" + string + "] does not exist.");
        }
        Iterator iterator = linkedHashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            Set set = this.getAllValuesAvailable((String)linkedHashMap.get(string3));
            if (!set.contains(string2)) continue;
            return string3;
        }
        throw new NoSuchFieldException("in file (" + this.mFilename + "), the value (" + string2 + ") is missing from the section [" + string + ']');
    }

    public Vector GetKeysStartingWith(String string, String string2) {
        Vector<String> vector = new Vector<String>();
        Hashtable hashtable = this.GetSection(string);
        if (hashtable == null) {
            return null;
        }
        Iterator iterator = hashtable.keySet().iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (!string3.startsWith(string2)) continue;
            vector.add(string3);
        }
        return vector;
    }

    public Vector GetSectionsStartingWith(String string) {
        Vector<String> vector = new Vector<String>();
        Iterator iterator = this.mSectionMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string2.startsWith(string) || this.GetSection(string2) == null) continue;
            vector.add(string2);
        }
        return vector;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void Read() throws ControlFileException {
        block6: {
            try {
                this.parseFile();
            }
            catch (Throwable var1_1) {
                var2_2 = null;
                try {
                    this.mReader.close();
                    throw var1_1;
                }
                catch (IOException var3_4) {
                    // empty catch block
                }
                throw var1_1;
            }
            {
                var2_3 = null;
            }
            ** try [egrp 1[TRYBLOCK] [1 : 14->24)] { 
lbl15:
            // 1 sources

            this.mReader.close();
            break block6;
lbl17:
            // 1 sources

            catch (IOException var3_5) {
                // empty catch block
            }
        }
        this.populate();
        this.validateControlData();
    }

    private final Set getAllValuesAvailable(String string) {
        return StringSplit.setSplit(string, ",", true, false);
    }

    public String[] PrintMissingKeys(String string, String[] stringArray) {
        String[] stringArray2 = this.GetMissingKeys(string, stringArray);
        if (stringArray2 == null) {
            return null;
        }
        int n = 0;
        while (n < stringArray2.length) {
            System.out.println("Missing key: [" + string + ':' + stringArray2[n] + ']');
            ++n;
        }
        return stringArray2;
    }

    public String[] keysMissingOrEmpty(String string, String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < stringArray.length) {
            String string2 = this.GetStringValue(string, stringArray[n]);
            if (StringCheck.isStringBlank(string2)) {
                vector.addElement(stringArray[n]);
            }
            ++n;
        }
        return vector.toArray(new String[0]);
    }

    public String keysMissing(String string, String[] stringArray) {
        Object[] objectArray = this.GetMissingKeys(string, stringArray);
        if (objectArray == null) {
            return "";
        }
        return StringJoin.arrayJoin(objectArray, ", ");
    }

    public String[] GetMissingKeys(String string, String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < stringArray.length) {
            if (this.GetValue(string, stringArray[n]) == null) {
                arrayList.add(stringArray[n]);
            }
            ++n;
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public void requireSection(String string) throws ControlFileException {
        if (!this.mSectionMap.containsKey(string)) {
            throw this.dataError(null, null, "missing required section '" + string + '\'');
        }
    }

    public void requireKeys(String string, String[] stringArray) throws ControlFileException {
        Object[] objectArray = this.GetMissingKeys(string, stringArray);
        if (objectArray != null) {
            throw this.dataError(string, null, "missing keys: " + StringJoin.arrayJoin(objectArray, ", "));
        }
    }

    public void requireKeysSet(String string, String[] stringArray) throws ControlFileException {
        this.requireSection(string);
        SectionData sectionData = (SectionData)this.mSectionMap.get(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < stringArray.length) {
            if (StringCheck.isStringBlank((String)sectionData.get(stringArray[n]))) {
                arrayList.add(stringArray[n]);
            }
            ++n;
        }
        if (!arrayList.isEmpty()) {
            throw this.dataError(string, null, "missing or unset keys: " + StringJoin.listJoin(arrayList, ", "));
        }
    }

    public int requireInt(String string, String string2) throws ControlFileException {
        this.requireSection(string);
        SectionData sectionData = (SectionData)this.mSectionMap.get(string);
        String string3 = (String)sectionData.get(string2);
        try {
            Integer n = new Integer(string3);
            this.putValidValue(string, string2, n);
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            this.putValidValue(string, string2, VALIDATION_FAILED);
            throw this.valueError(string, string2, "integer", string3);
        }
    }

    public boolean requireBoolean(String string, String string2) throws ControlFileException {
        this.requireSection(string);
        String string3 = this.GetValue(string, string2);
        ControlFileException controlFileException = null;
        Boolean bl = null;
        if (string3 == null) {
            controlFileException = this.valueError(string, string2, "boolean", null);
        } else if (BOOLEAN_TRUE.contains(string3 = string3.toLowerCase())) {
            bl = Boolean.TRUE;
        } else if (BOOLEAN_FALSE.contains(string3)) {
            bl = Boolean.FALSE;
        } else {
            controlFileException = this.valueError(string, string2, "boolean", string3);
        }
        if (controlFileException != null) {
            this.putValidValue(string, string2, VALIDATION_FAILED);
            throw controlFileException;
        }
        this.putValidValue(string, string2, bl);
        return bl;
    }

    public double requireDouble(String string, String string2) throws ControlFileException {
        this.requireSection(string);
        String string3 = this.GetValue(string, string2);
        Double d = null;
        ControlFileException controlFileException = null;
        if (string3 == null) {
            controlFileException = this.valueError(string, string2, "floating-point", string3);
        } else {
            try {
                d = new Double(string3);
            }
            catch (NumberFormatException numberFormatException) {
                controlFileException = this.valueError(string, string2, "floating-point", string3);
            }
        }
        if (controlFileException != null) {
            this.putValidValue(string, string2, VALIDATION_FAILED);
            throw controlFileException;
        }
        this.putValidValue(string, string2, d);
        return d;
    }

    private final Object getValidValue(String string, String string2, Class clazz) {
        if (!VALID_TYPES.containsKey(clazz)) {
            throw new IllegalArgumentException("cannot fetch values of type " + clazz + " from valid values map");
        }
        String string3 = "key '" + string2 + "' (section '" + string + "')";
        Map map = (Map)this.mValidValues.get(string);
        if (map == null) {
            throw new IllegalStateException(string3 + " not validated yet");
        }
        Object v = map.get(string2);
        if (v == null) {
            throw new IllegalStateException(string3 + " not validated yet");
        }
        if (v == VALIDATION_FAILED) {
            throw new IllegalStateException(string3 + " failed validation");
        }
        if (v.getClass() != clazz) {
            Class clazz2 = (Class)VALID_TYPES.get(v.getClass());
            Class clazz3 = (Class)VALID_TYPES.get(clazz);
            throw new IllegalStateException(string3 + " validated as " + clazz2 + ", not " + clazz3);
        }
        return v;
    }

    private final void putValidValue(String string, String string2, Object object) {
        Object v;
        if (!VALID_TYPES.containsKey(object.getClass()) && object != VALIDATION_FAILED) {
            throw new IllegalArgumentException("cannot put object of type " + object.getClass() + " in valid values map");
        }
        HashMap<String, Object> hashMap = (HashMap<String, Object>)this.mValidValues.get(string);
        if (hashMap == null) {
            hashMap = new HashMap<String, Object>();
            this.mValidValues.put(string, hashMap);
        }
        if ((v = hashMap.get(string2)) != null && v.getClass() != object.getClass()) {
            throw new IllegalStateException(this.mFilename + ", section '" + string + "': key '" + string2 + "' has already been validated as " + VALID_TYPES.get(v.getClass()));
        }
        hashMap.put(string2, object);
    }

    public void addSection(String string, SectionData sectionData) {
        if (this.mSectionMap.containsKey(string)) {
            throw new IllegalArgumentException("already have section [" + string + ']');
        }
        this.mSectionMap.put(string, sectionData);
    }

    ControlFileException syntaxError(String string) {
        return new ControlFileException(this.mFilename, this.mLineNumber, string);
    }

    ControlFileException redirectError(String string) {
        return new ControlFileException(this.mFilename, string);
    }

    public ControlFileException dataError(String string, String string2, String string3) {
        return new ControlFileDataException(this.mFilename, string, string2, string3);
    }

    private final NumberFormatException createFormatException(String string, String string2, String string3, String string4) {
        String string5 = string4 == null ? ": no such key '" + string2 + '\'' : ", key '" + string2 + "': invalid " + string3 + " value '" + string4 + '\'';
        return new NumberFormatException(this.mFilename + ", section '" + string + '\'' + string5);
    }

    private final ControlFileException valueError(String string, String string2, String string3, String string4) {
        if (string4 == null) {
            return new ControlFileDataException(this.mFilename, string, null, "missing required key '" + string2 + '\'');
        }
        return new ControlFileDataException(this.mFilename, string, string2, "invalid " + string3 + " value '" + string4 + '\'');
    }

    private final void parseFile() throws ControlFileException {
        String string;
        this.mLineNumber = 0;
        while ((string = this.readLine()) != null) {
            ++this.mLineNumber;
            if ((string = string.trim()).length() <= 0 || string.startsWith("#") || this.sectionStarts(string = StringStrip.getRidOfComments(string))) continue;
            int n = string.indexOf(KEY_DELIMITER);
            if (n == -1) {
                throw this.syntaxError("syntax error: delimiter not found");
            }
            String string2 = string.substring(0, n).trim();
            String string3 = string.substring(n + 1, string.length()).trim();
            this.StoreKeyValue(string2, string3);
        }
    }

    private final String readLine() throws ControlFileIOException {
        try {
            return this.mReader.readLine();
        }
        catch (IOException iOException) {
            throw new ControlFileIOException(this.mFilename, "error reading from file", iOException);
        }
    }

    private final long GetLastModified() {
        File file = new File(this.mFilename);
        return file.lastModified();
    }

    private final void OpenFile() throws ControlFileIOException {
        try {
            this.mReader = new BufferedReader(new FileReader(this.mFilename));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ControlFileIOException(this.mFilename, "file not found", fileNotFoundException);
        }
    }

    private final void StoreKeyValue(String string, String string2) throws ControlFileException {
        SectionData sectionData;
        if (this.mActiveSection.equals("")) {
            this.mSectionMap.put(this.mDefaultSection, new SectionData(this));
            this.mActiveSection = this.mDefaultSection;
        }
        if ((sectionData = (SectionData)this.mSectionMap.get(this.mActiveSection)) == null) {
            return;
        }
        sectionData.store(string, string2);
    }

    private final void storeActiveSection(String string, SectionData sectionData) {
        this.mActiveSection = string;
        if (this.mSectionMap.containsKey(this.mActiveSection)) {
            System.err.println("Duplicated section found while parsing control file: " + this.mFilename + ", section is: " + this.mActiveSection);
            System.exit(1);
        }
        this.mSectionMap.put(this.mActiveSection, sectionData);
    }

    private final boolean sectionStarts(String string) {
        Pattern pattern = NORMAL_SECTION_RE;
        Matcher matcher = pattern.matcher(string = StringStrip.getRidOfComments(string));
        if (matcher.find()) {
            this.storeActiveSection(matcher.group(1), new SectionData(this));
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.GetSections().keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            stringBuffer.append("[" + string + "]\n");
            Iterator iterator2 = this.GetSectionOrdered(string).keySet().iterator();
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                stringBuffer.append(string2 + " = " + this.GetStringValue(string, string2) + '\n');
            }
        }
        return stringBuffer.toString();
    }

    private final UnsupportedOperationException immutable() {
        return new UnsupportedOperationException("ControlFile is an immutable map");
    }

    public int size() {
        return this.mSectionMap.size();
    }

    public void clear() {
        throw this.immutable();
    }

    public boolean isEmpty() {
        return this.mSectionMap.isEmpty();
    }

    public boolean containsKey(Object object) {
        return this.mSectionMap.containsKey(object);
    }

    public boolean containsValue(Object object) {
        return this.mSectionMap.containsValue(object);
    }

    public Collection values() {
        return this.mSectionMap.values();
    }

    public void putAll(Map map) {
        throw this.immutable();
    }

    public Set entrySet() {
        return this.mSectionMap.entrySet();
    }

    public Set keySet() {
        return this.mSectionMap.keySet();
    }

    public Object get(Object object) {
        return this.mSectionMap.get(object);
    }

    public Object remove(Object object) {
        throw this.immutable();
    }

    public Object put(Object object, Object object2) {
        throw this.immutable();
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.mActiveSection = "";
        this.mDefaultSection = "UNNAMED";
        this.mLineNumber = -1;
        this.mValidValues = new HashMap();
        this.mFileName = null;
    }

    public ControlFile(String string) throws ControlFileException {
        this.this();
        this.mFilename = string;
        this.mSectionMap = new LinkedHashMap();
        this.OpenFile();
        this.mLastModified = this.GetLastModified();
    }

    public ControlFile(InputStream inputStream, String string) {
        this(new InputStreamReader(inputStream), string);
    }

    public ControlFile(Reader reader, String string) {
        this.this();
        this.mFilename = string;
        this.mLastModified = -1;
        this.mSectionMap = new LinkedHashMap();
        this.mReader = new BufferedReader(reader);
    }

    public ControlFile() {
        this.this();
    }

    static {
        Class clazz = class$java$lang$Integer;
        if (clazz == null) {
            clazz = class$java$lang$Integer = ControlFile.class$("[Ljava.lang.Integer;", false);
        }
        VALID_TYPES.put(clazz, Integer.TYPE);
        Class clazz2 = class$java$lang$Boolean;
        if (clazz2 == null) {
            clazz2 = class$java$lang$Boolean = ControlFile.class$("[Ljava.lang.Boolean;", false);
        }
        VALID_TYPES.put(clazz2, Boolean.TYPE);
        Class clazz3 = class$java$lang$Double;
        if (clazz3 == null) {
            clazz3 = class$java$lang$Double = ControlFile.class$("[Ljava.lang.Double;", false);
        }
        VALID_TYPES.put(clazz3, Double.TYPE);
        NORMAL_SECTION_RE = Pattern.compile("^\\s*\\[(.+?)\\]\\s*$");
    }
}

