/*
 * Decompiled with CFR 0.152.
 */
package RuntimeTool;

import RuntimeTool.Debug;

public class DebugManager {
    private static Debug mGlobalDefault = new Debug("UNKNOWN", "stdout", "ALL");
    private static ThreadLocal mThreadDefault = new ThreadLocal();

    public static void setGlobalDefault(Debug debug) {
        mGlobalDefault = debug;
    }

    public static Debug getGlobalDefault() {
        return mGlobalDefault;
    }

    public static void closeGlobalDefault() {
        mGlobalDefault.close();
        mGlobalDefault = null;
    }

    public static void setDefault(Debug debug) {
        mThreadDefault.set(debug);
    }

    public static void closeDefault() {
        Debug debug = (Debug)mThreadDefault.get();
        if (debug != null) {
            debug.close();
            mThreadDefault.set(null);
        }
    }

    public static Debug getDefault() {
        return DebugManager.getDefault(null);
    }

    public static Debug getDefault(Debug debug) {
        Debug debug2 = (Debug)mThreadDefault.get();
        if (debug2 != null) {
            return debug2;
        }
        if (debug != null) {
            return debug;
        }
        return mGlobalDefault;
    }

    public static boolean isDefaultSet() {
        boolean bl = false;
        if (mThreadDefault.get() != null) {
            bl = true;
        }
        return bl;
    }

    private DebugManager() {
    }
}

