/*
 * Decompiled with CFR 0.152.
 */
package StringUtilities;

import StringUtilities.StringCheck;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringEscape {
    private static final Pattern REGEXP_BR = Pattern.compile("<br/?>", 2);

    public static String escapeCharacters(String string, String string2, String string3) {
        int n;
        if (string == null) {
            return string;
        }
        boolean bl = false;
        int n2 = 0;
        while (n2 < string.length()) {
            n = string.charAt(n2);
            if (string2.indexOf(n) != -1) {
                bl = true;
                break;
            }
            ++n2;
        }
        if (!bl) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (string2.indexOf(c) != -1) {
                stringBuffer.append(string3);
            }
            stringBuffer.append(c);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String EscapeCharacter(String string, String string2, String string3) {
        return StringEscape.escapeCharacters(string, string2, string3);
    }

    public static String escapeSql(String string) {
        return StringEscape.escapeCharacters(string, "'", "'");
    }

    public static String quoteSql(String string) {
        if (string == null) {
            return "NULL";
        }
        return "'" + StringEscape.escapeSql(string) + '\'';
    }

    public static String searchAndReplaceString(String string, String string2, String string3) {
        if (string == null) {
            return string;
        }
        if (string3.indexOf(92) >= 0 || string3.indexOf(36) >= 0) {
            string3 = string3.replaceAll("([\\\\\\$])", "\\\\$1");
        }
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        return matcher.replaceAll(string3);
    }

    public static String escapeHtml(String string) {
        int n;
        if (string == null) {
            return null;
        }
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        while (n3 < string.length()) {
            n = string.charAt(n3);
            switch (n) {
                case 60: 
                case 62: {
                    n2 += 4;
                    bl = true;
                    break;
                }
                case 38: {
                    n2 += 5;
                    bl = true;
                    break;
                }
                case 34: {
                    n2 += 6;
                    bl = true;
                    break;
                }
                case 39: {
                    n2 += 5;
                    bl = true;
                    break;
                }
                default: {
                    ++n2;
                }
            }
            ++n3;
        }
        if (!bl) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n2);
        n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    break;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    break;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    break;
                }
                case '\'': {
                    stringBuffer.append("&#39;");
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    static boolean containsBrTag(String string) {
        return REGEXP_BR.matcher(string).find();
    }

    public static String escapeHtmlExceptBrTags(String string) {
        if (StringCheck.isStringBlank(string) || !StringEscape.containsBrTag(string)) {
            return StringEscape.escapeHtml(string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = REGEXP_BR.matcher(string);
        int n = 0;
        while (matcher.find()) {
            int n2 = matcher.start();
            stringBuffer.append(StringEscape.escapeHtml(string.substring(n, n2)));
            stringBuffer.append(matcher.group());
            n = matcher.end();
        }
        if (n < string.length()) {
            stringBuffer.append(StringEscape.escapeHtml(string.substring(n)));
        }
        return stringBuffer.toString();
    }

    public static String getSafeXml(String string) {
        String string2 = StringEscape.searchAndReplaceString(string, "&", "&amp;");
        string2 = StringEscape.searchAndReplaceString(string2, ">", "&gt;");
        string2 = StringEscape.searchAndReplaceString(string2, "[\\000-\\010\\013\\014\\016-\\037]", "");
        return StringEscape.searchAndReplaceString(string2, "<", "&lt;");
    }

    public static Hashtable checkCharsForDatabaseInsert(Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = ((String)hashtable.get(string)).replace('\'', '_').replace(',', '^').replace('%', ' ');
            string2 = string2.toUpperCase();
            hashtable.put(string, string2);
        }
        return hashtable;
    }

    public static String getSectionNameForDatabase(String string) {
        String string2 = string.toUpperCase();
        return "DATABASE_" + StringEscape.searchAndReplaceString(string2, "_", "");
    }

    public static String escapeCharacters(String string, String string2, char c) {
        if (string2.indexOf(c) == -1) {
            throw new IllegalArgumentException("charsToEscape must include escape character.");
        }
        return StringEscape.escapeCharacters(string, string2, "" + c);
    }

    public static String unescapeCharacters(String string, String string2, char c) {
        if (string2.indexOf(c) == -1) {
            throw new IllegalArgumentException("charsToUnescape must include escape character.");
        }
        String string3 = StringEscape.escapeRegex(string2);
        String string4 = StringEscape.escapeRegex("" + c);
        if (string.matches("[^" + string4 + "][" + string3 + ']')) {
            throw new IllegalArgumentException("One of: " + string2 + " exists in " + string + " unescaped.");
        }
        return string.replaceAll(string4 + "([" + string3 + "])", "$1");
    }

    public static String escapeRegex(String string) {
        return string.replaceAll("(\\W)", "\\\\$1");
    }

    public static String createEscapedSeparatedString(String[] stringArray, char c, char c2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            String string = StringEscape.escapeCharacters(stringArray[n], "" + c2 + c, c2);
            stringBuffer.append(string);
            if (n != stringArray.length - 1) {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String[] splitAndUnescapeString(String string, char c, char c2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        char[] cArray = string.toCharArray();
        char c3 = '\u0000';
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < cArray.length) {
            char c4 = cArray[n];
            char c5 = '\u0000';
            if (n + 1 < cArray.length) {
                c5 = c3 = cArray[n + 1];
            }
            if (c4 == c2) {
                if (c3 == c) {
                    stringBuffer.append(c);
                    ++n;
                } else if (c3 == c2) {
                    stringBuffer.append(c2);
                    ++n;
                }
            } else if (c4 == c) {
                arrayList.add(stringBuffer.toString());
                stringBuffer.setLength(0);
            } else {
                stringBuffer.append(c4);
            }
            ++n;
        }
        arrayList.add(stringBuffer.toString());
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private StringEscape() {
    }
}

