/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.systemutilities.lib;

import RuntimeTool.Debug;
import RuntimeTool.DebugManager;
import StringUtilities.StringEncoder;
import com.intelerad.lib.process.CommandLauncher;
import java.io.File;
import javax.swing.JFrame;

public class SystemUtilities {
    public static final String JNI_LIBNAME = "intelerad.jni.libname";
    public static final String DEFAULT_LIBNAME = "SystemUtilitiesJNI";
    private static boolean mAlreadyInitialized;

    public static synchronized void initialize() {
        if (mAlreadyInitialized) {
            return;
        }
        String string = System.getProperty(JNI_LIBNAME);
        if (string == null) {
            string = DEFAULT_LIBNAME;
        }
        System.loadLibrary(string);
        mAlreadyInitialized = true;
    }

    public static boolean isWindows() {
        String string = System.getProperty("os.name");
        boolean bl = false;
        if (string != null && string.toUpperCase().startsWith("WINDOWS")) {
            bl = true;
        }
        return bl;
    }

    public static native long getFreeDiskSpace(String var0);

    public static native long getTotalDiskSpace(String var0);

    public static native long getVirtualMemoryAvailable();

    public static native long getClusterSize(String var0);

    public static native boolean isAdmin();

    public static native String getSystemDrive();

    public static double getDiskUsageFraction(String string) {
        long l = SystemUtilities.getTotalDiskSpace(string);
        if (l <= 0L) {
            return 1.0;
        }
        return 1.0 - (double)SystemUtilities.getFreeDiskSpace(string) / (double)l;
    }

    public static boolean grantFullAccess(File file) {
        if (!file.exists()) {
            return false;
        }
        String[] stringArray = SystemUtilities.isWindows() ? new String[]{"cacls", file.getAbsolutePath(), "/T", "/E", "/G", "Everyone:F"} : new String[]{"chmod", "-R", "777", file.getAbsolutePath()};
        CommandLauncher commandLauncher = new CommandLauncher("GrantFullAccess", stringArray);
        try {
            boolean bl = false;
            if (commandLauncher.launch(null, DebugManager.getDefault()).waitFor() == 0) {
                bl = true;
            }
            return bl;
        }
        catch (Exception exception) {
            DebugManager.getDefault().printException("Failed to grant full access using: " + commandLauncher, exception);
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    public static void moveToFront(JFrame var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 70->74)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static final native long attachForegroundWindowThread();

    private static final native boolean detachThread(long var0);

    public static void logSystemInformation(Debug debug) {
        debug.printTrace(System.getProperty("os.name") + " OS, version " + System.getProperty("os.version") + ", " + System.getProperty("os.arch") + " arch");
        debug.printTrace("Java version " + System.getProperty("java.version") + ", from " + System.getProperty("java.home"));
        debug.printTrace("OS username " + System.getProperty("user.name") + ", with user home directory at " + System.getProperty("user.home"));
        debug.printTrace("Default string encoding is " + StringEncoder.getDefaultStringEncoding());
    }

    public static void disableDirectDraw() {
        System.setProperty("sun.java2d.noddraw", "true");
    }

    static {
        try {
            SystemUtilities.initialize();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            DebugManager.getDefault().printDebug("Failed to load JNI, native methods will fail.");
        }
        mAlreadyInitialized = false;
    }
}

