/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.tools.lib.concurrent;

import com.intelerad.tools.lib.concurrent.AsynchronousCallable;
import com.intelerad.tools.lib.concurrent.BasicTaskController;
import com.intelerad.tools.lib.concurrent.CallListener;
import com.intelerad.tools.lib.concurrent.Callable;
import com.intelerad.tools.lib.concurrent.Cancellable;
import com.intelerad.tools.lib.concurrent.Executor;
import com.intelerad.tools.lib.concurrent.Invoker;
import com.intelerad.tools.lib.concurrent.SimpleThreadPool;
import com.intelerad.tools.lib.concurrent.TaskController;

public class CallableUtilities {
    private static SimpleThreadPool mSimpleThreadPool;

    public static synchronized Executor getDefaultThreadCache() {
        if (mSimpleThreadPool == null) {
            mSimpleThreadPool = new SimpleThreadPool(5);
        }
        return mSimpleThreadPool;
    }

    public static TaskController execute(Callable callable, CallListener callListener, Invoker invoker) {
        return CallableUtilities.execute(callable, callListener, invoker, CallableUtilities.getDefaultThreadCache());
    }

    public static TaskController execute(Callable callable, CallListener callListener, Invoker invoker, Executor executor) {
        CallableRunner callableRunner = new CallableRunner(callable, callListener, invoker);
        executor.execute(callableRunner);
        return callableRunner.getTaskController();
    }

    public static AsynchronousCallable buildAsynchronousCallable(Callable callable, Invoker invoker) {
        return new AsynchronousCallable(callable, invoker){
            final /* synthetic */ Callable val$callable;
            final /* synthetic */ Invoker val$invoker;

            public final TaskController call(CallListener callListener) {
                return CallableUtilities.execute(this.val$callable, callListener, this.val$invoker);
            }
            {
                this.val$callable = callable;
                this.val$invoker = invoker;
            }
        };
    }

    private CallableUtilities() {
    }

    private static class CallableRunner
    implements Runnable {
        private Callable mCallable;
        private BasicTaskController mBasicTaskController;

        public void run() {
            try {
                this.mBasicTaskController.setResult(this.mCallable.call());
            }
            catch (Throwable throwable) {
                this.mBasicTaskController.setException(throwable);
            }
        }

        public TaskController getTaskController() {
            return this.mBasicTaskController;
        }

        static /* synthetic */ Callable access$0(CallableRunner callableRunner) {
            return callableRunner.mCallable;
        }

        private CallableRunner(Callable callable, CallListener callListener, Invoker invoker) {
            this.mCallable = callable;
            Cancellable cancellable = new Cancellable(this){
                final /* synthetic */ CallableRunner this$0;

                public final void cancel() {
                    if (CallableRunner.access$0(this.this$0) instanceof Cancellable) {
                        ((Cancellable)((Object)CallableRunner.access$0(this.this$0))).cancel();
                    }
                }
                {
                    this.this$0 = callableRunner;
                }
            };
            this.mBasicTaskController = new BasicTaskController(cancellable, callListener, invoker);
        }
    }
}

