/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.tools.lib.concurrent;

import com.intelerad.tools.lib.concurrent.Callable;

public final class FunctionResult
implements Callable {
    private final Object mResult;
    private final Throwable mException;

    public static final FunctionResult saveFunctionResult(Callable callable) {
        try {
            return new FunctionResult(callable.call(), null);
        }
        catch (Throwable throwable) {
            return new FunctionResult(null, throwable);
        }
    }

    public static final FunctionResult createResult(Object object) {
        return new FunctionResult(object, null);
    }

    public static final FunctionResult createException(Throwable throwable) {
        return new FunctionResult(null, throwable);
    }

    public final boolean isException() {
        boolean bl = false;
        if (this.mException != null) {
            bl = true;
        }
        return bl;
    }

    public final Object getResult() {
        return this.mResult;
    }

    public final Throwable getException() {
        return this.mException;
    }

    public final Object call() throws Exception {
        if (this.mException != null) {
            if (this.mException instanceof Error) {
                throw (Error)this.mException;
            }
            if (this.mException instanceof Exception) {
                throw (Exception)this.mException;
            }
            throw new IllegalStateException("Function result was a sub-class of Throwable that was not Exception or Error!");
        }
        return this.mResult;
    }

    private FunctionResult(Object object, Throwable throwable) {
        if (object != null && throwable != null) {
            throw new IllegalArgumentException("It's not possible to result a result and exception at the same time.");
        }
        if (throwable != null && !(throwable instanceof Exception) && !(throwable instanceof Error)) {
            throw new IllegalArgumentException("Exception must be an instance of Error or Exception.");
        }
        this.mException = throwable;
        this.mResult = object;
    }
}

