/*
 * Decompiled with CFR 0.152.
 */
package DataModels;

import DataModels.ModelProperty;
import DataModels.ObservableDataModel;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractDataModel
extends ObservableDataModel {
    public abstract Collection getProperties();

    public void setProperty(ModelProperty modelProperty, Object object) {
        this.validateProperty(modelProperty);
        try {
            Object object2 = this.getProperty(modelProperty);
            Method method = this.findSetMethod("set" + modelProperty.getName(), modelProperty.getValueClass());
            method.invoke((Object)this, object);
            this.firePropertyChange(modelProperty, object2);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw this.createIllegalArgumentException("Cannot find setter for property " + modelProperty.getName(), noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw this.createIllegalArgumentException("Cannot access setter for property " + modelProperty.getName(), illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw this.createIllegalArgumentException("Cannot invoke setter for property " + modelProperty.getName(), invocationTargetException);
        }
        catch (Exception exception) {
            throw this.createIllegalArgumentException("Unexpected exception invoking setter for property " + modelProperty.getName(), exception);
        }
    }

    public Object getProperty(ModelProperty modelProperty) {
        return this.getProperty(modelProperty, "get");
    }

    private Object getProperty(ModelProperty modelProperty, String string) {
        this.validateProperty(modelProperty);
        try {
            Method method = this.getClass().getMethod(string + modelProperty.getName(), null);
            return method.invoke((Object)this, null);
        }
        catch (SecurityException securityException) {
            throw this.createIllegalArgumentException("Security violation invoking the getter for property " + modelProperty.getName(), securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (string.equals("get") && modelProperty.getValueClass() == Boolean.class) {
                return this.getProperty(modelProperty, "is");
            }
            throw this.createIllegalArgumentException("Cannot find getter for property " + modelProperty.getName(), noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw this.createIllegalArgumentException("Cannot access getter for property " + modelProperty.getName(), illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw this.createIllegalArgumentException("Cannot invoke getter for property " + modelProperty.getName(), invocationTargetException);
        }
        catch (Exception exception) {
            throw this.createIllegalArgumentException("Unexpected exception invoking getter for property " + modelProperty.getName(), exception);
        }
    }

    private void validateProperty(ModelProperty modelProperty) {
        if (!this.getProperties().contains(modelProperty)) {
            throw new IllegalArgumentException("Property is not valid: " + modelProperty);
        }
    }

    private Method findSetMethod(String string, Class clazz) throws NoSuchMethodException {
        try {
            return this.getClass().getMethod(string, clazz);
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (clazz == Boolean.class) {
                return this.findSetMethod(string, Boolean.TYPE);
            }
            if (clazz == Byte.class) {
                return this.findSetMethod(string, Byte.TYPE);
            }
            if (clazz == Character.class) {
                return this.findSetMethod(string, Character.TYPE);
            }
            if (clazz == Double.class) {
                return this.findSetMethod(string, Double.TYPE);
            }
            if (clazz == Float.class) {
                return this.findSetMethod(string, Float.TYPE);
            }
            if (clazz == Integer.class) {
                return this.findSetMethod(string, Integer.TYPE);
            }
            if (clazz == Long.class) {
                return this.findSetMethod(string, Long.TYPE);
            }
            if (clazz == Short.class) {
                return this.findSetMethod(string, Short.TYPE);
            }
            if (clazz == List.class) {
                return this.findSetMethod(string, Collection.class);
            }
            throw noSuchMethodException;
        }
    }

    private IllegalArgumentException createIllegalArgumentException(String string, Throwable throwable) {
        IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
        illegalArgumentException.initCause(throwable);
        return illegalArgumentException;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("-- ");
        stringBuffer.append(super.toString());
        stringBuffer.append("-------------------------------------------------------------------------------".substring(super.toString().length() + 3));
        stringBuffer.append("\n");
        Iterator iterator = this.getProperties().iterator();
        while (iterator.hasNext()) {
            ModelProperty modelProperty = (ModelProperty)iterator.next();
            stringBuffer.append(modelProperty.getName());
            stringBuffer.append(": [");
            stringBuffer.append(this.getProperty(modelProperty));
            stringBuffer.append("]\n");
        }
        stringBuffer.append("-------------------------------------------------------------------------------");
        return stringBuffer.toString();
    }
}

