/*
 * Decompiled with CFR 0.152.
 */
package DataModels;

import DataModels.DataModel;
import DataModels.ModelProperty;
import DataModels.ObservableDataModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class CompositeDataModel
extends ObservableDataModel {
    private final DataModel mPrimaryDataModel;
    private final DataModel mSecondaryDataModel;
    private List mObservedProperties;

    public CompositeDataModel(DataModel dataModel, DataModel dataModel2) {
        this.mPrimaryDataModel = dataModel;
        this.mSecondaryDataModel = dataModel2;
    }

    public void setProperty(ModelProperty modelProperty, Object object) throws IllegalArgumentException {
        throw new UnsupportedOperationException("Composite model is read-only: " + this.toString());
    }

    public Object getProperty(ModelProperty modelProperty) throws IllegalArgumentException {
        Object object = this.mPrimaryDataModel.getProperty(modelProperty);
        if (object != null) {
            return object;
        }
        return this.mSecondaryDataModel.getProperty(modelProperty);
    }

    public Collection getProperties() {
        HashSet hashSet = new HashSet(this.mPrimaryDataModel.getProperties());
        hashSet.addAll(this.mSecondaryDataModel.getProperties());
        return hashSet;
    }

    public void addPropertyChangeListener(ModelProperty modelProperty, PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(modelProperty, propertyChangeListener);
        this.listenToDataModels(modelProperty, propertyChangeListener);
    }

    public void addWeakPropertyChangeListener(ModelProperty modelProperty, PropertyChangeListener propertyChangeListener) {
        super.addWeakPropertyChangeListener(modelProperty, propertyChangeListener);
        this.listenToDataModels(modelProperty, propertyChangeListener);
    }

    private void listenToDataModels(ModelProperty modelProperty, PropertyChangeListener propertyChangeListener) {
        this.mObservedProperties = new ArrayList();
        if (this.mObservedProperties.contains(modelProperty)) {
            return;
        }
        this.mObservedProperties.add(modelProperty);
        this.mPrimaryDataModel.addPropertyChangeListener(modelProperty, new PrimaryChangeListener());
        this.mSecondaryDataModel.addPropertyChangeListener(modelProperty, new SecondaryChangeListener());
    }

    private class SecondaryChangeListener
    implements PropertyChangeListener {
        private SecondaryChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ModelProperty modelProperty = CompositeDataModel.this.findProperty(propertyChangeEvent.getPropertyName());
            if (CompositeDataModel.this.mPrimaryDataModel.getProperty(modelProperty) == null) {
                CompositeDataModel.this.firePropertyChange(modelProperty, propertyChangeEvent.getOldValue());
            }
        }
    }

    private class PrimaryChangeListener
    implements PropertyChangeListener {
        private PrimaryChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ModelProperty modelProperty = CompositeDataModel.this.findProperty(propertyChangeEvent.getPropertyName());
            CompositeDataModel.this.firePropertyChange(modelProperty, propertyChangeEvent.getOldValue());
        }
    }
}

