/*
 * Decompiled with CFR 0.152.
 */
package DataModels;

import DataModels.AdvancedPropertyChangeSupport;
import DataModels.DataModel;
import DataModels.ModelProperty;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class ObservableDataModel
implements DataModel {
    private final AdvancedPropertyChangeSupport mPropertyChangeSupport;
    protected final Map mPropertyMap = new HashMap();

    public ObservableDataModel() {
        this.mPropertyChangeSupport = new AdvancedPropertyChangeSupport(this);
    }

    public void firePropertyChange(ModelProperty modelProperty, Object object) {
        this.mPropertyChangeSupport.firePropertyChange(modelProperty.getName(), object, this.getProperty(modelProperty));
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.mPropertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(ModelProperty modelProperty, PropertyChangeListener propertyChangeListener) {
        ObservableDataModel.validateProperty(this, modelProperty);
        this.mPropertyChangeSupport.addPropertyChangeListener(modelProperty.getName(), propertyChangeListener);
    }

    public void addWeakPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.mPropertyChangeSupport.addWeakPropertyChangeListener(propertyChangeListener);
    }

    public void addWeakPropertyChangeListener(ModelProperty modelProperty, PropertyChangeListener propertyChangeListener) {
        ObservableDataModel.validateProperty(this, modelProperty);
        this.mPropertyChangeSupport.addWeakPropertyChangeListener(modelProperty.getName(), propertyChangeListener);
    }

    public void removePropertyChangeListener(ModelProperty modelProperty, PropertyChangeListener propertyChangeListener) {
        ObservableDataModel.validateProperty(this, modelProperty);
        this.mPropertyChangeSupport.removePropertyChangeListener(modelProperty.getName(), propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.mPropertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    protected static void validateProperty(DataModel dataModel, ModelProperty modelProperty) throws IllegalArgumentException {
        if (!dataModel.getProperties().contains(modelProperty)) {
            throw new IllegalArgumentException("Property '" + modelProperty + "' is not a property of " + dataModel.getClass());
        }
    }

    protected ModelProperty findProperty(String string) {
        ModelProperty modelProperty;
        if (this.mPropertyMap.isEmpty()) {
            this.mPropertyMap.putAll(this.createPropertyMap(this.getProperties()));
        }
        if ((modelProperty = (ModelProperty)this.mPropertyMap.get(string)) == null) {
            throw new IllegalArgumentException("Invalid property '" + modelProperty + "'");
        }
        return modelProperty;
    }

    private Map createPropertyMap(Collection collection) {
        HashMap<String, ModelProperty> hashMap = new HashMap<String, ModelProperty>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ModelProperty modelProperty = (ModelProperty)iterator.next();
            hashMap.put(modelProperty.getName(), modelProperty);
        }
        return hashMap;
    }
}

