/*
 * Decompiled with CFR 0.152.
 */
package DataModels.SearchFramework;

import DataModels.SearchFramework.OperandLookup;
import DataModels.SearchFramework.Term;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Clause {
    private final List mTermList = new ArrayList();

    public Clause() {
    }

    public Clause(Clause clause) {
        Iterator iterator = clause.termIterator();
        while (iterator.hasNext()) {
            this.addTerm((Term)iterator.next());
        }
    }

    public Clause(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.addTerm((Term)iterator.next());
        }
    }

    public Clause(Term term) {
        this.addTerm(term);
    }

    public void addTerm(Term term) {
        this.mTermList.add(new Term(term));
    }

    public Iterator termIterator() {
        return this.mTermList.iterator();
    }

    public int getNumberOfTerms() {
        return this.mTermList.size();
    }

    public Term getTerm(int n2) {
        return (Term)this.mTermList.get(n2);
    }

    public List getTermList() {
        return Collections.unmodifiableList(this.mTermList);
    }

    public boolean isSatisfied(OperandLookup operandLookup) {
        Iterator iterator = this.termIterator();
        while (iterator.hasNext()) {
            Term term = (Term)iterator.next();
            if (term.isSatisfied(operandLookup)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append(" terms:\n");
        Iterator iterator = this.mTermList.iterator();
        while (iterator.hasNext()) {
            Term term = (Term)iterator.next();
            stringBuffer.append(term.toString());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }
}

