/*
 * Decompiled with CFR 0.152.
 */
package DataModels.SearchFramework;

import DataModels.ModelProperty;
import StringUtilities.StringCheck;

public class SearchModelProperty
extends ModelProperty {
    private final String mType;

    public SearchModelProperty(String string, String string2, String string3) {
        super(null, string, string3);
        this.mType = string2;
    }

    public String getType() {
        return this.mType;
    }

    public Class getValueClass() {
        try {
            return Class.forName(this.mType);
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string = "Unknown search attribute type " + this.mType + ". This can only happen if the SearchModelProperty returned by the " + "server was not validated!";
            IllegalStateException illegalStateException = new IllegalStateException(string);
            illegalStateException.initCause(classNotFoundException);
            throw illegalStateException;
        }
    }

    public int hashCode() {
        return ("" + this.getName() + this.getDescription() + this.getType()).hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof SearchModelProperty)) {
            return false;
        }
        SearchModelProperty searchModelProperty = (SearchModelProperty)object;
        return StringCheck.stringsEqual(this.getName(), searchModelProperty.getName()) && StringCheck.stringsEqual(this.getDescription(), searchModelProperty.getDescription()) && StringCheck.stringsEqual(this.getType(), searchModelProperty.getType());
    }
}

