/*
 * Decompiled with CFR 0.152.
 */
package DataModels.SearchFramework;

import DataModels.SearchFramework.OperandLookup;
import DataModels.SearchFramework.Operator;
import RuntimeTool.DebugManager;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Term {
    private final String mAttribute;
    private final Operator mOperator;
    private final String mValue;
    private static final DateFormat DATE_FORMATTER = new SimpleDateFormat("yyyyMMdd'T'HHmmss.SSSZ");

    public Term(String string, Operator operator, String string2) {
        this.mAttribute = string;
        this.mOperator = operator;
        this.mValue = string2;
    }

    public Term(String string, Operator operator, Date date) {
        this(string, operator, Term.getValueFromDate(date));
    }

    public Term(Term term) {
        this(term.getAttribute(), term.getOperator(), term.getValue());
    }

    public String getAttribute() {
        return this.mAttribute;
    }

    public Operator getOperator() {
        return this.mOperator;
    }

    public String getValue() {
        return this.mValue;
    }

    public Date getValueAsDate() {
        DateFormat dateFormat = DATE_FORMATTER;
        synchronized (dateFormat) {
            try {
                return DATE_FORMATTER.parse(this.mValue);
            }
            catch (ParseException parseException) {
                throw new RuntimeException(parseException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getValueFromDate(Date date) {
        DateFormat dateFormat = DATE_FORMATTER;
        synchronized (dateFormat) {
            return DATE_FORMATTER.format(date);
        }
    }

    public boolean isSatisfied(OperandLookup operandLookup) {
        String string = operandLookup.lookupAttribute(this.mAttribute);
        String string2 = operandLookup.lookupValue(this.mValue);
        DebugManager.getDefault().printTrace("Evaluating " + this.toString(string, string2));
        if (string == null || this.mOperator == null || string2 == null) {
            return false;
        }
        return this.mOperator.isTrue(string, string2);
    }

    private String toString(String string, String string2) {
        return "Term <" + string + "> " + this.getOperator() + " <" + string2 + ">";
    }

    public String toString() {
        return this.toString(this.getAttribute(), this.getValue());
    }

    public boolean equals(Object object) {
        boolean bl2;
        if (!(object instanceof Term)) {
            return false;
        }
        Term term = (Term)object;
        boolean bl3 = this.mAttribute == null ? term.mAttribute == null : this.mAttribute.equals(term.mAttribute);
        boolean bl4 = bl2 = this.mOperator == term.mOperator;
        boolean bl5 = this.mValue == null ? term.mValue == null : this.mValue.equals(term.mValue);
        return bl3 && bl2 && bl5;
    }

    public int hashCode() {
        int n2 = 17;
        if (this.mAttribute != null) {
            n2 = 37 * n2 + this.mAttribute.hashCode();
        }
        if (this.mOperator != null) {
            n2 = 37 * n2 + this.mOperator.hashCode();
        }
        if (this.mValue != null) {
            n2 = 37 * n2 + this.mValue.hashCode();
        }
        return n2;
    }
}

