/*
 * Decompiled with CFR 0.152.
 */
package DataModels.UserModels;

import Security.Crypt;
import StringUtilities.StringConverter;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;

public class Password {
    static Comparator COMPARATOR = new PasswordComparator();
    private static final SecureRandom RANDOM_SOURCE = new SecureRandom();
    private Date mCreateDate;
    private int mLifetime;
    private String mPasswordHash;
    private String mPasswordSalt;
    private String mPasswordDES;

    public Password(Date date, int n2, String string, String string2, String string3) {
        if (string != null) {
            StringConverter.unhexString(string);
        }
        if (string2 != null) {
            StringConverter.unhexString(string2);
        }
        this.mCreateDate = date;
        this.mLifetime = n2;
        this.mPasswordHash = string;
        this.mPasswordSalt = string2;
        this.mPasswordDES = string3;
    }

    Password(String string, String string2, int n2) {
        this(string, string2, Password.generatePasswordSalt(), n2);
    }

    Password(String string, String string2, String string3, int n2) {
        this(new Date(), n2, null, string3, null);
        if (string2 != null) {
            this.mPasswordHash = this.hashPassword(string2);
        }
        this.mPasswordDES = this.computeDES(string, string2);
    }

    public Date getCreateDate() {
        return this.mCreateDate;
    }

    public void setCreateDate(Date date) {
        this.mCreateDate = date;
    }

    public int getLifetime() {
        return this.mLifetime;
    }

    public void setLifetime(int n2) {
        this.mLifetime = n2;
    }

    public String getPasswordHash() {
        return this.mPasswordHash;
    }

    public String getPasswordSalt() {
        return this.mPasswordSalt;
    }

    public String getPasswordDES() {
        return this.mPasswordDES;
    }

    public boolean passwordMatches(String string, String string2) {
        if (this.mPasswordHash != null) {
            return this.mPasswordHash.equals(this.hashPassword(string2));
        }
        if (this.mPasswordDES != null) {
            return this.mPasswordDES.equals(this.computeDES(string, string2));
        }
        return false;
    }

    public Date getExpiryDate() {
        if (this.mLifetime < 0) {
            return null;
        }
        Calendar calendar = new GregorianCalendar();
        calendar.setTime(this.mCreateDate);
        calendar.add(5, this.mLifetime);
        calendar = Password.resetCalendarTime(calendar);
        return calendar.getTime();
    }

    public boolean isExpired() {
        Date date = this.getExpiryDate();
        if (date == null) {
            return false;
        }
        Date date2 = new Date();
        return date2.after(date);
    }

    private String hashPassword(String string) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("SHA-1");
            messageDigest.update(string.getBytes("UTF-8"));
            if (this.mPasswordSalt != null) {
                messageDigest.update(StringConverter.unhexString(this.mPasswordSalt));
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        return StringConverter.hexString(messageDigest.digest());
    }

    static String generatePasswordSalt() {
        byte[] byArray = new byte[8];
        RANDOM_SOURCE.nextBytes(byArray);
        return StringConverter.hexString(byArray);
    }

    private String computeDES(String string, String string2) {
        return Crypt.crypt(string, string2);
    }

    public static Calendar resetCalendarTime(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    private static class PasswordComparator
    implements Comparator {
        private PasswordComparator() {
        }

        public int compare(Object object, Object object2) {
            Password password = (Password)object;
            Password password2 = (Password)object2;
            if (password == null && password2 == null) {
                return 0;
            }
            if (password == null) {
                return -1;
            }
            if (password2 == null) {
                return 1;
            }
            return -password.mCreateDate.compareTo(password2.mCreateDate);
        }
    }
}

