/*
 * Decompiled with CFR 0.152.
 */
package DataStructures;

import RuntimeTool.DebugManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class DelayWorkQueue {
    private LinkedList mQueue = new LinkedList();
    private int mCapacity;

    public DelayWorkQueue() {
        this(Integer.MAX_VALUE);
    }

    public DelayWorkQueue(int n2) {
        this.mCapacity = n2;
    }

    public synchronized boolean isEmpty() {
        return this.mQueue.isEmpty();
    }

    public synchronized void addWork(Object object) {
        this.addWork(object, 0L);
    }

    public synchronized void addWork(Object object, long l2) {
        this.insertSorted(new DelayWork(object, l2 + System.currentTimeMillis()));
        this.trimQueue();
        this.notifyAll();
    }

    private void trimQueue() {
        while (this.mQueue.size() > this.mCapacity) {
            DelayWork delayWork = (DelayWork)this.mQueue.removeLast();
            DebugManager.getDefault().printTrace("DelayWorkQueue reached capacity " + this.mCapacity + ".  Dropping: " + delayWork.getPayload());
        }
    }

    private synchronized void insertSorted(DelayWork delayWork) {
        ListIterator<DelayWork> listIterator = this.mQueue.listIterator();
        while (listIterator.hasNext()) {
            DelayWork delayWork2 = (DelayWork)listIterator.next();
            if (delayWork.mProcessTime >= delayWork2.mProcessTime) continue;
            listIterator.previous();
            break;
        }
        listIterator.add(delayWork);
    }

    public synchronized Object getWorkInterruptible() throws InterruptedException {
        while (true) {
            if (this.mQueue.isEmpty()) {
                this.wait();
                continue;
            }
            DelayWork delayWork = (DelayWork)this.mQueue.get(0);
            long l2 = delayWork.mProcessTime - System.currentTimeMillis();
            if (l2 <= 0L) {
                this.mQueue.removeFirst();
                return delayWork.getPayload();
            }
            this.wait(l2);
        }
    }

    public synchronized Object getWork() {
        while (true) {
            try {
                return this.getWorkInterruptible();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public synchronized List getAllItems() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = this.mQueue.iterator();
        while (iterator.hasNext()) {
            DelayWork delayWork = (DelayWork)iterator.next();
            arrayList.add(delayWork.getPayload());
        }
        return arrayList;
    }

    private static class DelayWork {
        private final Object mPayload;
        private final long mProcessTime;

        public DelayWork(Object object, long l2) {
            this.mPayload = object;
            this.mProcessTime = l2;
        }

        public Object getPayload() {
            return this.mPayload;
        }

        public long getProcessTime() {
            return this.mProcessTime;
        }

        public String toString() {
            return this.getClass().getName() + " " + this.mProcessTime + ": " + this.mPayload;
        }
    }
}

