/*
 * Decompiled with CFR 0.152.
 */
package DataStructures;

import DataStructures.WorkQueueSelectStrategy;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class WorkQueue {
    public static final Object SHUTDOWN_CONSUMER = new Object();
    private LinkedList mQueue = new LinkedList();
    private int mCapacity = Integer.MAX_VALUE;
    private boolean mClosed = false;
    private WorkQueueSelectStrategy mSelectStrategy = new DefaultSelectStragegy();

    public WorkQueue() {
    }

    public WorkQueue(int n2) {
        this.mCapacity = n2;
    }

    public WorkQueue(WorkQueueSelectStrategy workQueueSelectStrategy) {
        this.mSelectStrategy = workQueueSelectStrategy;
    }

    public synchronized boolean isEmpty() {
        return this.mQueue.isEmpty();
    }

    public synchronized void close() {
        this.mClosed = true;
        this.notifyAll();
    }

    public synchronized boolean addWork(Object object) {
        if (this.mClosed || this.mQueue.size() >= this.mCapacity) {
            return false;
        }
        this.mQueue.addLast(object);
        this.notifyAll();
        return true;
    }

    public synchronized Object getWorkInterruptible() throws InterruptedException {
        while (!this.mClosed && this.mQueue.isEmpty()) {
            this.wait();
        }
        if (this.mClosed && this.mQueue.isEmpty()) {
            return SHUTDOWN_CONSUMER;
        }
        return this.mQueue.remove(this.mSelectStrategy.getWorkIndex(Collections.unmodifiableList(this.mQueue)));
    }

    public synchronized Object getWork() {
        while (true) {
            try {
                return this.getWorkInterruptible();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private static class DefaultSelectStragegy
    implements WorkQueueSelectStrategy {
        private DefaultSelectStragegy() {
        }

        public int getWorkIndex(List list) {
            return 0;
        }
    }
}

