/*
 * Decompiled with CFR 0.152.
 */
package FileUtilities;

import DateUtilities.DateUtilities;
import FileUtilities.ListFiles;
import RuntimeTool.DebugManager;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class FileOperations {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static Random mRandom = new Random();
    private static Object mRandomLock = new Object();

    public static File getSystemTempDir() {
        return new File(System.getProperty("java.io.tmpdir"));
    }

    public static long copy(InputStream inputStream, OutputStream outputStream, byte[] byArray) throws IOException {
        long l2 = 0L;
        int n2 = -1;
        while ((n2 = inputStream.read(byArray, 0, byArray.length)) != -1) {
            outputStream.write(byArray, 0, n2);
            l2 += (long)n2;
        }
        return l2;
    }

    public static long copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        return FileOperations.copy(inputStream, outputStream, new byte[20480]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File file, File file2) throws IOException {
        FileOutputStream fileOutputStream;
        block9: {
            FileInputStream fileInputStream = null;
            fileOutputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                fileOutputStream = new FileOutputStream(file2);
                long l2 = fileOutputStream.getChannel().transferFrom(fileInputStream.getChannel(), 0L, file.length());
                if (l2 != file.length()) {
                    throw new IOException("Short write: " + l2 + " out of " + file.length() + " bytes written to disk");
                }
                Object var7_5 = null;
                if (fileInputStream == null) break block9;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                throw throwable;
            }
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (fileOutputStream != null) {
            fileOutputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFile(File file) throws FileNotFoundException, IOException {
        int n2 = (int)file.length();
        byte[] byArray = new byte[n2];
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            fileInputStream.read(byArray);
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        return byArray;
    }

    public static boolean moveFile(File file, File file2) throws FileNotFoundException, IOException {
        if (!file.renameTo(file2)) {
            FileOperations.copyFile(file, file2);
            return file.delete();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File createTempDir(File file, String string, String string2) throws IOException {
        File file2;
        if (!file.isDirectory()) {
            throw new IOException("Base directory " + file + " does not exist or is not a directory");
        }
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        Object object = mRandomLock;
        synchronized (object) {
            while ((file2 = new File(file, string + mRandom.nextInt() + string2)).exists()) {
            }
        }
        if (!file2.mkdir()) {
            throw new IOException("Cannot create temporary directory " + file2);
        }
        return file2;
    }

    public static boolean createDirectory(File file) {
        file.mkdirs();
        return file.isDirectory();
    }

    public static boolean createDirectory(String string) {
        return FileOperations.createDirectory(new File(string));
    }

    public static boolean removeDirectory(String string) {
        if (string == null) {
            return false;
        }
        return FileOperations.removeDirectory(new File(string));
    }

    public static boolean removeDirectory(File file) {
        return FileOperations.removeDirectory(file, null);
    }

    public static boolean removeDirectory(File file, FileFilter fileFilter) {
        if (!file.isDirectory()) {
            return false;
        }
        File[] fileArray = null;
        try {
            fileArray = file.listFiles();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (fileArray == null) {
            fileArray = new File[]{};
        }
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            File file2 = fileArray[i2];
            if (file2.isDirectory()) {
                FileOperations.removeDirectory(file2, fileFilter);
                continue;
            }
            try {
                if (fileFilter != null && !fileFilter.accept(file2)) continue;
                file2.delete();
                continue;
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
        }
        try {
            return file.delete();
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
            return false;
        }
    }

    public static boolean removeDirectoryContents(File file) {
        return FileOperations.removeDirectoryContents(file, null);
    }

    public static boolean removeDirectoryContents(File file, FileFilter fileFilter) {
        File[] fileArray = file.listFiles();
        if (fileArray == null || fileArray.length <= 0) {
            return true;
        }
        boolean bl2 = true;
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            File file2 = fileArray[i2];
            if (file2.isFile()) {
                if (fileFilter != null && !fileFilter.accept(file2) || file2.delete()) continue;
                bl2 = false;
                continue;
            }
            if (!file2.isDirectory()) continue;
            FileOperations.removeDirectoryContents(file2, fileFilter);
            if (file2.delete()) continue;
            bl2 = false;
        }
        return bl2;
    }

    public static int removeDirectories(File[] fileArray) {
        int n2 = 0;
        if (fileArray != null) {
            int n3 = fileArray.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                if (!FileOperations.removeDirectory(fileArray[i2])) continue;
                ++n2;
            }
        }
        return n2;
    }

    public static boolean exists(String string) {
        return new File(string).exists();
    }

    public static int performFileDeletion(Collection collection, FileFilter fileFilter) {
        int n2 = 0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            if (fileFilter != null && !fileFilter.accept(file) || !file.delete()) continue;
            iterator.remove();
            ++n2;
        }
        return n2;
    }

    public static int removeAllFilesOlderThanXminutes(String string, long l2, FileFilter fileFilter) {
        if (!string.startsWith("/")) {
            return -1;
        }
        Vector vector = FileOperations.getAllFilesOlderThanXminutes(string, l2);
        int n2 = FileOperations.performFileDeletion(vector, fileFilter);
        vector = null;
        return n2;
    }

    public static int removeAllFilesOlderThanXminutes(String string, long l2) {
        return FileOperations.removeAllFilesOlderThanXminutes(string, l2, null);
    }

    public static int removeAllDirsOlderThanXDays(String string, int n2) {
        return FileOperations.removeAllDirsOlderThanXDays(string, n2, null);
    }

    public static int removeAllDirsOlderThanXDays(String string, int n2, FileFilter fileFilter) {
        if (!string.startsWith("/")) {
            return -1;
        }
        File[] fileArray = FileOperations.getAllDirectoriesOlderThanXDays(string, n2, fileFilter);
        return FileOperations.removeDirectories(fileArray);
    }

    public static Vector getAllFilesOlderThanXminutes(String string, long l2) {
        List list = ListFiles.getAllFiles(new File(string));
        Vector<File> vector = new Vector<File>();
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            File file = (File)list.get(i2);
            if (!FileOperations.fileOlderThanXminutes(file, l2)) continue;
            vector.add(file);
        }
        list = null;
        return vector;
    }

    public static File[] getAllDirectoriesOlderThanXDays(String string, int n2, FileFilter fileFilter) {
        return new File(string).listFiles(new DateDirectoryFilter(n2, fileFilter));
    }

    public static boolean fileOlderThanXSeconds(File file, long l2) {
        if (!file.exists()) {
            return false;
        }
        Date date = new Date(file.lastModified());
        Date date2 = FileOperations.getThresholdDate(l2);
        return date2.after(date);
    }

    public static boolean fileOlderThanXminutes(File file, long l2) {
        return FileOperations.fileOlderThanXSeconds(file, 60L * l2);
    }

    private static Date getThresholdDate(long l2) {
        Calendar calendar = Calendar.getInstance();
        long l3 = calendar.getTime().getTime();
        long l4 = l3 - l2 * 1000L;
        return new Date(l4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void gunzip(String string, String string2) throws IOException {
        FileOutputStream fileOutputStream = null;
        GZIPInputStream gZIPInputStream = null;
        try {
            int n2;
            gZIPInputStream = new GZIPInputStream(new FileInputStream(string));
            fileOutputStream = new FileOutputStream(string2);
            byte[] byArray = new byte[2048];
            while ((n2 = gZIPInputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n2);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {
                if (gZIPInputStream != null) {
                    gZIPInputStream.close();
                }
                Object var9_10 = null;
                if (fileOutputStream == null) throw throwable;
            }
            catch (Throwable throwable2) {
                Object var9_11 = null;
                if (fileOutputStream == null) throw throwable2;
                try {
                    fileOutputStream.flush();
                    throw throwable2;
                }
                finally {
                    fileOutputStream.close();
                }
            }
            try {
                fileOutputStream.flush();
                throw throwable;
            }
            finally {
                fileOutputStream.close();
            }
        }
        try {
            if (gZIPInputStream != null) {
                gZIPInputStream.close();
            }
            Object var9_8 = null;
            if (fileOutputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (fileOutputStream == null) throw throwable;
            try {
                fileOutputStream.flush();
                throw throwable;
            }
            finally {
                fileOutputStream.close();
            }
        }
        try {
            fileOutputStream.flush();
            return;
        }
        finally {
            fileOutputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void gzip(String string, String string2) throws IOException {
        DeflaterOutputStream deflaterOutputStream;
        block6: {
            deflaterOutputStream = null;
            FileInputStream fileInputStream = null;
            try {
                int n2;
                fileInputStream = new FileInputStream(string);
                deflaterOutputStream = new GZIPOutputStream(new FileOutputStream(string2));
                byte[] byArray = new byte[2048];
                while ((n2 = fileInputStream.read(byArray)) != -1) {
                    ((GZIPOutputStream)deflaterOutputStream).write(byArray, 0, n2);
                }
                Object var7_6 = null;
                if (fileInputStream == null) break block6;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (deflaterOutputStream != null) {
                    deflaterOutputStream.flush();
                    ((GZIPOutputStream)deflaterOutputStream).finish();
                    deflaterOutputStream.close();
                }
                throw throwable;
            }
            fileInputStream.close();
        }
        if (deflaterOutputStream != null) {
            deflaterOutputStream.flush();
            ((GZIPOutputStream)deflaterOutputStream).finish();
            deflaterOutputStream.close();
        }
    }

    public static void copyDirectory(File file, File file2) throws IOException {
        FileOperations.copyDirectory(file, file2, null);
    }

    public static void copyDirectory(File file, File file2, FileFilter fileFilter) throws IOException {
        File[] fileArray = file.listFiles();
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            if (fileFilter != null && !fileFilter.accept(fileArray[i2])) continue;
            if (fileArray[i2].isFile()) {
                FileOperations.copyFile(fileArray[i2], new File(file2, fileArray[i2].getName()));
                continue;
            }
            if (!fileArray[i2].isDirectory()) continue;
            File file3 = new File(file2, fileArray[i2].getName());
            file3.mkdirs();
            FileOperations.copyDirectory(fileArray[i2], file3, fileFilter);
        }
    }

    public static boolean forceRename(File file, File file2) {
        if (!file2.delete() && file2.exists()) {
            DebugManager.getDefault().printWarning("forceRename failed to delete " + file2);
        }
        if (!file.renameTo(file2)) {
            DebugManager.getDefault().printWarning("Failed to rename " + file + " to " + file2);
            return false;
        }
        return true;
    }

    public static boolean atomicReplace(File file, File file2) {
        File file3 = null;
        try {
            file3 = File.createTempFile("atomicReplace", null, file2.getAbsoluteFile().getParentFile());
        }
        catch (IOException iOException) {
            DebugManager.getDefault().printException("Failed to create temp directory", iOException);
            return false;
        }
        if (FileOperations.forceRename(file2, file3)) {
            if (file.renameTo(file2)) {
                file3.delete();
                return true;
            }
            if (!file3.renameTo(file2)) {
                DebugManager.getDefault().printError("FileOperations.atomicReplace() of " + file2 + " failed, but we could not replace old version");
            }
        }
        return false;
    }

    public static boolean canWriteDirectory(File file) {
        return FileOperations.canWriteDirectory(file, true);
    }

    public static boolean canWriteDirectoryOSSpecific(File file) {
        if ("Linux".equals(System.getProperty("os.name"))) {
            return FileOperations.canWriteDirectory(file, true);
        }
        return FileOperations.canWriteDirectory(file, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean canWriteDirectory(File file, boolean bl2) {
        if (file == null) {
            return false;
        }
        boolean bl3 = true;
        if (bl2) {
            bl3 = file.canWrite();
        }
        if (!bl3 || !file.isDirectory()) {
            return false;
        }
        File file2 = null;
        try {
            file2 = File.createTempFile("temp", null, file);
            boolean bl4 = file2 != null;
            return bl4;
        }
        catch (IOException iOException) {
            boolean bl5 = false;
            return bl5;
        }
        finally {
            if (file2 != null) {
                file2.delete();
            }
        }
    }

    public static void writeStringToFile(String string, File file) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "ISO-8859-1"));
        bufferedWriter.write(string);
        ((Writer)bufferedWriter).close();
    }

    private static final class DateDirectoryFilter
    implements FileFilter {
        private String mLastDirectoryName;
        private FileFilter mCondition;

        public DateDirectoryFilter(int n2, FileFilter fileFilter) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.add(6, -n2);
            this.mLastDirectoryName = DateUtilities.getDicomDateString(gregorianCalendar.getTime());
            this.mCondition = fileFilter;
        }

        public boolean accept(File file) {
            boolean bl2;
            String string = file.getName();
            boolean bl3 = bl2 = file.isDirectory() && string.length() == 8;
            if (bl2) {
                try {
                    Integer.parseInt(string);
                    boolean bl4 = bl2 = string.compareTo(this.mLastDirectoryName) < 0;
                    if (bl2 && this.mCondition != null) {
                        bl2 = this.mCondition.accept(file);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    bl2 = false;
                }
            }
            return bl2;
        }
    }
}

