/*
 * Decompiled with CFR 0.152.
 */
package GuiUtilities.DataModels;

import DataModels.DataModel;
import DataModels.ModelProperty;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;

class ModelPropertyListModel
extends AbstractListModel
implements ComboBoxModel {
    private final DataModel mModel;
    private final ModelProperty mCollectionProperty;
    private final ListModelChangeListener mListModelChangeListener = new ListModelChangeListener();
    private List mItems;
    private Object mSelectedItem;

    public ModelPropertyListModel(DataModel dataModel, ModelProperty modelProperty) {
        this.mModel = dataModel;
        this.mCollectionProperty = modelProperty;
        this.mModel.addWeakPropertyChangeListener(this.mCollectionProperty, this.mListModelChangeListener);
        this.copyElements();
    }

    public int getSize() {
        return this.mItems.size();
    }

    public Object getElementAt(int n2) {
        return this.mItems.get(n2);
    }

    public Object getSelectedItem() {
        return this.mSelectedItem;
    }

    public void setSelectedItem(Object object) {
        this.mSelectedItem = object;
        this.fireContentsChanged(this, -1, -1);
    }

    private void copyElements() {
        this.mItems = new ArrayList((Collection)this.mModel.getProperty(this.mCollectionProperty));
    }

    private void updateElements() {
        this.copyElements();
        this.fireContentsChanged(this, 0, this.getSize());
    }

    public class ListModelChangeListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ModelPropertyListModel.this.updateElements();
        }
    }
}

