/*
 * Decompiled with CFR 0.152.
 */
package GuiUtilities.Layouts;

import GuiUtilities.Layouts.Alignment;
import GuiUtilities.Layouts.ConstraintLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.Serializable;

public class BasicGridLayout
extends ConstraintLayout {
    protected int hGap;
    protected int vGap;
    protected int rows;
    protected int cols;
    protected int reqRows;
    protected int reqCols;
    protected int[] rowHeights;
    protected int[] colWidths;
    protected int alignment = 8;
    protected int fill = 3;
    protected int colWeight = 0;
    protected int rowWeight = 0;

    public BasicGridLayout() {
        this(0, 1, 2, 2);
    }

    public BasicGridLayout(int n2, int n3) {
        this(n2, n3, 2, 2);
    }

    public BasicGridLayout(int n2, int n3, int n4, int n5) {
        this(n2, n3, n4, n5, 0, 0);
    }

    public BasicGridLayout(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.reqRows = n2;
        this.reqCols = n3;
        this.hGap = n4;
        this.vGap = n5;
        this.hMargin = n6;
        this.vMargin = n7;
    }

    public void setColumns(int n2) {
        if (n2 < 1) {
            n2 = 1;
        }
        this.cols = n2;
    }

    public void setRows(int n2) {
        if (n2 < 1) {
            n2 = 1;
        }
        this.rows = n2;
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.cols;
    }

    public void setAlignment(int n2) {
        this.alignment = n2;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setFill(int n2) {
        this.fill = n2;
    }

    public int getFill() {
        return this.fill;
    }

    public void setColWeight(int n2) {
        this.colWeight = n2;
    }

    public int getColWeight() {
        return this.colWeight;
    }

    public void setRowWeight(int n2) {
        this.rowWeight = n2;
    }

    public int getRowWeight() {
        return this.rowWeight;
    }

    protected int alignmentFor(Component component, int n2, int n3) {
        return this.alignment;
    }

    protected int fillFor(Component component, int n2, int n3) {
        return this.fill;
    }

    protected int getRowWeight(int n2) {
        return this.getRowWeight();
    }

    protected int getColWeight(int n2) {
        return this.getColWeight();
    }

    protected int sumArray(int[] nArray, int n2, int n3) {
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            n4 += nArray[i2];
        }
        if (n3 > 1) {
            n4 += (n3 - 1) * n2;
        }
        return n4;
    }

    protected void calcCellSizes(Container container, int n2) {
        int n3;
        int n4;
        int n5;
        Cloneable cloneable;
        Serializable serializable;
        int n6;
        int n7 = container.getComponentCount();
        if (this.reqCols <= 0) {
            this.rows = this.reqRows;
            this.cols = (n7 + this.reqRows - 1) / this.reqRows;
        } else {
            this.rows = (n7 + this.reqCols - 1) / this.reqCols;
            this.cols = this.reqCols;
        }
        this.colWidths = new int[this.cols];
        for (n6 = 0; n6 < this.cols; ++n6) {
            this.colWidths[n6] = 0;
        }
        this.rowHeights = new int[this.rows];
        for (n6 = 0; n6 < this.rows; ++n6) {
            this.rowHeights[n6] = 0;
        }
        int n8 = 0;
        for (n6 = 0; n6 < n7; ++n6) {
            serializable = container.getComponent(n6);
            if (!this.includeComponent((Component)serializable)) continue;
            cloneable = this.getComponentSize((Component)serializable, n2);
            n5 = n8 / this.cols;
            n4 = n8 % this.cols;
            if (this.colWidths[n4] < ((Dimension)cloneable).width) {
                this.colWidths[n4] = ((Dimension)cloneable).width;
            }
            if (this.rowHeights[n5] < ((Dimension)cloneable).height) {
                this.rowHeights[n5] = ((Dimension)cloneable).height;
            }
            ++n8;
        }
        serializable = container.getSize();
        cloneable = container.getInsets();
        serializable.width -= cloneable.left + cloneable.right + 2 * this.hMargin;
        serializable.height -= cloneable.top + cloneable.bottom + 2 * this.vMargin;
        n4 = 0;
        n5 = 0;
        for (n6 = 0; n6 < this.cols; ++n6) {
            n5 += this.getColWeight(n6);
            n4 += this.colWidths[n6];
            if (n6 == 0) continue;
            n4 += this.hGap;
        }
        if (n5 != 0 && n4 < serializable.width) {
            n3 = serializable.width - n4;
            for (n6 = 0; n6 < this.cols; ++n6) {
                int n9 = n6;
                this.colWidths[n9] = this.colWidths[n9] + n3 * this.getColWeight(n6) / n5;
            }
        }
        n4 = 0;
        n5 = 0;
        for (n6 = 0; n6 < this.rows; ++n6) {
            n5 += this.getRowWeight(n6);
            n4 += this.rowHeights[n6];
            if (n6 == 0) continue;
            n4 += this.vGap;
        }
        if (n5 != 0 && n4 < serializable.height) {
            n3 = serializable.height - n4;
            for (n6 = 0; n6 < this.rows; ++n6) {
                int n10 = n6;
                this.rowHeights[n10] = this.rowHeights[n10] + n3 * this.getRowWeight(n6) / n5;
            }
        }
    }

    public void measureLayout(Container container, Dimension dimension, int n2) {
        if (dimension != null) {
            this.calcCellSizes(container, n2);
            dimension.width = this.sumArray(this.colWidths, this.hGap, this.cols);
            dimension.height = this.sumArray(this.rowHeights, this.vGap, this.rows);
            this.colWidths = null;
            this.rowHeights = null;
        } else {
            int n3 = container.getComponentCount();
            if (n3 > 0) {
                Insets insets = container.getInsets();
                int n4 = 0;
                this.calcCellSizes(container, n2);
                for (int i2 = 0; i2 < n3; ++i2) {
                    Component component = container.getComponent(i2);
                    if (!this.includeComponent(component)) continue;
                    Dimension dimension2 = this.getComponentSize(component, n2);
                    Rectangle rectangle = new Rectangle(0, 0, dimension2.width, dimension2.height);
                    int n5 = n4 / this.cols;
                    int n6 = n4 % this.cols;
                    int n7 = insets.left + this.sumArray(this.colWidths, this.hGap, n6) + this.hMargin;
                    int n8 = insets.top + this.sumArray(this.rowHeights, this.vGap, n5) + this.vMargin;
                    if (n6 > 0) {
                        n7 += this.hGap;
                    }
                    if (n5 > 0) {
                        n8 += this.vGap;
                    }
                    Rectangle rectangle2 = new Rectangle(n7, n8, this.colWidths[n6], this.rowHeights[n5]);
                    Alignment.alignInCell(rectangle, rectangle2, this.alignmentFor(component, n5, n6), this.fillFor(component, n5, n6));
                    component.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    ++n4;
                }
            }
            this.colWidths = null;
            this.rowHeights = null;
        }
    }
}

