/*
 * Decompiled with CFR 0.152.
 */
package GuiUtilities.Table;

import DataModels.DataModel;
import DataModels.ModelProperty;
import GuiUtilities.Layouts.GridBagBuilder;
import GuiUtilities.Table.ColumnDescription;
import GuiUtilities.Table.DataModelTableModel;
import GuiUtilities.Table.MutableDataModelTableModel;
import GuiUtilities.Table.SortableTable;
import GuiUtilities.Table.TableSorter;
import GuiUtilities.Util.GuiUtilities;
import GuiUtilities.Util.StatusMessage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public abstract class MasterDetailPanel
extends JPanel {
    protected DataModelTableModel mMasterTableModel;
    protected DataModelTableModel mDetailTableModel;
    protected ColumnDescription[] mMasterColumns;
    protected ColumnDescription[] mDetailColumns;
    protected SortableTable mMasterTable;
    protected SortableTable mDetailTable;
    private JComponent mMasterComponent;
    private JComponent mDetailComponent;
    private JLabel mDetailTableLabel;
    private JLabel mMasterTableLabel;
    private JLabel mMasterDetailLabel;
    private boolean mIsRestoringTheSelection;

    public MasterDetailPanel(String string, ModelProperty[] modelPropertyArray, String string2, ModelProperty[] modelPropertyArray2) {
        ColumnDescription[] columnDescriptionArray = new ColumnDescription[modelPropertyArray2.length];
        for (int i2 = 0; i2 < modelPropertyArray2.length; ++i2) {
            columnDescriptionArray[i2] = new ColumnDescription(modelPropertyArray2[i2], 50);
        }
        ColumnDescription[] columnDescriptionArray2 = new ColumnDescription[modelPropertyArray.length];
        for (int i3 = 0; i3 < modelPropertyArray.length; ++i3) {
            columnDescriptionArray2[i3] = new ColumnDescription(modelPropertyArray[i3], 50);
        }
        this.init(string, columnDescriptionArray2, string2, columnDescriptionArray);
    }

    public MasterDetailPanel(String string, ColumnDescription[] columnDescriptionArray, String string2, ColumnDescription[] columnDescriptionArray2) {
        this.init(string, columnDescriptionArray, string2, columnDescriptionArray2);
    }

    private void init(String string, ColumnDescription[] columnDescriptionArray, String string2, ColumnDescription[] columnDescriptionArray2) {
        this.mMasterColumns = (ColumnDescription[])columnDescriptionArray.clone();
        this.mDetailColumns = (ColumnDescription[])columnDescriptionArray2.clone();
        this.guiInit(string, string2);
    }

    public void setMasterColums(ColumnDescription[] columnDescriptionArray) {
        this.mMasterColumns = (ColumnDescription[])columnDescriptionArray.clone();
        this.setColumns(this.mMasterTable, this.mMasterColumns);
    }

    public void setDetailColumns(ColumnDescription[] columnDescriptionArray) {
        this.mDetailColumns = (ColumnDescription[])columnDescriptionArray.clone();
        this.setColumns(this.mDetailTable, this.mDetailColumns);
    }

    private void setColumns(SortableTable sortableTable, ColumnDescription[] columnDescriptionArray) {
        MutableDataModelTableModel mutableDataModelTableModel = this.getModelFromTable(sortableTable);
        List list = mutableDataModelTableModel.getAllRows();
        sortableTable.setModel(new MutableDataModelTableModel(list, this.extractModelProperties(columnDescriptionArray)));
        this.setPreferredWidths(columnDescriptionArray, sortableTable);
    }

    public void setMasterTableModel(List list) {
        this.mMasterTableModel = this.buildTableModel(list, this.mMasterTable);
    }

    public void setDetailTableModel(List list) {
        this.mDetailTableModel = this.buildTableModel(list, this.mDetailTable);
        this.clearDetailTableMessage();
    }

    public void setDetailTableMessage(String string) {
        this.setDetailTableMessage(new StatusMessage(string));
    }

    public void setDetailTableMessage(StatusMessage statusMessage) {
        this.setTableMessage(this.mDetailTableLabel, statusMessage);
    }

    public void clearDetailTableMessage() {
        this.mDetailTableLabel.setText("");
        this.mDetailTableLabel.setVisible(false);
    }

    public void setMasterTableMessage(String string) {
        this.setMasterTableMessage(new StatusMessage(string));
    }

    public void setMasterTableMessage(StatusMessage statusMessage) {
        this.setTableMessage(this.mMasterTableLabel, statusMessage);
    }

    public void clearMasterTableMessage() {
        this.mMasterTableLabel.setText("");
        this.mMasterTableLabel.setVisible(false);
    }

    public void setPanelMessage(StatusMessage statusMessage) {
        this.setTableMessage(this.mMasterDetailLabel, statusMessage);
    }

    public void clearPanelMessage() {
        this.mMasterDetailLabel.setText("");
        this.mMasterDetailLabel.setVisible(false);
    }

    private void setTableMessage(JLabel jLabel, StatusMessage statusMessage) {
        jLabel.setText(statusMessage.getStatus());
        ImageIcon imageIcon = statusMessage.getIcon();
        jLabel.setIcon(imageIcon);
        jLabel.setVisible(true);
    }

    private DataModelTableModel buildTableModel(List list, SortableTable sortableTable) {
        MutableDataModelTableModel mutableDataModelTableModel = this.getModelFromTable(sortableTable);
        List list2 = new ArrayList();
        if (mutableDataModelTableModel != null) {
            list2 = this.getSelectedRows(sortableTable, mutableDataModelTableModel);
        }
        this.mIsRestoringTheSelection = true;
        mutableDataModelTableModel.clear();
        mutableDataModelTableModel.addRows(0, list);
        sortableTable.getSelectionModel().setValueIsAdjusting(true);
        TableSorter tableSorter = (TableSorter)sortableTable.getModel();
        if (list2.size() > 0) {
            DataModelTableModel.selectData(sortableTable, list2, mutableDataModelTableModel.getAllRows(), tableSorter);
        }
        this.mIsRestoringTheSelection = false;
        if (sortableTable == this.mMasterTable) {
            this.masterSelectionChange(this.getMasterSelections());
        }
        return mutableDataModelTableModel;
    }

    private MutableDataModelTableModel getModelFromTable(SortableTable sortableTable) {
        TableModel tableModel = ((TableSorter)sortableTable.getModel()).getTableModel();
        if (tableModel != null && tableModel instanceof MutableDataModelTableModel) {
            return (MutableDataModelTableModel)tableModel;
        }
        return null;
    }

    public abstract void masterSelectionChange(Collection var1);

    public void masterTableModelChanged() {
        this.masterSelectionChange(this.getMasterSelections());
        int n2 = this.mMasterTable.getSelectedRow();
        this.mMasterTableModel.fireTableRowsUpdated(n2, n2);
    }

    private void guiInit(String string, String string2) {
        this.mMasterDetailLabel = new JLabel();
        this.mMasterDetailLabel.setVisible(false);
        JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setContinuousLayout(true);
        jSplitPane.setDividerLocation(-1);
        jSplitPane.setResizeWeight(0.5);
        this.mDetailTableLabel = new JLabel();
        this.mDetailTableLabel.setVisible(false);
        this.mMasterTableLabel = new JLabel();
        this.mMasterTableLabel.setVisible(false);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagBuilder gridBagBuilder = new GridBagBuilder().setSize(1, 1).setLocation(0, 0);
        this.add((Component)this.mMasterDetailLabel, gridBagBuilder.setAnchor(17).setInsets(0, 7, 5, 0).getConstraints());
        jSplitPane.add(this.getMasterTablePanel(string), "top");
        jSplitPane.add(this.getDetailTablePanel(string2), "bottom");
        this.add((Component)jSplitPane, gridBagBuilder.setLocation(0, 1).setFill(1, 1.0, 1.0).getConstraints());
    }

    private Component getMasterTablePanel(String string) {
        ModelProperty[] modelPropertyArray = this.extractModelProperties(this.mMasterColumns);
        this.mMasterTable = new SortableTable(new MutableDataModelTableModel(new ArrayList(), modelPropertyArray));
        this.setPreferredWidths(this.mMasterColumns, this.mMasterTable);
        this.mMasterTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                if (MasterDetailPanel.this.mIsRestoringTheSelection) {
                    return;
                }
                MasterDetailPanel.this.masterSelectionChange(MasterDetailPanel.this.getMasterSelections());
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.mMasterTable);
        jScrollPane.getViewport().setBackground(Color.LIGHT_GRAY);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(this.createBorder(string));
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.add((Component)this.mMasterTableLabel, "South");
        this.mMasterComponent = jPanel;
        return jPanel;
    }

    private void setPreferredWidths(ColumnDescription[] columnDescriptionArray, SortableTable sortableTable) {
        TableColumnModel tableColumnModel = sortableTable.getTableHeader().getColumnModel();
        for (int i2 = 0; i2 < columnDescriptionArray.length; ++i2) {
            tableColumnModel.getColumn(i2).setPreferredWidth(columnDescriptionArray[i2].getColumnWidth());
        }
    }

    private ModelProperty[] extractModelProperties(ColumnDescription[] columnDescriptionArray) {
        ModelProperty[] modelPropertyArray = new ModelProperty[columnDescriptionArray.length];
        for (int i2 = 0; i2 < modelPropertyArray.length; ++i2) {
            modelPropertyArray[i2] = columnDescriptionArray[i2].getColumnKey();
        }
        return modelPropertyArray;
    }

    private Component getDetailTablePanel(String string) {
        ModelProperty[] modelPropertyArray = this.extractModelProperties(this.mDetailColumns);
        this.mDetailTable = new SortableTable(new MutableDataModelTableModel(new ArrayList(), modelPropertyArray));
        this.setPreferredWidths(this.mDetailColumns, this.mDetailTable);
        JScrollPane jScrollPane = new JScrollPane(this.mDetailTable);
        jScrollPane.getViewport().setBackground(Color.LIGHT_GRAY);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(this.createBorder(string));
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.add((Component)this.mDetailTableLabel, "South");
        this.mDetailComponent = jPanel;
        return jPanel;
    }

    private List getSelectedRows(SortableTable sortableTable, DataModelTableModel dataModelTableModel) {
        if (dataModelTableModel == null) {
            return new ArrayList();
        }
        int[] nArray = sortableTable.getSelectedUnderlyingModelRows();
        ArrayList<DataModel> arrayList = new ArrayList<DataModel>(nArray.length);
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            arrayList.add(dataModelTableModel.getRow(nArray[i2]));
        }
        return arrayList;
    }

    public List getMasterSelections() {
        return this.getSelectedRows(this.mMasterTable, this.mMasterTableModel);
    }

    public List getDetailSelections() {
        return this.getSelectedRows(this.mDetailTable, this.mDetailTableModel);
    }

    public List getMasterRows() {
        return this.mMasterTableModel.getAllRows();
    }

    public List getDetailRows() {
        return this.mDetailTableModel.getAllRows();
    }

    public SortableTable getMasterTable() {
        return this.mMasterTable;
    }

    public SortableTable getDetailTable() {
        return this.mDetailTable;
    }

    public void setMasterTitle(String string) {
        this.mMasterComponent.setBorder(this.createBorder(string));
    }

    public void setDetailTitle(String string) {
        this.mDetailComponent.setBorder(this.createBorder(string));
    }

    protected Border createBorder(String string) {
        return GuiUtilities.getTitledBorder(string, Color.ORANGE, Color.BLACK, 5);
    }
}

