/*
 * Decompiled with CFR 0.152.
 */
package GuiUtilities.Util.AutoFillWidget;

import GuiUtilities.Util.AutoFillWidget.AlphabeticMatchListProducer;
import GuiUtilities.Util.AutoFillWidget.AutoFillListModel;
import GuiUtilities.Util.AutoFillWidget.MatchListConsumer;
import GuiUtilities.Util.AutoFillWidget.MatchListInfo;
import GuiUtilities.Util.AutoFillWidget.MatchListProducer;
import GuiUtilities.Util.AutoFillWidget.TokenizedAutoFillBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JRootPane;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class AutoFillBox
extends JComboBox
implements ListSelectionListener,
MatchListConsumer,
KeyListener,
FocusListener,
MouseListener {
    public static final int DEFAULT_MAXIMUM_ROW_COUNT = 8;
    public static final int NO_SELECTION = -1;
    public static final int NO_BREAK = -1;
    public static final String SELECTION_MADE = "SelectionMade";
    protected int mInternalIndex = -1;
    protected int mPreviousIndex = -1;
    private boolean mSelectionChange = false;
    protected final MatchListProducer mMatchListProducer;
    int mBreak = -1;
    boolean mAutoSelect = false;
    boolean mEmphasizeMatch = false;

    public AutoFillBox(MatchListProducer matchListProducer, boolean bl2) {
        super(new AutoFillListModel());
        this.mMatchListProducer = matchListProducer;
        this.setEditable(true);
        if (bl2) {
            this.sendMatchString("");
        }
        this.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
    }

    public AutoFillBox(MatchListProducer matchListProducer) {
        this(matchListProducer, false);
    }

    public void setUI(ComboBoxUI comboBoxUI) {
        if (this.getUI() != null) {
            this.removeComponentListeners();
        }
        super.setUI(comboBoxUI);
        this.addComponentListeners();
    }

    private void addComponentListeners() {
        JTextComponent jTextComponent = (JTextComponent)this.getEditor().getEditorComponent();
        jTextComponent.setDocument(new AutoFillDocumentEditor());
        jTextComponent.addKeyListener(this);
        jTextComponent.addFocusListener(this);
        BasicComboPopup basicComboPopup = (BasicComboPopup)this.getUI().getAccessibleChild(this, 0);
        basicComboPopup.getList().addListSelectionListener(this);
        basicComboPopup.getList().setCellRenderer(new AutoFillListCellRenderer(this));
        basicComboPopup.getList().addMouseListener(this);
    }

    private void removeComponentListeners() {
        JTextComponent jTextComponent = (JTextComponent)this.getEditor().getEditorComponent();
        jTextComponent.setDocument(new AutoFillDocumentEditor());
        jTextComponent.removeKeyListener(this);
        jTextComponent.removeFocusListener(this);
        BasicComboPopup basicComboPopup = (BasicComboPopup)this.getUI().getAccessibleChild(this, 0);
        basicComboPopup.getList().removeListSelectionListener(this);
        basicComboPopup.getList().removeMouseListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void processSelection() {
        String string;
        String string2 = this.getText();
        String string3 = this.getNewContent(string2, string = this.mInternalIndex == -1 || !this.isPopupVisible() ? null : (String)this.getItemAt(this.mInternalIndex));
        if (string3.equals(string2) && this.mInternalIndex == 0 && this.mPreviousIndex == -1) {
            this.mInternalIndex = -1;
            this.mPreviousIndex = 0;
        }
        this.setText(string3);
    }

    protected String getNewContent(String string, String string2) {
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    void sendMatchString(String string) {
        this.mMatchListProducer.sendMatchString(string, this);
    }

    public void updateMatchList(MatchListInfo matchListInfo) {
        String string = (String)this.getItemAt(this.mInternalIndex);
        ((AutoFillListModel)this.getModel()).updateMatchList(matchListInfo);
        this.mBreak = !matchListInfo.getFirstList().isEmpty() && !matchListInfo.getSecondList().isEmpty() ? matchListInfo.getFirstList().size() : -1;
        int n2 = this.findPreviousSelection(string);
        this.displayMatches(n2);
    }

    private int findPreviousSelection(String string) {
        if (string == null) {
            return -1;
        }
        for (int i2 = 0; i2 < this.getItemCount(); ++i2) {
            if (!string.equals(this.getItemAt(i2).toString())) continue;
            return i2;
        }
        return -1;
    }

    protected void displayMatches(int n2) {
        if (this.getModel().getSize() == 0) {
            this.hidePopup();
            return;
        }
        if (this.getModel().getSize() >= 8) {
            this.setMaximumRowCount(8);
        } else {
            this.setMaximumRowCount(this.getModel().getSize());
        }
        this.mSelectionChange = true;
        this.setSelectedIndex(-1);
        if (n2 != -1) {
            this.setSelectedIndex(n2);
        } else if (this.getAutoSelect()) {
            this.setSelectedIndex(0);
        }
        this.mSelectionChange = false;
        if (this.isShowing()) {
            this.showPopup();
        }
    }

    public boolean getAutoSelect() {
        return this.mAutoSelect;
    }

    public void setAutoSelect(boolean bl2) {
        this.mAutoSelect = bl2;
    }

    public boolean getEmphasizeMatch() {
        return this.mEmphasizeMatch;
    }

    public void setEmphasizeMatch(boolean bl2) {
        this.mEmphasizeMatch = bl2;
    }

    public String getText() {
        return (String)this.getEditor().getItem();
    }

    public void setText(String string) {
        this.getEditor().setItem(string);
    }

    protected String getCurrentString() {
        return this.getText();
    }

    protected void fireSelectionEvent() {
        String string = this.getActionCommand();
        this.setActionCommand(SELECTION_MADE);
        this.fireActionEvent();
        this.setActionCommand(string);
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 40 && this.mInternalIndex == -1 && this.getAutoSelect() && this.getModel().getSize() > 0) {
            this.mSelectionChange = true;
            this.mInternalIndex = 0;
            this.setSelectedIndex(0);
            this.mSelectionChange = false;
        } else if (keyEvent.getKeyCode() == 38) {
            if (this.mInternalIndex <= 0) {
                this.hidePopup();
                this.mInternalIndex = -1;
            }
        } else if (keyEvent.getKeyCode() == 10) {
            JRootPane jRootPane;
            JButton jButton;
            this.processSelection();
            this.fireSelectionEvent();
            this.hidePopup();
            if (this.mPreviousIndex == -1 && (jButton = (jRootPane = ((JComponent)keyEvent.getSource()).getRootPane()).getDefaultButton()) != null) {
                jButton.doClick();
            }
            this.mPreviousIndex = -1;
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.mPreviousIndex = this.mInternalIndex;
        this.mInternalIndex = ((JList)listSelectionEvent.getSource()).getSelectedIndex();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1) {
            this.processSelection();
            this.fireSelectionEvent();
            this.hidePopup();
            this.mPreviousIndex = -1;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        this.hidePopup();
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        try {
            object2 = new BufferedReader(new FileReader("NAMES.DIC"));
            while ((object = ((BufferedReader)object2).readLine()) != null) {
                arrayList.add(object);
            }
            ((BufferedReader)object2).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        object2 = new AlphabeticMatchListProducer(arrayList);
        object = new TokenizedAutoFillBox((MatchListProducer)object2, ",");
        ((AutoFillBox)object).setAutoSelect(true);
        JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(3);
        jFrame.getContentPane().add((Component)object);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    private class AutoFillListCellRenderer
    extends DefaultListCellRenderer {
        AutoFillBox mAutoFillBox;

        public AutoFillListCellRenderer(AutoFillBox autoFillBox2) {
            this.setOpaque(true);
            this.mAutoFillBox = autoFillBox2;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl2, boolean bl3) {
            this.setComponentOrientation(jList.getComponentOrientation());
            if (bl2) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            if (object instanceof Icon) {
                this.setIcon((Icon)object);
                this.setText("");
            } else {
                this.setIcon(null);
                if (this.mAutoFillBox.getEmphasizeMatch()) {
                    String string = this.mAutoFillBox.getCurrentString();
                    String string2 = object.toString().substring(string.length());
                    this.setText("<html><i>" + string + "</i>" + string2 + "</html>");
                } else {
                    this.setText(object.toString());
                }
            }
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            this.setBorder(bl3 ? UIManager.getBorder("List.focusCellHighlightBorder") : noFocusBorder);
            if (n2 == AutoFillBox.this.mBreak) {
                this.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.black));
            } else if (n2 + 1 == AutoFillBox.this.mBreak) {
                this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.black));
            } else {
                this.setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 0));
            }
            return this;
        }
    }

    private class AutoFillDocumentEditor
    extends PlainDocument {
        private AutoFillDocumentEditor() {
        }

        public void insertString(int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            if (AutoFillBox.this.mSelectionChange) {
                return;
            }
            String string2 = this.getText(0, this.getLength());
            AutoFillBox.this.sendMatchString(string2 + string);
            super.insertString(n2, string, attributeSet);
        }

        public void remove(int n2, int n3) throws BadLocationException {
            if (AutoFillBox.this.mSelectionChange) {
                return;
            }
            super.remove(n2, n3);
            String string = this.getText(0, this.getLength());
            AutoFillBox.this.sendMatchString(string);
        }
    }
}

