/*
 * Decompiled with CFR 0.152.
 */
package GuiUtilities.Util;

import GuiUtilities.Util.CompositeScreen;
import GuiUtilities.Util.ScreenElement;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class CompositeScreenBuilder {
    public static CompositeScreen build(ScreenElement[] screenElementArray) {
        ScreenElement[] screenElementArray2 = new ScreenElement[screenElementArray.length];
        System.arraycopy(screenElementArray, 0, screenElementArray2, 0, screenElementArray.length);
        List<ScreenElement> list = Arrays.asList(screenElementArray2);
        Collections.sort(list, new ScreenElementComparator());
        CompositeScreen compositeScreen = new CompositeScreen();
        CompositeScreen compositeScreen2 = new CompositeScreen();
        Rectangle rectangle = new Rectangle();
        Iterator<ScreenElement> iterator = list.iterator();
        while (iterator.hasNext()) {
            ScreenElement screenElement = iterator.next();
            Rectangle rectangle2 = screenElement.getBounds();
            if (!rectangle.getSize().equals(rectangle2.getSize()) || rectangle.y != rectangle2.y || rectangle.x + rectangle.width != rectangle2.x) {
                if (CompositeScreenBuilder.isLargerThanOrEqualsTo(compositeScreen2, compositeScreen)) {
                    compositeScreen = compositeScreen2;
                }
                compositeScreen2 = new CompositeScreen();
            }
            compositeScreen2.addScreenElement(screenElement);
            rectangle = rectangle2;
        }
        if (CompositeScreenBuilder.isLargerThanOrEqualsTo(compositeScreen2, compositeScreen)) {
            compositeScreen = compositeScreen2;
        }
        return compositeScreen;
    }

    public static boolean isLargerThanOrEqualsTo(CompositeScreen compositeScreen, CompositeScreen compositeScreen2) {
        return compositeScreen.getPixelArea() >= compositeScreen2.getPixelArea();
    }

    private static class ScreenElementComparator
    implements Comparator {
        private ScreenElementComparator() {
        }

        public int compare(Object object, Object object2) {
            Rectangle rectangle = ((ScreenElement)object).getBounds();
            Rectangle rectangle2 = ((ScreenElement)object2).getBounds();
            int n2 = rectangle.y - rectangle2.y;
            if (n2 != 0) {
                return n2;
            }
            return rectangle.x - rectangle2.x;
        }
    }
}

