/*
 * Decompiled with CFR 0.152.
 */
package GuiUtilities.Util;

import GuiUtilities.Util.DnDListModel;
import GuiUtilities.Util.TransferableObject;
import RuntimeTool.DebugManager;
import java.awt.Cursor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import javax.swing.JList;
import javax.swing.ListModel;

public class DnDJList
extends JList
implements DropTargetListener,
DragSourceListener,
DragGestureListener {
    private DragSource mDragSource = null;
    private int mSelectedSourceIndex;
    private int mOverIndex;
    private boolean mIsSource = false;
    private Object mSelectedObject;
    private DataFlavor mDataFlavor;

    public DnDJList(ListModel listModel, DataFlavor dataFlavor) {
        super(listModel);
        this.initDragAndDrop();
        this.setSingleSelectionMode();
        this.mDataFlavor = dataFlavor;
    }

    private void setSingleSelectionMode() {
        this.setSelectionMode(0);
    }

    protected void initDragAndDrop() {
        new DropTarget(this, this);
        this.mDragSource = new DragSource();
        this.mDragSource.createDefaultDragGestureRecognizer(this, 2, this);
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        this.mOverIndex = this.locationToIndex(dropTargetDragEvent.getLocation());
        this.setSelectedIndex(this.mOverIndex);
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        this.mOverIndex = -1;
        this.clearSelection();
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        int n2 = this.locationToIndex(dropTargetDragEvent.getLocation());
        if (n2 != -1 && n2 != this.mOverIndex) {
            this.mOverIndex = n2;
            this.setSelectedIndex(this.mOverIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        try {
            Transferable transferable = dropTargetDropEvent.getTransferable();
            if (transferable.isDataFlavorSupported(this.mDataFlavor)) {
                dropTargetDropEvent.acceptDrop(2);
                int n2 = this.locationToIndex(dropTargetDropEvent.getLocation());
                Object object = transferable.getTransferData(this.mDataFlavor);
                DnDListModel dnDListModel = (DnDListModel)this.getModel();
                if (this.mIsSource) {
                    dnDListModel.swap(n2, this.mSelectedSourceIndex);
                    this.setSelectedIndex(n2);
                } else {
                    dnDListModel.insertItem(n2, object);
                    this.setSelectedIndex(n2 + 1);
                }
                dropTargetDropEvent.getDropTargetContext().dropComplete(true);
            } else {
                dropTargetDropEvent.rejectDrop();
            }
        }
        catch (IOException iOException) {
            DebugManager.getDefault().printException("Error during drag and drop", iOException);
            dropTargetDropEvent.rejectDrop();
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            DebugManager.getDefault().printException("Error during drag and drop", unsupportedFlavorException);
            dropTargetDropEvent.rejectDrop();
        }
        finally {
            this.mOverIndex = -1;
            this.mIsSource = false;
        }
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        JList jList = (JList)dragGestureEvent.getComponent();
        this.mSelectedSourceIndex = jList.getSelectedIndex();
        this.mSelectedObject = jList.getSelectedValue();
        if (this.mSelectedObject != null) {
            TransferableObject transferableObject = new TransferableObject(this.mSelectedObject, this.mDataFlavor);
            this.mIsSource = true;
            this.mDragSource.startDrag(dragGestureEvent, DragSource.DefaultMoveDrop, transferableObject, this);
        }
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        if (dragSourceDropEvent.getDropSuccess() && this.mIsSource) {
            ((DnDListModel)this.getModel()).removeElement(this.mSelectedObject);
            this.clearSelection();
            this.mSelectedSourceIndex = -1;
        }
        this.mIsSource = false;
        this.setCursor(new Cursor(0));
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }
}

