/*
 * Decompiled with CFR 0.152.
 */
package GuiUtilities.Util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Date;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class MemoryMonitor
extends JPanel {
    static JCheckBox dateStampCB = new JCheckBox("Output Date Stamp");
    public Surface surf;
    JPanel controls;
    boolean doControls;
    JTextField tf;

    public MemoryMonitor() {
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder(new EtchedBorder(), "Intelerad Clinical Viewer Memory Monitor"));
        this.surf = new Surface();
        this.add(this.surf);
        this.controls = new JPanel();
        this.controls.setPreferredSize(new Dimension(135, 80));
        Font font = new Font("serif", 0, 10);
        JLabel jLabel = new JLabel("Sample Rate");
        jLabel.setFont(font);
        jLabel.setForeground(Color.black);
        this.controls.add(jLabel);
        this.tf = new JTextField("1000");
        this.tf.setPreferredSize(new Dimension(45, 20));
        this.controls.add(this.tf);
        jLabel = new JLabel("ms");
        this.controls.add(jLabel);
        jLabel.setFont(font);
        jLabel.setForeground(Color.black);
        this.controls.add(dateStampCB);
        dateStampCB.setFont(font);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                MemoryMonitor.this.removeAll();
                MemoryMonitor.this.doControls = !MemoryMonitor.this.doControls;
                if (MemoryMonitor.this.doControls) {
                    MemoryMonitor.this.surf.stop();
                    MemoryMonitor.this.add(MemoryMonitor.this.controls);
                } else {
                    try {
                        MemoryMonitor.this.surf.sleepAmount = Long.parseLong(MemoryMonitor.this.tf.getText().trim());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    MemoryMonitor.this.surf.start();
                    MemoryMonitor.this.add(MemoryMonitor.this.surf);
                }
                MemoryMonitor.this.validate();
                MemoryMonitor.this.repaint();
            }
        });
    }

    public static void main(String[] stringArray) {
        final MemoryMonitor memoryMonitor = new MemoryMonitor();
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }

            public void windowDeiconified(WindowEvent windowEvent) {
                memoryMonitor.surf.start();
            }

            public void windowIconified(WindowEvent windowEvent) {
                memoryMonitor.surf.stop();
            }
        };
        JFrame jFrame = new JFrame("Intelerad Memory Monitor");
        jFrame.addWindowListener(windowAdapter);
        jFrame.getContentPane().add("Center", memoryMonitor);
        jFrame.pack();
        jFrame.setSize(new Dimension(200, 200));
        jFrame.show();
        memoryMonitor.surf.start();
    }

    public class Surface
    extends JPanel
    implements Runnable {
        public Thread thread;
        public long sleepAmount = 1000L;
        private int w;
        private int h;
        private BufferedImage bimg;
        private Graphics2D big;
        private Font font = new Font("Times New Roman", 0, 11);
        private Runtime r = Runtime.getRuntime();
        private int columnInc;
        private int[] pts;
        private int ptNum;
        private int ascent;
        private int descent;
        private Rectangle graphOutlineRect = new Rectangle();
        private Rectangle2D mfRect = new Rectangle2D.Float();
        private Rectangle2D muRect = new Rectangle2D.Float();
        private Line2D graphLine = new Line2D.Float();
        private Color graphColor = new Color(46, 139, 87);
        private Color mfColor = new Color(0, 100, 0);
        private String usedStr;

        public Surface() {
            this.setBackground(Color.black);
            this.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ Surface this$1;
                {
                    this.this$1 = surface;
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (this.this$1.thread == null) {
                        this.this$1.start();
                    } else {
                        this.this$1.stop();
                    }
                }
            });
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            return new Dimension(135, 80);
        }

        public void paint(Graphics graphics) {
            int n2;
            int n3;
            int n4;
            if (this.big == null) {
                return;
            }
            this.big.setBackground(this.getBackground());
            this.big.clearRect(0, 0, this.w, this.h);
            float f2 = this.r.freeMemory();
            float f3 = this.r.totalMemory();
            this.big.setColor(Color.green);
            this.big.drawString(String.valueOf((int)f3 / 1024) + "K allocated", 4.0f, (float)this.ascent + 0.5f);
            this.usedStr = String.valueOf((int)(f3 - f2) / 1024) + "K used";
            this.big.drawString(this.usedStr, 4, this.h - this.descent);
            float f4 = this.ascent + this.descent;
            float f5 = (float)this.h - f4 * 2.0f - 0.5f;
            float f6 = f5 / 10.0f;
            float f7 = 20.0f;
            this.big.setColor(this.mfColor);
            int n5 = (int)(f2 / f3 * 10.0f);
            for (n4 = 0; n4 < n5; ++n4) {
                this.mfRect.setRect(5.0, f4 + (float)n4 * f6, f7, f6 - 1.0f);
                this.big.fill(this.mfRect);
            }
            this.big.setColor(Color.green);
            while (n4 < 10) {
                this.muRect.setRect(5.0, f4 + (float)n4 * f6, f7, f6 - 1.0f);
                this.big.fill(this.muRect);
                ++n4;
            }
            this.big.setColor(this.graphColor);
            int n6 = 30;
            int n7 = (int)f4;
            int n8 = this.w - n6 - 5;
            int n9 = (int)f5;
            this.graphOutlineRect.setRect(n6, n7, n8, n9);
            this.big.draw(this.graphOutlineRect);
            int n10 = n9 / 10;
            for (n3 = n7; n3 <= n9 + n7; n3 += n10) {
                this.graphLine.setLine(n6, n3, n6 + n8, n3);
                this.big.draw(this.graphLine);
            }
            n3 = n8 / 15;
            if (this.columnInc == 0) {
                this.columnInc = n3;
            }
            for (n2 = n6 + this.columnInc; n2 < n8 + n6; n2 += n3) {
                this.graphLine.setLine(n2, n7, n2, n7 + n9);
                this.big.draw(this.graphLine);
            }
            --this.columnInc;
            if (this.pts == null) {
                this.pts = new int[n8];
                this.ptNum = 0;
            } else if (this.pts.length != n8) {
                int[] nArray = null;
                if (this.ptNum < n8) {
                    nArray = new int[this.ptNum];
                    System.arraycopy(this.pts, 0, nArray, 0, nArray.length);
                } else {
                    nArray = new int[n8];
                    System.arraycopy(this.pts, this.pts.length - nArray.length, nArray, 0, nArray.length);
                    this.ptNum = nArray.length - 2;
                }
                this.pts = new int[n8];
                System.arraycopy(nArray, 0, this.pts, 0, nArray.length);
            } else {
                this.big.setColor(Color.yellow);
                this.pts[this.ptNum] = (int)((float)n7 + (float)n9 * (f2 / f3));
                n2 = n6 + n8 - this.ptNum;
                int n11 = 0;
                while (n11 < this.ptNum) {
                    if (n11 != 0) {
                        if (this.pts[n11] != this.pts[n11 - 1]) {
                            this.big.drawLine(n2 - 1, this.pts[n11 - 1], n2, this.pts[n11]);
                        } else {
                            this.big.fillRect(n2, this.pts[n11], 1, 1);
                        }
                    }
                    ++n11;
                    ++n2;
                }
                if (this.ptNum + 2 == this.pts.length) {
                    for (n2 = 1; n2 < this.ptNum; ++n2) {
                        this.pts[n2 - 1] = this.pts[n2];
                    }
                    --this.ptNum;
                } else {
                    ++this.ptNum;
                }
            }
            graphics.drawImage(this.bimg, 0, 0, this);
        }

        public void start() {
            this.thread = new Thread(this);
            this.thread.setPriority(1);
            this.thread.setName("MemoryMonitor");
            this.thread.start();
        }

        public synchronized void stop() {
            this.thread = null;
            this.notify();
        }

        public void run() {
            Thread thread = Thread.currentThread();
            while (this.thread == thread && !this.isShowing() || this.getSize().width == 0) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
            while (this.thread == thread && this.isShowing()) {
                Dimension dimension = this.getSize();
                if (dimension.width != this.w || dimension.height != this.h) {
                    this.w = dimension.width;
                    this.h = dimension.height;
                    this.bimg = (BufferedImage)this.createImage(this.w, this.h);
                    this.big = this.bimg.createGraphics();
                    this.big.setFont(this.font);
                    FontMetrics fontMetrics = this.big.getFontMetrics(this.font);
                    this.ascent = fontMetrics.getAscent();
                    this.descent = fontMetrics.getDescent();
                }
                this.repaint();
                try {
                    Thread.sleep(this.sleepAmount);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                if (!dateStampCB.isSelected()) continue;
                System.out.println(new Date().toString() + " " + this.usedStr);
            }
            this.thread = null;
        }
    }
}

