/*
 * Decompiled with CFR 0.152.
 */
package GuiUtilities.Util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class PreferenceUtilities {
    public static final String LIST_SIZE = "List Size";

    public static void setList(List list, Preferences preferences) throws BackingStoreException {
        PreferenceUtilities.removeAllChildren(preferences);
        preferences.putInt(LIST_SIZE, list.size());
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Map map = (Map)list.get(i2);
            Preferences preferences2 = preferences.node("" + i2);
            PreferenceUtilities.setMap(map, preferences2);
        }
    }

    public static void setMap(Map map, Preferences preferences) throws BackingStoreException {
        PreferenceUtilities.removeAllChildren(preferences);
        preferences.clear();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            preferences.put(string, (String)map.get(string));
        }
    }

    public static List getList(Preferences preferences) throws BackingStoreException {
        String[] stringArray = preferences.childrenNames();
        int n2 = Math.min(preferences.getInt(LIST_SIZE, stringArray.length), stringArray.length);
        ArrayList<Map> arrayList = new ArrayList<Map>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList.add(PreferenceUtilities.createMapFromNode(preferences.node("" + i2)));
        }
        return arrayList;
    }

    public static Map getMap(Preferences preferences) throws BackingStoreException {
        return PreferenceUtilities.createMapFromNode(preferences);
    }

    public static boolean isVersionKeyCompatible(Preferences preferences, int n2, String string) {
        return preferences.getInt(string, -1) >= n2;
    }

    private static Map createMapFromNode(Preferences preferences) throws BackingStoreException {
        String[] stringArray = preferences.keys();
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = preferences.get(stringArray[i2], null);
            if (string == null) continue;
            linkedHashMap.put(stringArray[i2], string);
        }
        return linkedHashMap;
    }

    private static void removeAllChildren(Preferences preferences) throws BackingStoreException {
        String[] stringArray = preferences.childrenNames();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            preferences.node(stringArray[i2]).clear();
        }
    }
}

