/*
 * Decompiled with CFR 0.152.
 */
package GuiUtilities.Util;

import javax.swing.SwingUtilities;

public abstract class SwingWorker {
    private Object value;
    private Exception constructionException = null;
    protected boolean mCancelled = false;
    private ThreadVar threadVar;

    protected synchronized Object getValue() {
        return this.value;
    }

    private synchronized void setValue(Object object) {
        this.value = object;
    }

    public abstract Object construct();

    public void finished() {
    }

    public void failed(Exception exception) {
    }

    public void interrupt() {
        Thread thread = this.threadVar.get();
        if (thread != null) {
            thread.interrupt();
        }
        this.threadVar.clear();
    }

    public Object get() {
        Thread thread;
        while ((thread = this.threadVar.get()) != null) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        return this.getValue();
    }

    public SwingWorker() {
        final Runnable runnable = new Runnable(){

            public void run() {
                SwingWorker.this.finished();
            }
        };
        final Runnable runnable2 = new Runnable(){

            public void run() {
                SwingWorker.this.failed(SwingWorker.this.constructionException);
            }
        };
        Runnable runnable3 = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    SwingWorker.this.setValue(SwingWorker.this.construct());
                    SwingUtilities.invokeLater(runnable);
                }
                catch (Exception exception) {
                    SwingWorker.this.constructionException = exception;
                    SwingUtilities.invokeLater(runnable2);
                }
                finally {
                    SwingWorker.this.threadVar.clear();
                }
            }
        };
        Thread thread = new Thread(runnable3);
        this.threadVar = new ThreadVar(thread);
    }

    public void start() {
        Thread thread = this.threadVar.get();
        if (thread != null) {
            thread.start();
        }
    }

    public void cancel() {
    }

    private static class ThreadVar {
        private Thread thread;

        ThreadVar(Thread thread) {
            this.thread = thread;
        }

        synchronized Thread get() {
            return this.thread;
        }

        synchronized void clear() {
            this.thread = null;
        }
    }
}

