/*
 * Decompiled with CFR 0.152.
 */
package GuiUtilities.Util.TileCacheMonitorTool;

public final class RingBuffer {
    private int size = 100;
    private int start = 0;
    private int count = 0;
    private int write_pointer = 0;
    private boolean filled = false;
    private float[] array;

    public RingBuffer(int n2) {
        this.size = n2 > 0 ? n2 : 100;
        this.array = new float[this.size];
    }

    public synchronized void setSize(int n2) {
        int n3 = this.size;
        if (this.size < 2) {
            throw new IllegalArgumentException("Invalid size.");
        }
        int n4 = 0;
        if (n3 < n2) {
            this.filled = false;
            n4 = n3;
        } else {
            this.filled = true;
            n4 = n2;
        }
        float[] fArray = this.array;
        this.array = new float[n2];
        for (int i2 = 0; i2 < n4; ++i2) {
            this.array[i2] = fArray[i2];
        }
        this.count = n4;
        this.size = n2;
    }

    public int getCount() {
        return this.count;
    }

    public int getSize() {
        return this.size;
    }

    public synchronized void write(float f2) {
        if (!this.filled) {
            if (this.count == this.size) {
                this.filled = true;
            } else {
                ++this.count;
            }
        }
        if (this.filled) {
            this.start = (this.start + 1) % this.size;
        }
        this.array[this.write_pointer] = f2;
        this.write_pointer = (this.write_pointer + 1) % this.size;
    }

    public synchronized float read(int n2) {
        if (n2 < 0) {
            n2 = 0;
        }
        return this.array[(this.start + n2) % this.size];
    }
}

