/*
 * Decompiled with CFR 0.152.
 */
package GuiUtilities.Util.TileCacheMonitorTool;

import GuiUtilities.Util.TileCacheMonitorTool.Statistics;
import com.sun.media.jai.util.SunTileCache;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.BevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class TCInfo
extends JPanel
implements ChangeListener {
    private JSlider memoryCapacitySlider;
    private JSlider memoryThresholdSlider;
    private JLabel memoryCapacityLabel;
    private JLabel memoryThresholdLabel;
    private SunTileCache cache = null;
    private Statistics statistics;
    private float memoryUsage;
    private float memoryCapacity;
    private int percentTCM;
    private static final Color BACKGROUND = new Color(180, 180, 220);
    private static final Color LIGHT_BLUE = new Color(200, 200, 230);
    private static final BevelBorder BEVEL_BORDER = new BevelBorder(1);

    public TCInfo() {
        this.setLayout(new FlowLayout(0, 10, 1));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBackground(LIGHT_BLUE);
        this.memoryCapacityLabel = new JLabel("16 MB");
        this.memoryCapacityLabel.setBackground(LIGHT_BLUE);
        this.memoryCapacityLabel.setForeground(Color.black);
        jPanel.add((Component)this.memoryCapacityLabel, "North");
        this.memoryCapacitySlider = new JSlider(1, 0, 128, 16);
        this.memoryCapacitySlider.setBorder(BEVEL_BORDER);
        this.memoryCapacitySlider.createStandardLabels(64, 0);
        this.memoryCapacitySlider.setBackground(BACKGROUND);
        this.memoryCapacitySlider.setForeground(Color.black);
        this.memoryCapacitySlider.setPaintLabels(true);
        this.memoryCapacitySlider.setPaintTicks(true);
        this.memoryCapacitySlider.setMajorTickSpacing(32);
        this.memoryCapacitySlider.setMinorTickSpacing(8);
        this.memoryCapacitySlider.setSnapToTicks(false);
        this.memoryCapacitySlider.addChangeListener(this);
        jPanel.add(this.memoryCapacitySlider);
        this.add(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setBackground(LIGHT_BLUE);
        this.memoryThresholdLabel = new JLabel("75%");
        this.memoryThresholdLabel.setBackground(LIGHT_BLUE);
        this.memoryThresholdLabel.setForeground(Color.black);
        jPanel2.add((Component)this.memoryThresholdLabel, "North");
        this.memoryThresholdSlider = new JSlider(1, 0, 100, 75);
        this.memoryThresholdSlider.setBorder(BEVEL_BORDER);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        for (int i2 = 0; i2 <= 100; i2 += 10) {
            JLabel jLabel = new JLabel(i2 + "%");
            jLabel.setForeground(Color.black);
            hashtable.put(new Integer(i2), jLabel);
        }
        this.memoryThresholdSlider.setBackground(BACKGROUND);
        this.memoryThresholdSlider.setForeground(Color.black);
        this.memoryThresholdSlider.setPaintLabels(true);
        this.memoryThresholdSlider.setLabelTable(hashtable);
        this.memoryThresholdSlider.setPaintTicks(true);
        this.memoryThresholdSlider.setMajorTickSpacing(10);
        this.memoryThresholdSlider.setMinorTickSpacing(5);
        this.memoryThresholdSlider.setSnapToTicks(true);
        this.memoryThresholdSlider.addChangeListener(this);
        jPanel2.add(this.memoryThresholdSlider);
        this.add(jPanel2);
    }

    public void setTileCache(SunTileCache sunTileCache) {
        if (sunTileCache == null) {
            throw new IllegalArgumentException("cache cannot be null.");
        }
        if (!(sunTileCache instanceof SunTileCache)) {
            throw new IllegalArgumentException("cache not an instance of SunTileCache");
        }
        this.cache = sunTileCache;
        this.memoryCapacitySlider.setValue((int)(this.cache.getMemoryCapacity() / 0x100000L));
        this.memoryThresholdSlider.setValue((int)(100.0f * this.cache.getMemoryThreshold()));
    }

    public void setStatistics(Statistics statistics) {
        this.statistics = statistics;
    }

    public void setMemoryCapacitySliderMaximum(int n2) {
        if ((long)n2 <= 0L) {
            throw new IllegalArgumentException("max_mem must be greater than 0");
        }
        int n3 = (int)(this.cache.getMemoryCapacity() / 0x100000L);
        if (n2 < n3) {
            n2 = n3;
        }
        this.memoryCapacitySlider.setMaximum(n2);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        JSlider jSlider = (JSlider)changeEvent.getSource();
        if (jSlider == this.memoryCapacitySlider) {
            this.memoryCapacityLabel.setText(jSlider.getValue() + " MB");
            this.cache.setMemoryCapacity((long)jSlider.getValue() * 1024L * 1024L);
            if (this.statistics != null) {
                this.memoryCapacity = this.cache.getMemoryCapacity();
                this.memoryUsage = this.cache.getCacheMemoryUsed();
                this.percentTCM = (int)(100.0f * this.memoryUsage / this.memoryCapacity + 0.5f);
                this.statistics.set(this.percentTCM);
            }
        } else if (jSlider == this.memoryThresholdSlider) {
            this.memoryThresholdLabel.setText(jSlider.getValue() + "%");
            this.cache.setMemoryThreshold((float)jSlider.getValue() / 100.0f);
        }
    }
}

