/*
 * Decompiled with CFR 0.152.
 */
package GuiUtilities.Util.TileCacheMonitorTool;

import GuiUtilities.Util.TileCacheMonitorTool.EventViewer;
import GuiUtilities.Util.TileCacheMonitorTool.MemoryChart;
import GuiUtilities.Util.TileCacheMonitorTool.Statistics;
import GuiUtilities.Util.TileCacheMonitorTool.TCInfo;
import com.sun.media.jai.util.SunTileCache;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.RenderedImage;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.media.jai.CachedTile;
import javax.media.jai.EnumeratedParameter;
import javax.media.jai.JAI;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;

public final class TCTool
extends JFrame
implements ActionListener,
Observer {
    private SunTileCache cache = null;
    private Vector eventData = null;
    private int percentTCM = 0;
    private JPanel top_panel;
    private JButton gc_btn;
    private JButton flush_btn;
    private JButton reset_btn;
    private JButton quit_btn;
    private JMenu options_menu;
    private JMenuItem pack_item;
    private JMenu capacity_menu;
    private JMenu delay_menu;
    private JMenu rows_menu;
    private JMenu laf_menu;
    private JRadioButton rad1;
    private JRadioButton rad2;
    private JRadioButton rad3;
    private JRadioButton rad4;
    private static final String METAL = "javax.swing.plaf.metal.MetalLookAndFeel";
    private static final String WINDOWS = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
    private static final String MOTIF = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
    private static final String MAC = "com.sun.java.swing.plaf.mac.MacLookAndFeel";
    private String current_laf = "javax.swing.plaf.metal.MetalLookAndFeel";
    private final MemoryChart memoryChart = new MemoryChart();
    private final EventViewer eventViewer = new EventViewer();
    private final Statistics statistics = new Statistics();
    private final TCInfo information = new TCInfo();
    private static final Color LIGHT_BLUE = new Color(200, 200, 220);
    private static final LineBorder LINE_BORDER = new LineBorder(Color.darkGray, 1);
    private static final String[] capacities = new String[]{"32MB", "64MB", "128MB", "256MB", "512MB"};
    private static final String[] delays = new String[]{"10ms", "50ms", "100ms", "250ms", "500ms", "1000ms", "2000ms", "5000ms"};
    private static final String[] rows = new String[]{"1", "4", "7", "10", "15", "20"};
    private long tileSize = 0L;
    private long timeStamp = 0L;
    private long tileCount = 0L;
    private long cacheHits = 0L;
    private long cacheMisses = 0L;
    private long addTile = 0L;
    private long removeTile = 0L;
    private long removeFlushed = 0L;
    private long removeMemoryControl = 0L;
    private long updateAddTile = 0L;
    private long updateGetTile = 0L;
    private EnumeratedParameter[] actions;
    private int CACHE_EVENT_ADD;
    private int CACHE_EVENT_REMOVE;
    private int CACHE_EVENT_REMOVE_BY_FLUSH;
    private int CACHE_EVENT_REMOVE_BY_MEMORY_CONTROL;
    private int CACHE_EVENT_UPDATE_FROM_ADD;
    private int CACHE_EVENT_UPDATE_FROM_GETTILE;
    private int CACHE_EVENT_ABOUT_TO_REMOVE_TILE;
    private static final String about_msg = "<html><center>Tile Cache Tool</center<p><center>Version 1.0</center></p><p><center>Copyright (c) 2002, Virtual Visions Software, Inc.</center></p><p><center>All Rights Reserved</center></p><br></br></html>";

    public TCTool() {
        this.create(-1L, null);
    }

    public TCTool(long l2) {
        this.create(l2, null);
    }

    public TCTool(SunTileCache sunTileCache) {
        this.create(-1L, sunTileCache);
    }

    private JMenuItem createAboutBox() {
        JMenuItem jMenuItem = new JMenuItem("About...");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JOptionPane.showMessageDialog(TCTool.this.top_panel, TCTool.about_msg);
            }
        });
        return jMenuItem;
    }

    private void create(long l2, SunTileCache sunTileCache) {
        JComponent jComponent;
        int n2;
        this.setTitle("Tile Cache Tool");
        this.setDefaultCloseOperation(2);
        this.setBackground(LIGHT_BLUE);
        this.top_panel = new JPanel();
        this.top_panel.setLayout(new BorderLayout());
        this.getContentPane().add(this.top_panel);
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.setLayout(new FlowLayout(0, 15, 5));
        jMenuBar.setBackground(LIGHT_BLUE);
        this.options_menu = new JMenu("Options");
        this.pack_item = new JMenuItem("Refit Window");
        this.pack_item.addActionListener(this);
        this.pack_item.setToolTipText("Restore this window to original size.");
        this.capacity_menu = new JMenu("Max Memory");
        for (n2 = 0; n2 < capacities.length; ++n2) {
            jComponent = new JMenuItem(capacities[n2]);
            ((AbstractButton)jComponent).addActionListener(this);
            this.capacity_menu.add((JMenuItem)jComponent);
        }
        this.delay_menu = new JMenu("Time Delay");
        for (n2 = 0; n2 < delays.length; ++n2) {
            jComponent = new JMenuItem(delays[n2]);
            ((AbstractButton)jComponent).addActionListener(this);
            this.delay_menu.add((JMenuItem)jComponent);
        }
        this.rows_menu = new JMenu("Event Rows");
        this.rows_menu.addActionListener(this);
        for (n2 = 0; n2 < rows.length; ++n2) {
            jComponent = new JMenuItem(rows[n2]);
            ((AbstractButton)jComponent).addActionListener(this);
            this.rows_menu.add((JMenuItem)jComponent);
        }
        this.laf_menu = new JMenu("Look & Feel");
        JMenuItem jMenuItem = new JMenuItem("Metal");
        jMenuItem.addActionListener(this);
        this.laf_menu.add(jMenuItem);
        jMenuItem = new JMenuItem("Windows");
        jMenuItem.addActionListener(this);
        this.laf_menu.add(jMenuItem);
        jMenuItem = new JMenuItem("Motif");
        jMenuItem.addActionListener(this);
        this.laf_menu.add(jMenuItem);
        jMenuItem = new JMenuItem("Mac");
        jMenuItem.addActionListener(this);
        this.laf_menu.add(jMenuItem);
        this.options_menu.add(this.pack_item);
        this.options_menu.add(this.capacity_menu);
        this.options_menu.add(this.delay_menu);
        this.options_menu.add(this.rows_menu);
        this.options_menu.add(this.laf_menu);
        this.options_menu.add(this.createAboutBox());
        jMenuBar.add(this.options_menu);
        this.top_panel.add((Component)jMenuBar, "North");
        jComponent = new JPanel();
        jComponent.setLayout(new FlowLayout(0, 5, 0));
        jComponent.setBorder(LINE_BORDER);
        JLabel jLabel = new JLabel("Diagnostics:  ");
        jComponent.add(jLabel);
        this.rad1 = new JRadioButton("On", true);
        this.rad2 = new JRadioButton("Off");
        this.rad1.addActionListener(this);
        this.rad2.addActionListener(this);
        jComponent.add(this.rad1);
        jComponent.add(this.rad2);
        this.rad1.setToolTipText("Perform diagnostics monitoring");
        this.rad2.setToolTipText("Stop diagnostics monitoring");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rad1);
        buttonGroup.add(this.rad2);
        jMenuBar.add(jComponent);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 5, 0));
        jPanel.setBorder(LINE_BORDER);
        JLabel jLabel2 = new JLabel("Cache:  ");
        jPanel.add(jLabel2);
        this.rad3 = new JRadioButton("Enabled", true);
        this.rad4 = new JRadioButton("Disabled");
        this.rad3.addActionListener(this);
        this.rad4.addActionListener(this);
        jPanel.add(this.rad3);
        jPanel.add(this.rad4);
        this.rad3.setToolTipText("Resume normal cache operations");
        this.rad4.setToolTipText("Block new cache operations (status quo)");
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.rad3);
        buttonGroup2.add(this.rad4);
        jMenuBar.add(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setBackground(LIGHT_BLUE);
        this.top_panel.add((Component)jPanel2, "Center");
        this.cache = sunTileCache == null ? (SunTileCache)JAI.getDefaultInstance().getTileCache() : sunTileCache;
        this.actions = SunTileCache.getCachedTileActions();
        this.CACHE_EVENT_ADD = this.actions[0].getValue();
        this.CACHE_EVENT_REMOVE = this.actions[1].getValue();
        this.CACHE_EVENT_REMOVE_BY_FLUSH = this.actions[2].getValue();
        this.CACHE_EVENT_REMOVE_BY_MEMORY_CONTROL = this.actions[3].getValue();
        this.CACHE_EVENT_UPDATE_FROM_ADD = this.actions[4].getValue();
        this.CACHE_EVENT_UPDATE_FROM_GETTILE = this.actions[5].getValue();
        this.CACHE_EVENT_ABOUT_TO_REMOVE_TILE = this.actions[6].getValue();
        if (l2 >= 0L) {
            this.cache.setMemoryCapacity(l2);
        }
        this.cache.enableDiagnostics();
        this.cache.addObserver((Observer)this);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBackground(LIGHT_BLUE);
        jPanel3.setBorder(new EtchedBorder(1));
        jPanel3.setLayout(new FlowLayout(1, 10, 2));
        this.gc_btn = new JButton("Force GC");
        this.flush_btn = new JButton("Flush Cache");
        this.reset_btn = new JButton("Reset");
        this.quit_btn = new JButton("Quit");
        this.gc_btn.addActionListener(this);
        this.flush_btn.addActionListener(this);
        this.reset_btn.addActionListener(this);
        this.quit_btn.addActionListener(this);
        this.gc_btn.setToolTipText("Force a call to System.gc()");
        this.flush_btn.setToolTipText("Empty the tile cache.");
        this.reset_btn.setToolTipText("Clear counters and reset.");
        this.quit_btn.setToolTipText("Close the Tile Cache Tool window.");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(4, 1, 5, 15));
        jPanel4.setBackground(LIGHT_BLUE);
        jPanel4.add(this.gc_btn);
        jPanel4.add(this.flush_btn);
        jPanel4.add(this.reset_btn);
        jPanel4.add(this.quit_btn);
        jPanel3.add(jPanel4);
        this.information.setTileCache(this.cache);
        this.information.setBackground(LIGHT_BLUE);
        this.information.setStatistics(this.statistics);
        jPanel3.add(this.information);
        jPanel2.add((Component)jPanel3, "North");
        this.statistics.setBackground(LIGHT_BLUE);
        jPanel3.add(this.statistics);
        jPanel2.add((Component)this.memoryChart, "Center");
        this.memoryChart.start();
        JPanel jPanel5 = new JPanel();
        jPanel5.setBackground(LIGHT_BLUE);
        jPanel5.setLayout(new FlowLayout(1, 5, 5));
        jPanel5.add(this.eventViewer);
        jPanel2.add((Component)jPanel5, "South");
        final TCTool tCTool = this;
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                TCTool.this.memoryChart.stop();
                TCTool.this.cache.deleteObserver((Observer)tCTool);
                TCTool.this.cache.disableDiagnostics();
                TCTool.this.cache = null;
                System.gc();
            }

            public void windowIconified(WindowEvent windowEvent) {
                TCTool.this.memoryChart.stop();
            }

            public void windowDeiconified(WindowEvent windowEvent) {
                TCTool.this.memoryChart.start();
            }
        };
        this.addWindowListener(windowAdapter);
        this.pack();
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        AbstractButton abstractButton;
        Object object = actionEvent.getSource();
        if (object instanceof JRadioButton && (abstractButton = (JRadioButton)object).isSelected()) {
            if (abstractButton == this.rad1) {
                if (this.cache != null) {
                    this.cache.enableDiagnostics();
                    this.memoryChart.start();
                }
            } else if (abstractButton == this.rad2) {
                if (this.cache != null) {
                    this.cache.disableDiagnostics();
                    this.memoryChart.stop();
                }
            } else if (abstractButton == this.rad3) {
                JAI.enableDefaultTileCache();
            } else if (abstractButton == this.rad4) {
                JAI.disableDefaultTileCache();
            }
        }
        if (object instanceof JButton) {
            abstractButton = (JButton)object;
            if (abstractButton == this.gc_btn) {
                System.gc();
            } else if (abstractButton == this.flush_btn) {
                if (this.cache != null) {
                    this.cache.flush();
                }
            } else if (abstractButton == this.reset_btn) {
                if (this.cache != null) {
                    this.cache.flush();
                }
                this.tileCount = 0L;
                this.cacheHits = 0L;
                this.cacheMisses = 0L;
                this.addTile = 0L;
                this.removeTile = 0L;
                this.removeFlushed = 0L;
                this.removeMemoryControl = 0L;
                this.updateAddTile = 0L;
                this.updateGetTile = 0L;
                this.percentTCM = 0;
                this.statistics.set(this.tileCount, this.cacheHits, this.cacheMisses, this.addTile, this.removeTile, this.removeFlushed, this.removeMemoryControl, this.updateAddTile, this.updateGetTile, this.percentTCM);
                this.eventViewer.clear();
                System.gc();
            } else if (abstractButton == this.quit_btn) {
                this.memoryChart.stop();
                this.cache.deleteObserver((Observer)this);
                this.cache.disableDiagnostics();
                this.cache = null;
                this.dispose();
                System.gc();
            }
        }
        if (object instanceof JMenuItem) {
            abstractButton = (JMenuItem)object;
            if (abstractButton == this.pack_item) {
                this.pack();
            } else {
                int n2;
                String string = abstractButton.getText();
                if (string.equalsIgnoreCase("Metal")) {
                    this.setLookAndFeel(METAL);
                    return;
                }
                if (string.equalsIgnoreCase("Windows")) {
                    this.setLookAndFeel(WINDOWS);
                    return;
                }
                if (string.equalsIgnoreCase("Motif")) {
                    this.setLookAndFeel(MOTIF);
                    return;
                }
                if (string.equalsIgnoreCase("Mac")) {
                    this.setLookAndFeel(MAC);
                    return;
                }
                for (n2 = 0; n2 < capacities.length; ++n2) {
                    if (!string.equals(capacities[n2])) continue;
                    String string2 = capacities[n2].substring(0, capacities[n2].lastIndexOf("M"));
                    int n3 = Integer.parseInt(string2);
                    this.information.setMemoryCapacitySliderMaximum(n3);
                    return;
                }
                for (n2 = 0; n2 < delays.length; ++n2) {
                    if (!string.equals(delays[n2])) continue;
                    String string3 = delays[n2].substring(0, delays[n2].lastIndexOf("m"));
                    this.memoryChart.setDelay(Integer.parseInt(string3));
                    return;
                }
                for (n2 = 0; n2 < rows.length; ++n2) {
                    if (!string.equals(rows[n2])) continue;
                    this.eventViewer.setRows(Integer.parseInt(rows[n2]));
                    this.pack();
                    return;
                }
            }
        }
    }

    private void setLookAndFeel(String string) {
        if (this.current_laf != string) {
            this.current_laf = string;
            try {
                UIManager.setLookAndFeel(this.current_laf);
                SwingUtilities.updateComponentTreeUI(this);
                this.pack();
            }
            catch (Exception exception) {
                System.out.println("Look and Feel not supported.");
                this.current_laf = METAL;
            }
        }
    }

    public synchronized void update(Observable observable, Object object) {
        String string;
        SunTileCache sunTileCache = null;
        CachedTile cachedTile = null;
        int n2 = -1;
        if (!(observable instanceof SunTileCache)) {
            return;
        }
        sunTileCache = (SunTileCache)observable;
        if (object != null && object instanceof CachedTile) {
            cachedTile = (CachedTile)object;
            n2 = cachedTile.getAction();
            if (n2 == this.CACHE_EVENT_ABOUT_TO_REMOVE_TILE) {
                return;
            }
        } else {
            return;
        }
        RenderedImage renderedImage = cachedTile.getOwner();
        this.tileSize = cachedTile.getTileSize();
        this.timeStamp = cachedTile.getTileTimeStamp();
        this.cacheHits = sunTileCache.getCacheHitCount();
        this.cacheMisses = sunTileCache.getCacheMissCount();
        this.tileCount = sunTileCache.getCacheTileCount();
        float f2 = sunTileCache.getMemoryCapacity();
        float f3 = sunTileCache.getCacheMemoryUsed();
        this.percentTCM = (int)(100.0f * f3 / f2 + 0.5f);
        if (renderedImage != null) {
            String string2 = renderedImage.getClass().getName();
            string = string2.substring(string2.lastIndexOf(".") + 1);
        } else {
            string = "Op was removed by GC";
        }
        this.eventData = new Vector(5, 1);
        this.eventData.addElement(string);
        if (n2 == this.CACHE_EVENT_ADD) {
            this.eventData.addElement("Add");
            ++this.addTile;
        } else if (n2 == this.CACHE_EVENT_REMOVE) {
            this.eventData.addElement("Remove");
            ++this.removeTile;
        } else if (n2 == this.CACHE_EVENT_REMOVE_BY_FLUSH) {
            this.eventData.addElement("Remove by Flush");
            ++this.removeFlushed;
        } else if (n2 == this.CACHE_EVENT_REMOVE_BY_MEMORY_CONTROL) {
            this.eventData.addElement("Remove by Memory Control");
            ++this.removeMemoryControl;
        } else if (n2 == this.CACHE_EVENT_UPDATE_FROM_ADD) {
            this.eventData.addElement("Update from Add");
            ++this.updateAddTile;
        } else if (n2 == this.CACHE_EVENT_UPDATE_FROM_GETTILE) {
            this.eventData.addElement("Update from GetTile");
            ++this.updateGetTile;
        }
        this.eventData.addElement("" + this.tileSize);
        this.eventData.addElement("" + this.timeStamp);
        this.eventViewer.insertRow(0, this.eventData);
        this.statistics.set(this.tileCount, this.cacheHits, this.cacheMisses, this.addTile, this.removeTile, this.removeFlushed, this.removeMemoryControl, this.updateAddTile, this.updateGetTile, this.percentTCM);
    }
}

