/*
 * Decompiled with CFR 0.152.
 */
package GuiUtilities.Util;

import GuiUtilities.Util.CompositeScreen;
import java.awt.Rectangle;

public class WindowStats {
    private static final float WINDOW_UNMAXIMIZED_SCALE_FACTOR = 0.8f;
    private final Rectangle mBounds;
    private final Rectangle mMaximizedBounds;

    public WindowStats(CompositeScreen compositeScreen) {
        if (compositeScreen.getScreenCount() == 0) {
            throw new IllegalStateException("The passed composite screen must have screen elements.");
        }
        this.mBounds = WindowStats.scaleBounds(compositeScreen.getBounds(0, 3), 0.8f);
        this.mMaximizedBounds = compositeScreen.getScreenCount() > 1 ? compositeScreen.getEnclosingBounds(1) : null;
    }

    public Rectangle getBounds() {
        return this.mBounds;
    }

    public Rectangle getMaximizedBounds() {
        return this.mMaximizedBounds;
    }

    public Rectangle getDefaultBounds() {
        return this.mMaximizedBounds == null ? this.mBounds : this.mMaximizedBounds;
    }

    private static Rectangle scaleBounds(Rectangle rectangle, float f2) {
        double d2 = rectangle.getWidth();
        double d3 = rectangle.getHeight();
        int n2 = (int)(d2 - d2 * (double)f2) / 2;
        int n3 = (int)(d3 - d3 * (double)f2) / 2;
        return new Rectangle(rectangle.x + n2, rectangle.y + n3, rectangle.width - n2 * 2, rectangle.height - n3 * 2);
    }
}

