/*
 * Decompiled with CFR 0.152.
 */
package GuiUtilities.Worker;

import GuiUtilities.Dialog.ProgressDialog;
import GuiUtilities.Worker.Worker;
import javax.swing.SwingUtilities;

public class ProgressWorker
implements Worker {
    final ProgressDialog mProgressDialog;
    final Worker mWorker;

    public ProgressWorker(ProgressDialog progressDialog, Worker worker) {
        this.mProgressDialog = progressDialog;
        this.mWorker = worker;
    }

    public Object call() throws Exception {
        this.showProgressDialog();
        return this.mWorker.call();
    }

    public void handleCancel() {
        this.disposeProgressDialog();
        this.mWorker.handleCancel();
    }

    public void handleSuccess(Object object) {
        this.disposeProgressDialog();
        this.mWorker.handleSuccess(object);
    }

    public void handleException(Exception exception) {
        this.disposeProgressDialog();
        this.mWorker.handleException(exception);
    }

    private void showProgressDialog() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ProgressWorker.this.mProgressDialog.show();
            }
        });
    }

    private void disposeProgressDialog() {
        this.mProgressDialog.dispose();
    }
}

