/*
 * Decompiled with CFR 0.152.
 */
package InteleDicomLibrary.Client;

import InteleDicomLibrary.Client.DicomClientException;
import InteleDicomLibrary.Pacs.MoveRequest;
import InteleDicomLibrary.Services.DicomConnectionParameters;
import InteleDicomLibrary.Services.MoveScu;
import RuntimeTool.DebugManager;
import com.archimed.dicom.DicomException;
import com.intelerad.tools.lib.concurrent.Cancellable;
import com.intelerad.tools.lib.concurrent.CancellationException;

public class MoveClient
implements Cancellable {
    private final MoveRequest mMoveRequest;
    private final DicomConnectionParameters mConnectionParameters;
    private final String mDestinationAe;
    private boolean mCancelled;

    public MoveClient(MoveRequest moveRequest, DicomConnectionParameters dicomConnectionParameters, String string) {
        this.mMoveRequest = new MoveRequest(moveRequest);
        this.mConnectionParameters = dicomConnectionParameters;
        this.mDestinationAe = string;
    }

    public void cancel() {
        this.mCancelled = true;
    }

    public void move() throws DicomClientException {
        if (this.mCancelled) {
            throw new CancellationException("User cancelled");
        }
        MoveClient.moveStudiesOrSeries(this.mMoveRequest, this.mConnectionParameters, this.mDestinationAe);
    }

    private static void moveStudiesOrSeries(MoveRequest moveRequest, DicomConnectionParameters dicomConnectionParameters, String string) throws DicomClientException {
        MoveScu moveScu = new MoveScu(dicomConnectionParameters);
        moveScu.setDebug(DebugManager.getDefault());
        try {
            DebugManager.getDefault().printTrace("Making a DICOM move request from \"" + dicomConnectionParameters + "\" to \"" + string + "\" " + moveRequest);
            boolean bl2 = moveScu.moveStudies(moveRequest.getDicomObject(), string);
            if (!bl2) {
                throw new DicomClientException(moveScu.getErrorDetails());
            }
        }
        catch (DicomException dicomException) {
            throw new DicomClientException("In MoveClient.moveStudiesOrSeries(), could not convert the moveRequest into a DicomObjectmoveScu.getErrorDetails() " + dicomException.getMessage(), dicomException);
        }
    }
}

