/*
 * Decompiled with CFR 0.152.
 */
package InteleDicomLibrary.Print;

import InteleDicomLibrary.Services.DicomConnectionParameters;
import InteleDicomLibrary.Services.DimseException;
import InteleDicomLibrary.Services.DimseMessage;
import InteleDicomLibrary.Services.Scu;
import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.SOPInstance;
import com.archimed.dicom.UnknownUIDException;
import com.archimed.dicom.network.DimseUtil;
import com.archimed.dicom.tools.Sequences;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PrintManagementScu
extends Scu {
    private List mWarnings = new ArrayList();
    private final List mWarningStatusCodes = new ArrayList();

    public PrintManagementScu(DicomConnectionParameters dicomConnectionParameters, List list) {
        super(dicomConnectionParameters);
        this.mWarningStatusCodes.addAll(list);
    }

    protected boolean associate() throws IOException, IllegalValueException, UnknownUIDException {
        return this.associate(12292);
    }

    protected boolean release() throws IOException, IllegalValueException {
        return super.release();
    }

    DimseMessage getPrinter() throws DicomException, IllegalValueException, IOException, UnknownUIDException, DimseException {
        DicomObject dicomObject = DimseUtil.createNGetRequest((Integer)new Integer(mMessageId), (Integer)new Integer(4115), (String)SOPInstance.getUIDEntry((int)16387).getValue(), null);
        this.mDebug.printTrace("Getting Printer Status:");
        return this.sendRequest(new DimseMessage(dicomObject, null));
    }

    DimseMessage createFilmSession(Map map) throws DicomException, IllegalValueException, IOException, UnknownUIDException, DimseException {
        DicomObject dicomObject = DimseUtil.createCreateRequest((Integer)new Integer(mMessageId), (Integer)new Integer(4108), null, (boolean)true);
        DicomObject dicomObject2 = new DicomObject();
        this.copyAttributeValues(dicomObject2, map);
        this.mDebug.printTrace("Create Film Session:");
        return this.sendRequest(new DimseMessage(dicomObject, dicomObject2));
    }

    DimseMessage createFilmBox(String string, Map map) throws DicomException, IllegalValueException, IOException, UnknownUIDException, DimseException {
        DicomObject dicomObject = DimseUtil.createCreateRequest((Integer)new Integer(mMessageId), (Integer)new Integer(4109), null, (boolean)true);
        DicomObject dicomObject2 = new DicomObject();
        this.copyAttributeValues(dicomObject2, map);
        Sequences sequences = new Sequences(dicomObject2);
        sequences.set(725, 0, 115, (Object)SOPInstance.getUIDEntry((int)4108).getValue());
        sequences.set(725, 0, 116, (Object)string);
        DimseMessage dimseMessage = new DimseMessage(dicomObject, dicomObject2);
        this.mDebug.printTrace("Create Film Box:");
        return this.sendRequest(dimseMessage);
    }

    DimseMessage setImageBox(DicomObject dicomObject, int n2, DicomObject dicomObject2) throws DicomException, IllegalValueException, IOException, UnknownUIDException, DimseException {
        Sequences sequences = new Sequences(dicomObject);
        String string = sequences.getS(726, n2, 116);
        DicomObject dicomObject3 = DimseUtil.createSetRequest((Integer)new Integer(mMessageId), (Integer)new Integer(4110), (String)string);
        dicomObject2.set(729, (Object)new Integer(n2 + 1));
        this.mDebug.printTrace("Set image data into image box " + n2 + ":");
        return this.sendRequest(new DimseMessage(dicomObject3, dicomObject2));
    }

    DimseMessage printFilmBox(String string) throws DicomException, IllegalValueException, IOException, UnknownUIDException, DimseException {
        this.mDebug.printTrace("Printing Film Box " + string);
        return this.print(4109, string);
    }

    DimseMessage printFilmSession(String string) throws DicomException, IllegalValueException, IOException, UnknownUIDException, DimseException {
        this.mDebug.printTrace("Printing Film Session " + string);
        return this.print(4108, string);
    }

    private DimseMessage print(int n2, String string) throws DicomException, IllegalValueException, IOException, UnknownUIDException, DimseException {
        DicomObject dicomObject = DimseUtil.createActionRequest((Integer)new Integer(mMessageId), (Integer)new Integer(n2), (String)string, (boolean)false, (Integer)new Integer(1));
        DimseMessage dimseMessage = new DimseMessage(dicomObject, null);
        return this.sendRequest(dimseMessage);
    }

    DimseMessage deleteFilmSession(String string) throws DicomException, IllegalValueException, IOException, UnknownUIDException, DimseException {
        DicomObject dicomObject = DimseUtil.createDeleteRequest((Integer)new Integer(mMessageId), (Integer)new Integer(4108), (String)string);
        this.mDebug.printTrace("Closing session:");
        return this.sendRequest(new DimseMessage(dicomObject, null));
    }

    void deleteFilmBox(String string) throws DicomException, IllegalValueException, IOException, UnknownUIDException, DimseException {
        DicomObject dicomObject = DimseUtil.createDeleteRequest((Integer)new Integer(mMessageId), (Integer)new Integer(4109), (String)string);
        this.mDebug.printTrace("Deleting the film box:");
        this.sendRequest(new DimseMessage(dicomObject, null));
    }

    List getWarnings() {
        return new ArrayList(this.mWarnings);
    }

    private DimseMessage sendRequest(DimseMessage dimseMessage) throws DicomException, IOException, IllegalValueException, UnknownUIDException, DimseException {
        this.mDebug.printTrace(dimseMessage.toString());
        this.mAssociation.sendInPresentationContext(this.mPresentationContextId, dimseMessage.getHeader(), dimseMessage.getData());
        DicomObject dicomObject = this.mAssociation.receiveCommand();
        Integer n2 = (Integer)dicomObject.get(9);
        this.mDebug.printTrace("Response status: " + n2);
        this.handleUnsuccessfulStatus(dimseMessage, n2);
        DimseMessage dimseMessage2 = this.constructResponse(dicomObject);
        this.mDebug.printTrace(dimseMessage2.toString());
        return dimseMessage2;
    }

    private DimseMessage constructResponse(DicomObject dicomObject) throws IOException, IllegalValueException, DicomException, UnknownUIDException {
        Integer n2 = (Integer)dicomObject.get(8);
        boolean bl2 = n2 != null && DATASET_TYPE_NO_DATA.equals(n2);
        return new DimseMessage(dicomObject, bl2 ? null : this.mAssociation.receiveData());
    }

    private void handleUnsuccessfulStatus(DimseMessage dimseMessage, Integer n2) throws DimseException {
        if (!SUCCESS.equals(n2)) {
            throw new DimseException(dimseMessage, n2);
        }
        if (this.mWarningStatusCodes.contains(n2)) {
            this.mWarnings.add(new DimseException(dimseMessage, n2));
        }
    }

    private void copyAttributeValues(DicomObject dicomObject, Map map) throws DicomException {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n2 = (Integer)iterator.next();
            Object v2 = map.get(n2);
            dicomObject.set(n2.intValue(), v2);
        }
    }
}

