/*
 * Decompiled with CFR 0.152.
 */
package InteleDicomLibrary.Services;

import InteleDicomLibrary.Services.DicomConnectionParameters;
import InteleDicomLibrary.Services.Scu;
import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.UnknownUIDException;
import com.archimed.dicom.network.Abort;
import com.archimed.dicom.network.DimseUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class FindScu
extends Scu {
    private static final String mDebugKey = "FindScu";
    protected ArrayList mFoundDicomObjectList = null;
    private boolean mMaxNumberReached = false;

    public FindScu(String string, int n2, String string2, String string3) {
        super(string, n2, string2, string3);
    }

    public FindScu(DicomConnectionParameters dicomConnectionParameters) {
        super(dicomConnectionParameters);
    }

    public void clearSearchResults() {
        this.mFoundDicomObjectList = null;
    }

    public List findPatients(DicomObject dicomObject) {
        return this.findPatients(dicomObject, -1);
    }

    public List findPatients(DicomObject dicomObject, int n2) {
        if (n2 == -1) {
            n2 = Integer.MAX_VALUE;
        }
        try {
            this.mFoundDicomObjectList = new ArrayList();
            if (!this.associate(4135)) {
                return null;
            }
            if (!this.exchangeFind(mMessageId, dicomObject, n2)) {
                return null;
            }
            if (this.mMaxNumberReached) {
                return this.mFoundDicomObjectList;
            }
            if (!this.release()) {
                return null;
            }
            return this.mFoundDicomObjectList;
        }
        catch (IOException iOException) {
            this.mFoundDicomObjectList = null;
            RuntimeException runtimeException = new RuntimeException(iOException.toString());
            runtimeException.setStackTrace(iOException.getStackTrace());
            throw runtimeException;
        }
        catch (IllegalValueException illegalValueException) {
            this.mFoundDicomObjectList = null;
            RuntimeException runtimeException = new RuntimeException(illegalValueException.toString());
            runtimeException.setStackTrace(illegalValueException.getStackTrace());
            throw runtimeException;
        }
        catch (DicomException dicomException) {
            this.mFoundDicomObjectList = null;
            RuntimeException runtimeException = new RuntimeException(dicomException.toString());
            runtimeException.setStackTrace(dicomException.getStackTrace());
            throw runtimeException;
        }
        catch (UnknownUIDException unknownUIDException) {
            this.mFoundDicomObjectList = null;
            RuntimeException runtimeException = new RuntimeException(unknownUIDException.toString());
            runtimeException.setStackTrace(unknownUIDException.getStackTrace());
            throw runtimeException;
        }
    }

    private boolean exchangeFind(int n2, DicomObject dicomObject, int n3) throws DicomException, IllegalValueException, IOException, UnknownUIDException {
        Integer n4;
        DicomObject dicomObject2 = DimseUtil.createFindRequest((Integer)new Integer(n2), (Integer)new Integer(4135), (Integer)new Integer(1));
        this.mAssociation.sendInPresentationContext(this.mPresentationContextId, dicomObject2, dicomObject);
        DicomObject dicomObject3 = null;
        do {
            dicomObject3 = this.mAssociation.receiveCommand();
            n4 = new Integer(dicomObject3.getI(9));
            this.mDebug.print(mDebugKey, "Find response status = " + n4.toString() + " [" + mStatusCodes.get(n4) + "]");
            if (this.hasPendingSubOperations(n4)) {
                n4 = new Integer(this.storeFindResponse(n2, dicomObject3));
            }
            if (this.mFoundDicomObjectList.size() < n3) continue;
            this.mAssociation.sendAbort(Abort.DICOM_UL_SERVICE_USER, Abort.REASON_NOT_SPECIFIED);
            this.mMaxNumberReached = true;
            this.mDebug.print(mDebugKey, "Max number of search results " + n3 + " has been reached. Aborting prematurely.");
            this.close();
            return true;
        } while (this.hasPendingSubOperations(n4));
        if (!SUCCESS.equals(n4)) {
            this.mErrorDetails = "Non succesful status in C-FIND RESPONSE: " + n4.toString() + " [" + mStatusCodes.get(n4) + "]" + ". Aborting association.";
            this.mDebug.printError(this.mErrorDetails);
            this.mAssociation.sendAbort(Abort.DICOM_UL_SERVICE_USER, Abort.REASON_NOT_SPECIFIED);
            return false;
        }
        this.mErrorDetails = "";
        return true;
    }

    private boolean hasPendingSubOperations(Integer n2) {
        return PENDING_SUB_OPERATIONS.equals(n2) || PENDING_SUB_OPERATIONS_WITH_WARNING.equals(n2);
    }

    private int storeFindResponse(int n2, DicomObject dicomObject) throws IOException, IllegalValueException, DicomException, UnknownUIDException {
        this.mDebug.print(mDebugKey, "*************** C-FIND COMMAND RESPONSE ****************");
        this.mDebug.print(mDebugKey, "Received commandtype: " + DimseUtil.getCommandName((int)DimseUtil.getCommandType((DicomObject)dicomObject)));
        if (DimseUtil.getCommandType((DicomObject)dicomObject) != 32800) {
            this.mDebug.printError("No C-FIND RESPONSE command field : " + DimseUtil.getCommandType((DicomObject)dicomObject) + ". Aborting association");
            this.mAssociation.sendAbort(Abort.DICOM_UL_SERVICE_USER, Abort.REASON_NOT_SPECIFIED);
            return -1;
        }
        if (DimseUtil.getAffectedSOPClass((DicomObject)dicomObject) != 4135) {
            this.mDebug.printError("Affected SOP Class UID in C-FIND RESPONSE wrong: expecting [4135], received [" + DimseUtil.getAffectedSOPClass((DicomObject)dicomObject) + "]" + ". Aborting association");
            this.mAssociation.sendAbort(Abort.DICOM_UL_SERVICE_USER, Abort.REASON_NOT_SPECIFIED);
            return -1;
        }
        if (DimseUtil.getMessageIDBeingRespondedTo((DicomObject)dicomObject) != n2) {
            this.mDebug.printError("Message ID in C-FIND RESPONSE wrong: expecting [" + n2 + "], received [" + DimseUtil.getMessageIDBeingRespondedTo((DicomObject)dicomObject) + "]" + ". Aborting association");
            this.mAssociation.sendAbort(Abort.DICOM_UL_SERVICE_USER, Abort.REASON_NOT_SPECIFIED);
            return -1;
        }
        DicomObject dicomObject2 = this.mAssociation.receiveData();
        this.mDebug.print(mDebugKey, "**************** RECEIVED FIND DATA ********************\n" + dicomObject2.toString());
        this.mFoundDicomObjectList.add(dicomObject2);
        return dicomObject.getI(9);
    }
}

