/*
 * Decompiled with CFR 0.152.
 */
package J2cProtocol;

import J2cProtocol.AnswerableMessage;
import J2cProtocol.AssociationReader;
import J2cProtocol.DisconnectMessage;
import J2cProtocol.J2cAbruptDisconnectException;
import J2cProtocol.J2cProtocolException;
import J2cProtocol.Message;
import J2cProtocol.MessageFactory;
import J2cProtocol.NoDataToSendMessage;
import J2cProtocol.PauseRequestMessage;
import J2cProtocol.ResumeRequestMessage;
import J2cProtocol.State;
import TimeUtilities.StopWatch;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class Association {
    public static final int NORMAL_STATUS = 0;
    public static final int SERIES_ERROR_STATUS = 1;
    public static final int CODESTREAM_ERROR_STATUS = 2;
    public static final int ABNORMAL_STATUS = 3;
    public static final int INCOMPATIBLE_VERSION = 4;
    static final int DEFAULT_BUFFER_LENGTH = 2048;
    static final int MAJOR_VERSION_NUMBER = 0;
    static final int MINOR_VERSION_NUMBER = 0;
    static final int BITS_PER_BYTE = 8;
    static final int SIZE_OF_INT = 4;
    static final int SIZE_OF_SHORT = 2;
    static final int MAXIMUM_UNSIGNED_SHORT_VALUE = 65535;
    static final long MAXIMUM_PROCESS_LOOP_TIME = 100L;
    private DataInputStream mInput;
    private DataOutputStream mOutput;
    private MessageFactory mMessageFactory;
    private State mAssociationState = State.UNCONNECTED;
    private DisconnectMessage mDisconnectMessage = null;
    private boolean mRequestDisconnect = false;
    private int mMaximumBufferLength = 1024;
    private byte[] mOutputBuffer;
    private long mBytesWritten = 0L;
    private long mBytesRead = 0L;
    private final StopWatch mTimeConnected;
    private final StopWatch mTimePaused;
    private final StopWatch mTimeReading;
    private boolean mOkToSend = true;
    private AssociationReader mReader;
    private volatile ConnectionState mConnectionState = ConnectionState.INITIAL;
    private int mPauseCounter = 0;
    private Message mPauseMessage = null;
    private boolean mShouldSendNoDataMessages = false;
    private boolean mNoDataMessageAlreadySent = false;
    private volatile boolean mIsClosed;
    private volatile int mWorkCounter = 1;

    public Association(InputStream inputStream, OutputStream outputStream, MessageFactory messageFactory) {
        this(inputStream, outputStream, messageFactory, StopWatch.DEFAULT_STOP_WATCH_FACTORY);
    }

    public Association(InputStream inputStream, OutputStream outputStream, MessageFactory messageFactory, StopWatch.StopWatchFactory stopWatchFactory) {
        this.mInput = new DataInputStream(new BufferedInputStream(inputStream));
        this.mOutput = new DataOutputStream(new BufferedOutputStream(outputStream));
        this.mMessageFactory = messageFactory;
        this.mIsClosed = false;
        this.mTimeConnected = stopWatchFactory.createStopWatch();
        this.mTimePaused = stopWatchFactory.createStopWatch();
        this.mTimeReading = stopWatchFactory.createStopWatch();
    }

    protected StopWatch getConnectionStopWatch() {
        return this.mTimeConnected;
    }

    protected StopWatch getPauseStopWatch() {
        return this.mTimePaused;
    }

    protected StopWatch getReadStopWatch() {
        return this.mTimeReading;
    }

    protected abstract Message createOutgoingMessage();

    protected abstract void handleNextIteration();

    public abstract void debug(String var1);

    public abstract void trace(String var1);

    public abstract void error(String var1, Throwable var2);

    public void setDisconnectMessage(DisconnectMessage disconnectMessage) {
        if (this.mDisconnectMessage != null) {
            return;
        }
        this.mDisconnectMessage = disconnectMessage;
        this.mRequestDisconnect = true;
        this.wakeup();
    }

    void recordDisconnectMessage(DisconnectMessage disconnectMessage) {
        if (this.mDisconnectMessage != null) {
            return;
        }
        this.mDisconnectMessage = disconnectMessage;
    }

    public DisconnectMessage getDisconnectMessage() {
        return this.mDisconnectMessage;
    }

    private boolean doDisconnect() {
        return this.mRequestDisconnect;
    }

    public void stopServicing() {
        this.setConnectionState(ConnectionState.SHUTTING_DOWN);
    }

    public byte[] getInputBuffer() {
        return new byte[this.mMaximumBufferLength];
    }

    public byte[] getOutputBuffer() {
        return this.mOutputBuffer;
    }

    public void setupBuffers(int n2) {
        this.mMaximumBufferLength = n2;
        this.mOutputBuffer = new byte[n2];
    }

    protected State getState() {
        return this.mAssociationState;
    }

    protected void advanceState(Message message) {
        this.mAssociationState = this.mAssociationState.getNextState(message);
    }

    protected void writeMessage(Message message) throws J2cProtocolException {
        try {
            this.mOutput.writeShort(message.getCode());
            message.write(this.mOutput);
            this.mOutput.flush();
            this.mBytesWritten += (long)(2 + message.getLength());
        }
        catch (IOException iOException) {
            if (this.mReader.hasReceivedDisconnect()) {
                this.trace("Unimportant write error: " + iOException + " (reader has received DisconnectMessage)");
            }
            throw new J2cAbruptDisconnectException(iOException);
        }
    }

    void setConnectionState(ConnectionState connectionState) {
        this.mConnectionState = connectionState;
    }

    boolean isServicing() {
        return this.mConnectionState == ConnectionState.SERVICING;
    }

    boolean isShuttingDown() {
        return this.mConnectionState == ConnectionState.SHUTTING_DOWN;
    }

    boolean isActive() {
        ConnectionState connectionState = this.mConnectionState;
        return connectionState == ConnectionState.SERVICING || connectionState == ConnectionState.SHUTTING_DOWN;
    }

    public void serviceAssociation() throws J2cProtocolException {
        this.setConnectionState(ConnectionState.SERVICING);
        this.mTimeConnected.start();
        try {
            this.serviceLoop();
            this.setConnectionState(ConnectionState.SHUTTING_DOWN);
            if (this.mReader != null) {
                this.mReader.waitForShutdown();
            }
            this.setConnectionState(ConnectionState.FINISHED);
        }
        catch (J2cProtocolException j2cProtocolException) {
            try {
                this.writeMessage(new DisconnectMessage(3, "Exception in serviceAssociation: " + j2cProtocolException.getMessage()));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw j2cProtocolException;
        }
        finally {
            this.mTimeConnected.stop();
            this.logConnectionStats();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serviceLoop() throws J2cProtocolException {
        this.trace("Creating a read thread");
        this.createReadThread();
        while (this.isServicing()) {
            Thread.yield();
            Message message = null;
            AnswerableMessage answerableMessage = this.processIncomingMessages();
            this.handleNextIteration();
            if (this.isShuttingDown()) {
                message = null;
            }
            if (this.doDisconnect()) {
                message = this.getDisconnectMessage();
            }
            if (message == null && answerableMessage != null) {
                message = answerableMessage.createAnswerMessage(this);
            }
            if (message == null && (this.isOkToSend() || this.getState() != State.DATA_EXCHANGE)) {
                message = this.createOutgoingMessage();
            }
            if (message == null && this.mPauseMessage != null) {
                Association association = this;
                synchronized (association) {
                    message = this.mPauseMessage;
                    this.mPauseMessage = null;
                }
            }
            this.decrementWorkCounter();
            if (message != null) {
                this.incrementWorkCounter();
            }
            if (message == null) {
                message = this.getNoDataToSendMessage();
            }
            if (message == null) continue;
            this.writeMessage(message);
            this.handleDisconnectMessage(message);
            message.updateAssociationOnOutput(this);
        }
        try {
            this.mOutput.close();
        }
        catch (IOException iOException) {
            this.trace("Unexpected exception when closing output: " + iOException.toString());
        }
        this.trace("Stopped servicing");
    }

    private AnswerableMessage processIncomingMessages() throws J2cProtocolException {
        Message message;
        boolean bl2;
        AnswerableMessage answerableMessage = null;
        long l2 = System.currentTimeMillis();
        long l3 = 0L;
        if (this.mReader.hasIncomingMessage()) {
            this.mReader.suspendReading();
        }
        do {
            if ((message = this.mReader.getIncomingMessage()) != null) {
                message.validateMessage(this.mAssociationState);
                this.mNoDataMessageAlreadySent = false;
                message.process(this);
                message.updateAssociationOnInput(this);
                this.advanceState(message);
            }
            if (message instanceof AnswerableMessage) {
                answerableMessage = (AnswerableMessage)((Object)message);
            }
            l3 = System.currentTimeMillis() - l2;
        } while (bl2 = !(message instanceof DisconnectMessage) && answerableMessage == null && l3 < 100L && this.mReader.hasIncomingMessage());
        int n2 = this.mReader.numberOfMessagesInQueue();
        if (l3 >= 100L && n2 > 0) {
            this.debug("Cannot consume all messages. Elapsed time = " + l3 + ", messages remaining = " + n2);
        }
        this.mReader.resumeReading();
        return answerableMessage;
    }

    private Message getNoDataToSendMessage() {
        if (!this.mShouldSendNoDataMessages) {
            return null;
        }
        if (this.mNoDataMessageAlreadySent) {
            return null;
        }
        if (this.getState() != State.DATA_EXCHANGE) {
            return null;
        }
        if (!this.isOkToSend()) {
            return null;
        }
        this.trace("Sending NoDataToSendMessage");
        this.mNoDataMessageAlreadySent = true;
        return new NoDataToSendMessage();
    }

    private void handleDisconnectMessage(Message message) throws J2cProtocolException {
        if (message instanceof DisconnectMessage) {
            DisconnectMessage disconnectMessage = (DisconnectMessage)message;
            this.logDisconnectMessage(disconnectMessage);
            this.drainInputMessages();
        }
    }

    private void logDisconnectMessage(DisconnectMessage disconnectMessage) {
        String string = "Disconnect status = " + disconnectMessage.getStatus() + ": " + disconnectMessage.getDescription();
        if (disconnectMessage.getStatus() == 0) {
            this.trace(string);
        } else {
            this.trace("ERROR: Abnormal disconnect for association. " + string);
        }
    }

    private void drainInputMessages() throws J2cProtocolException {
    }

    public void close() {
        if (this.mIsClosed) {
            return;
        }
        this.mIsClosed = true;
        try {
            this.mOutput.close();
            this.mInput.close();
        }
        catch (IOException iOException) {
            this.trace("Unexpected exception closing input or output stream: " + iOException);
        }
    }

    public boolean isClosed() {
        return this.mIsClosed;
    }

    protected void finalize() {
        try {
            if (!this.mIsClosed) {
                this.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void logConnectionStats() {
    }

    void incrementBytesRead(long l2) {
        this.mBytesRead += l2;
    }

    public long getBytesRead() {
        return this.mBytesRead;
    }

    public long getBytesWritten() {
        return this.mBytesWritten;
    }

    protected void setSendNoDataMessages(boolean bl2) {
        this.mShouldSendNoDataMessages = bl2;
    }

    protected void setOkToSend(boolean bl2) {
        this.mOkToSend = bl2;
    }

    protected boolean isOkToSend() {
        return this.mOkToSend;
    }

    private synchronized void incrementWorkCounter() {
        this.mWorkCounter = this.mWorkCounter >= 0 ? ++this.mWorkCounter : 1;
    }

    private synchronized void decrementWorkCounter() {
        this.mWorkCounter = this.mWorkCounter > 0 ? --this.mWorkCounter : 0;
    }

    boolean haveWorkToDo() {
        return this.mWorkCounter > 0;
    }

    public void wakeup() {
        if (this.mReader == null) {
            return;
        }
        this.incrementWorkCounter();
        this.mReader.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        boolean bl2 = false;
        Association association = this;
        synchronized (association) {
            ++this.mPauseCounter;
            if (this.mPauseCounter == 1) {
                this.setOkToSend(false);
                this.trace("Requesting that a pause message be sent");
                this.mPauseMessage = new PauseRequestMessage();
                bl2 = true;
            }
        }
        if (bl2) {
            this.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        boolean bl2 = false;
        Association association = this;
        synchronized (association) {
            --this.mPauseCounter;
            if (this.mPauseCounter == 0) {
                this.trace("Requesting that a resume message be sent");
                this.mPauseMessage = new ResumeRequestMessage();
                this.setOkToSend(true);
                bl2 = true;
            }
        }
        if (bl2) {
            this.wakeup();
        }
    }

    protected void setPauseState() {
        ++this.mPauseCounter;
    }

    void handlePauseRequest() {
        this.trace("Received pause request");
        this.setOkToSend(false);
    }

    void handleResumeRequest() {
        this.trace("Received resume request");
        this.setOkToSend(true);
    }

    private void createReadThread() {
        this.mReader = new AssociationReader(this, this.mMessageFactory, this.mInput);
        this.mReader.start();
    }

    void checkVersionCompatibility(int n2, int n3) {
        if (n2 < 0) {
            this.setDisconnectMessage(new DisconnectMessage(4, "Protocol version 0.0 is not compatible with protocol version " + n2 + "." + n3));
        }
    }

    public static String getProtocolVersionString() {
        return "0.0";
    }

    static class ConnectionState {
        static ConnectionState INITIAL = new ConnectionState("INITIAL");
        static ConnectionState SERVICING = new ConnectionState("SERVICING");
        static ConnectionState SHUTTING_DOWN = new ConnectionState("SHUTTING_DOWN");
        static ConnectionState FINISHED = new ConnectionState("FINISHED");
        private String mName;

        private ConnectionState(String string) {
            this.mName = string;
        }

        public String toString() {
            return this.mName;
        }
    }
}

