/*
 * Decompiled with CFR 0.152.
 */
package J2cProtocol;

import J2cProtocol.AnswerableMessage;
import J2cProtocol.Association;
import J2cProtocol.ConnectReplyMessage;
import J2cProtocol.J2cProtocolException;
import J2cProtocol.Message;
import J2cProtocol.State;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ConnectRequestMessage
extends Message
implements AnswerableMessage {
    private static final String CLIENT_ID_LINE_SEPARATOR = "\n";
    private static final String CLIENT_ID_KEY_SEPARATOR = "=";
    private static final String USER_NAME_KEY = "Username";
    private static final String SESSION_ID_KEY = "SessionID";
    private String mClientId = "";
    private String mClientAddress = "";
    private int mMajorVersion = 0;
    private int mMinorVersion = 0;
    private String mUsername = "";
    private String mSessionId = "";

    public ConnectRequestMessage() {
    }

    public ConnectRequestMessage(String string, String string2, String string3, String string4) {
        this.setClientId(string);
        this.setUsername(string2);
        this.setSessionId(string3);
        this.setClientAddress(string4);
    }

    public void setClientId(String string) {
        this.mClientId = string;
    }

    public String getClientId() {
        return this.mClientId;
    }

    public void setClientAddress(String string) {
        this.mClientAddress = string;
    }

    public void setUsername(String string) {
        this.mUsername = string;
    }

    public void setSessionId(String string) {
        this.mSessionId = string;
    }

    public String getClientAddress() {
        return this.mClientAddress;
    }

    public int getMajorVersionNumber() {
        return this.mMajorVersion;
    }

    public int getMinorVersionNumber() {
        return this.mMinorVersion;
    }

    public String getUsername() {
        return this.mUsername;
    }

    public String getSessionId() {
        return this.mSessionId;
    }

    public final void updateAssociationOnInput(Association association) throws J2cProtocolException {
        association.checkVersionCompatibility(this.getMajorVersionNumber(), this.getMinorVersionNumber());
    }

    public Message createAnswerMessage(Association association) throws J2cProtocolException {
        return new ConnectReplyMessage(2048);
    }

    public void read(DataInputStream dataInputStream) throws IOException, J2cProtocolException {
        this.parseClientId(ConnectRequestMessage.readString(dataInputStream));
        this.setClientAddress(ConnectRequestMessage.readString(dataInputStream));
        this.mMajorVersion = dataInputStream.readShort();
        this.mMinorVersion = dataInputStream.readShort();
    }

    private void parseClientId(String string) {
        String[] stringArray = string.split(CLIENT_ID_LINE_SEPARATOR);
        if (stringArray.length < 1) {
            return;
        }
        this.setClientId(stringArray[0]);
        for (int i2 = 1; i2 < stringArray.length; ++i2) {
            String[] stringArray2 = stringArray[i2].split(CLIENT_ID_KEY_SEPARATOR, 2);
            if (stringArray2.length != 2) continue;
            String string2 = stringArray2[0];
            String string3 = stringArray2[1];
            if (string2.equals(USER_NAME_KEY)) {
                this.setUsername(string3);
                continue;
            }
            if (!string2.equals(SESSION_ID_KEY)) continue;
            this.setSessionId(string3);
        }
    }

    public void write(DataOutputStream dataOutputStream) throws IOException, J2cProtocolException {
        String string = this.getClientId() + CLIENT_ID_LINE_SEPARATOR + USER_NAME_KEY + CLIENT_ID_KEY_SEPARATOR + this.getUsername() + CLIENT_ID_LINE_SEPARATOR + SESSION_ID_KEY + CLIENT_ID_KEY_SEPARATOR + this.getSessionId();
        ConnectRequestMessage.writeString(dataOutputStream, string);
        ConnectRequestMessage.writeString(dataOutputStream, this.getClientAddress());
        dataOutputStream.writeShort(this.mMajorVersion);
        dataOutputStream.writeShort(this.mMinorVersion);
    }

    public int getLength() {
        return ConnectRequestMessage.writeStringLength(this.getClientId()) + ConnectRequestMessage.writeStringLength(this.getClientAddress()) + 4;
    }

    public int getCode() {
        return 28951;
    }

    public void validateMessage(State state) throws J2cProtocolException {
        this.validateMessage(state, State.ESTABLISHING_CONNECTION);
    }
}

